set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6700116';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '0023121',
      0.244943,
      1.937591,
      0,
      2,
      '4314',
      1,
      NULL,
      NULL,
      NULL,
      ' 9-21-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      1.065293,
      ' 1-23-1975',
      6,
      0,
      151.291543,
      48,
      2,
      '10-18-1999',
      NULL,
      '10-26-1979',
      2,
      1.522572,
      2,
      1,
      1.558895,
      2,
      2,
      0.613001,
      1.444022,
      141.999806,
      3,
      8,
      3,
      13,
      0.323223,
      4,
      0,
      NULL,
      NULL,
      4.553690,
      2.017250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      NULL,
      5,
      3,
      NULL,
      2,
      2,
      NULL,
      5,
      NULL,
      4,
      3,
      1,
      NULL,
      3,
      0,
      NULL,
      0,
      1,
      0.621585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      1,
      1.210712,
      0,
      1,
      0.540484,
      2.331642,
      1.460711,
      NULL,
      3.620641,
      2,
      1,
      0.663208,
      2,
      0,
      3.311079,
      NULL,
      0,
      1,
      3,
      8,
      1,
      0,
      3.627281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      3,
      0,
      0,
      3,
      5,
      0,
      4,
      0,
      3,
      1,
      1,
      0.290605,
      0,
      NULL,
      1,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      1,
      1,
      NULL,
      1,
      NULL,
      2,
      1,
      4,
      3,
      NULL,
      0,
      4,
      5,
      5,
      3,
      4,
      NULL,
      2,
      2,
      4,
      NULL,
      2.696589,
      0,
      ' 9-23-1993',
      757.683613,
      NULL,
      234.221607,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755947,
      1,
      NULL,
      3.262188,
      3,
      NULL,
      0,
      NULL,
      1.986109,
      0,
      5.999125,
      2,
      NULL,
      NULL,
      NULL,
      0,
      4.428838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.334053,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      141.244546,
      3.606817,
      1,
      0,
      NULL,
      70,
      NULL,
      1.724854,
      2,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.478250,
      2.693236,
      2.834638,
      0.433003,
      1,
      0,
      5.460338,
      2,
      1.714946,
      3,
      0.825740,
      1.230040,
      NULL,
      1.745761,
      NULL,
      0,
      1,
      1,
      0.280762,
      NULL,
      8.313196,
      1.279366,
      0.471312,
      3,
      1,
      4.861616,
      NULL,
      7.136641,
      1.129658,
      2.424897,
      0.138610,
      42.337345,
      0,
      0,
      NULL,
      NULL,
      NULL,
      14.543358,
      3,
      0.041255,
      NULL,
      '21402',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1.674580,
      '',
      NULL,
      '',
      3,
      6.186954,
      285.187046,
      NULL,
      0,
      40.108380,
      3.438940,
      NULL,
      3,
      NULL,
      2.580425,
      0,
      2.478908,
      3.441389,
      0,
      3,
      0,
      1.610326,
      NULL,
      2.876710,
      0.968764,
      2.067103,
      1.473158,
      3,
      3,
      1,
      0.753423,
      3.769847,
      NULL,
      NULL,
      0.608436,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.419005,
      NULL,
      0,
      3.817893,
      0,
      2,
      0,
      NULL,
      NULL,
      2,
      5,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.090663,
      NULL,
      NULL,
      NULL,
      1.480280,
      NULL,
      2.631895,
      NULL,
      NULL,
      0.786542,
      NULL,
      2.834446,
      1,
      2.238507,
      2.685605,
      0,
      3.718586,
      2,
      3,
      0,
      1.424113,
      3.441687,
      2.702468,
      NULL,
      1.731971,
      0.563285,
      0.738135,
      NULL,
      2.187837,
      0,
      3,
      2.885439,
      0,
      NULL,
      NULL,
      NULL,
      1.652603,
      NULL,
      1.347879,
      2.607846,
      7.528992,
      1,
      1.821799,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.702400,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.102979,
      2.663523,
      1,
      NULL,
      NULL,
      3,
      7,
      7,
      3,
      1.631869,
      0.223571,
      0.125602,
      1.660837,
      3.217346,
      5.615794,
      0.548563,
      NULL,
      0,
      NULL,
      NULL,
      0.706859,
      NULL,
      NULL,
      1.148901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.621930,
      NULL,
      NULL,
      NULL,
      0.125308,
      1,
      3,
      1.283469,
      1,
      6.662358,
      NULL,
      3,
      1,
      NULL,
      2.599127,
      2,
      0,
      2.834458,
      1.499707,
      3,
      2,
      1,
      2.982395,
      3,
      0.638740,
      NULL,
      NULL,
      9,
      2,
      1.896021,
      2.405709,
      0.613999,
      NULL,
      0.173584,
      3.225712,
      NULL,
      2.428173,
      0.281542,
      2,
      0,
      NULL,
      0,
      1.021620,
      1.893340,
      0,
      NULL,
      2.475713,
      3,
      0,
      NULL,
      4,
      0.938581,
      NULL,
      1.095620,
      0,
      1,
      3.662544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.840039,
      NULL,
      NULL,
      0.732347,
      NULL,
      NULL,
      0.260146,
      NULL,
      NULL,
      0.008728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.953531,
      NULL,
      NULL,
      3.094206,
      NULL,
      NULL,
      1.397930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1.110196,
      1.084526,
      0,
      1,
      0,
      3.126526,
      0.357043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020278,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.091555,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.036989,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.841688,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.317900,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.296514,
      NULL,
      NULL,
      NULL,
      1,
      105,
      95.359650,
      2,
      0,
      1.409296,
      NULL,
      NULL,
      NULL,
      1,
      61.561449,
      6,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.989941,
      NULL,
      1.708613,
      59.051731,
      1,
      NULL,
      3,
      NULL,
      0.493035,
      NULL,
      0,
      1,
      0,
      1.459003,
      1.397675,
      1.721239,
      1.325457,
      1.685344,
      1,
      1.133325,
      1,
      0,
      2,
      NULL,
      0.629977,
      NULL,
      NULL,
      NULL,
      0.948480,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.582015,
      NULL,
      0.373311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745923,
      0.502428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748479,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.267788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634367,
      NULL,
      NULL,
      NULL,
      1.857843,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0.495938,
      0.394652,
      0,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      3.123705,
      1,
      1,
      1,
      0.743692,
      0,
      3,
      NULL,
      2.580492,
      2.673460,
      NULL,
      1.183656,
      3,
      1.128779,
      0,
      NULL,
      3.350479,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.622451,
      NULL,
      1,
      2.854612,
      1,
      1,
      1,
      0,
      3,
      0.468441,
      0,
      1.349813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.302803,
      NULL,
      0,
      NULL,
      NULL,
      0,
      6,
      0.602346,
      1.814059,
      3.179392,
      70,
      87.282720,
      4,
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.739083,
      '',
      '',
      '',
      1.992522,
      '',
      '',
      '');
commit;
end;
/


