set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '2440134',
      1,
      1.391421,
      3,
      0,
      '3122',
      3,
      1.333355,
      NULL,
      NULL,
      ' 1-21-1987',
      58.838085,
      NULL,
      5,
      3.070295,
      NULL,
      '10-26-1975',
      NULL,
      2.400704,
      324.564852,
      NULL,
      1,
      NULL,
      NULL,
      ' 7-20-1974',
      1,
      0.964812,
      0.300696,
      0,
      1,
      NULL,
      2,
      0,
      NULL,
      162,
      0,
      15.359616,
      4.537119,
      NULL,
      15,
      NULL,
      10.986051,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0.488414,
      0,
      1.040681,
      1,
      NULL,
      1.742485,
      1.104830,
      126.517744,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      0,
      1,
      0,
      3,
      NULL,
      1,
      NULL,
      0,
      1.717712,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      2,
      1,
      0,
      1,
      2.870087,
      2,
      2.945177,
      1.904510,
      1.600694,
      3.182952,
      2.521180,
      0.507407,
      0.957575,
      NULL,
      1,
      2.010005,
      0.762014,
      1,
      1,
      1,
      2.378470,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1.476913,
      0,
      NULL,
      1,
      NULL,
      0.863926,
      NULL,
      0.750036,
      5,
      0,
      0,
      4,
      1,
      4,
      NULL,
      0,
      0,
      1,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      4,
      0,
      2,
      '11-21-2002',
      165.787604,
      NULL,
      241,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1.246503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.414922,
      3.659861,
      NULL,
      3,
      1,
      NULL,
      3,
      2,
      2.206641,
      5,
      1.752110,
      2,
      3,
      3.200468,
      0.838748,
      4,
      1,
      5.868143,
      1.623154,
      4.263310,
      9.953419,
      5,
      1.239378,
      NULL,
      NULL,
      NULL,
      4,
      2.018837,
      0,
      NULL,
      1,
      2,
      ' 3-22-2000',
      2,
      ' 2- 9-2000',
      0,
      0,
      0,
      1.410337,
      0.577761,
      0.610413,
      NULL,
      2.261084,
      0.652333,
      0,
      NULL,
      NULL,
      NULL,
      0.217801,
      0.701922,
      NULL,
      NULL,
      NULL,
      1,
      0.261715,
      NULL,
      3,
      2,
      2,
      1,
      0,
      NULL,
      0,
      0,
      2,
      3,
      NULL,
      2.295392,
      1,
      0.454463,
      2,
      0.476663,
      2,
      0,
      1,
      NULL,
      0,
      NULL,
      0.053544,
      1.843686,
      1.146739,
      0,
      1,
      NULL,
      0.113008,
      6,
      6,
      7,
      NULL,
      NULL,
      6.032957,
      NULL,
      1,
      4.509928,
      3,
      1,
      1.518758,
      9.268157,
      NULL,
      NULL,
      NULL,
      28,
      38,
      56.309435,
      NULL,
      1,
      3,
      '34301',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.277069,
      4,
      NULL,
      6,
      2.743399,
      NULL,
      13.245560,
      4.660333,
      NULL,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      2,
      2.272066,
      2,
      3,
      3,
      0.468031,
      0.207470,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.853308,
      1.806729,
      NULL,
      1.537184,
      NULL,
      NULL,
      2,
      1.941481,
      0.895740,
      0,
      NULL,
      NULL,
      1.422297,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.080518,
      4,
      NULL,
      0,
      1.460944,
      NULL,
      NULL,
      NULL,
      1,
      2.795512,
      NULL,
      0.684141,
      1.642801,
      NULL,
      0,
      NULL,
      2.164768,
      1,
      0.417793,
      NULL,
      1.227974,
      1.266338,
      0,
      3.294906,
      NULL,
      3.328576,
      1,
      1,
      1.076833,
      3,
      3,
      0,
      1,
      NULL,
      NULL,
      1.089473,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.579880,
      3,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.383141,
      NULL,
      1.112517,
      0.366451,
      0.747027,
      NULL,
      NULL,
      2.304532,
      3,
      0.414969,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.587752,
      1,
      0,
      NULL,
      NULL,
      1.724232,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920610,
      NULL,
      NULL,
      0.305136,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.352876,
      NULL,
      0,
      NULL,
      NULL,
      1.697250,
      7.822647,
      4,
      NULL,
      NULL,
      0.606674,
      7.504149,
      6,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      3.987812,
      3.746792,
      2,
      NULL,
      3,
      5.787135,
      NULL,
      2.178172,
      NULL,
      1,
      NULL,
      1.189206,
      0.201584,
      2.034975,
      0,
      0,
      1.075504,
      1.689183,
      0,
      0,
      7,
      8.121030,
      7,
      0,
      1,
      3,
      0,
      0,
      0,
      NULL,
      1,
      0,
      2.461316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986463,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      0.115624,
      0.328472,
      3.162089,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1.252306,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.201784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.379915,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.016269,
      NULL,
      NULL,
      NULL,
      2.681595,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.656075,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      0.267750,
      2.743495,
      1,
      0,
      NULL,
      89.252311,
      60.504264,
      NULL,
      37.099123,
      3,
      1,
      NULL,
      NULL,
      3,
      47,
      10.102593,
      0.968337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.258672,
      NULL,
      1.928431,
      98.818803,
      23,
      1.599370,
      NULL,
      NULL,
      1,
      1.606052,
      NULL,
      1.788953,
      1.117951,
      1.267064,
      0,
      0,
      0,
      NULL,
      1.323015,
      0,
      0,
      0,
      0.824684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.091144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.263651,
      0.686031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.319841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252130,
      NULL,
      1.504638,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      2,
      1.801879,
      2,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0.118043,
      0,
      0,
      NULL,
      0,
      0.382913,
      1,
      1,
      1.927136,
      NULL,
      0.374344,
      0.932744,
      1.327909,
      3.222485,
      2.731403,
      NULL,
      1.014018,
      1,
      3.400382,
      3,
      NULL,
      NULL,
      1,
      2.334642,
      NULL,
      1,
      1,
      1,
      1.310672,
      3,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.484233,
      0.580626,
      0.029001,
      0.242110,
      NULL,
      3,
      0,
      NULL,
      0.316065,
      0.236787,
      NULL,
      2.675645,
      0.468842,
      1.308234,
      NULL,
      3,
      3,
      3.383722,
      1.660390,
      1,
      1.957476,
      NULL,
      NULL,
      2.619051,
      NULL,
      23.084016,
      3.275248,
      NULL,
      0.884843,
      1.239004,
      0.560730,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.625483,
      31,
      83.880928,
      4,
      0,
      0.057449,
      '21440',
      '32301',
      NULL,
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


