set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31',
      26.328195,
      6.659475,
      NULL,
      0,
      0.831067,
      0,
      2,
      '0323',
      5.605515,
      0,
      NULL,
      NULL,
      ' 2- 1-1996',
      192,
      8,
      NULL,
      2.453667,
      0.706899,
      ' 9- 1-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 1-11-1995',
      NULL,
      ' 0- 2-1976',
      3.443622,
      NULL,
      NULL,
      1.364956,
      NULL,
      1.881962,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.977252,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      0.065360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      2,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      0,
      2,
      5,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.563413,
      NULL,
      NULL,
      3,
      5,
      1.277157,
      3,
      NULL,
      1,
      NULL,
      1.160580,
      2,
      1,
      1.814651,
      0,
      0,
      0,
      NULL,
      1,
      3.648832,
      2.237002,
      NULL,
      0,
      1,
      1,
      1.970296,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.603363,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      0.363567,
      NULL,
      0.016601,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      5,
      1,
      2,
      3,
      0,
      1,
      NULL,
      0,
      1,
      3,
      0,
      2,
      1,
      NULL,
      0,
      1,
      0,
      1.904592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.530710,
      3.317250,
      0.813592,
      0.829553,
      0,
      NULL,
      NULL,
      NULL,
      0.660197,
      0.710823,
      1.084490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.110578,
      0,
      NULL,
      NULL,
      3.187641,
      7,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      3,
      2,
      2,
      2,
      3,
      3,
      0,
      3,
      2,
      0.225786,
      0,
      2,
      0.600311,
      3,
      3,
      1.996711,
      1.971842,
      1.828706,
      NULL,
      NULL,
      1.799841,
      0,
      1,
      1,
      0,
      2,
      5,
      1.933367,
      6.176959,
      4.356795,
      0,
      3.332651,
      1.200291,
      2,
      NULL,
      NULL,
      6,
      1.853010,
      3,
      3,
      29.863357,
      NULL,
      NULL,
      44,
      NULL,
      40,
      82,
      0,
      1.970022,
      3.268421,
      '00444',
      '',
      '',
      0.032872,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      3,
      NULL,
      122.504891,
      22,
      3,
      38.007720,
      9.758842,
      NULL,
      2,
      3,
      2,
      0.918521,
      0,
      NULL,
      NULL,
      1,
      1,
      3.591606,
      0,
      3,
      1.673613,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.320937,
      3,
      1.799229,
      NULL,
      NULL,
      1,
      2,
      0.249749,
      0.284088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408131,
      NULL,
      NULL,
      2,
      6.225150,
      6,
      1,
      1.488693,
      NULL,
      NULL,
      NULL,
      3,
      3.139583,
      3,
      0,
      1,
      0.916969,
      2.743169,
      3,
      2.362754,
      2.694896,
      1.497636,
      NULL,
      0,
      NULL,
      2.249715,
      1,
      3.867135,
      3,
      3.501491,
      0,
      3,
      0,
      0,
      2,
      0,
      2.931985,
      NULL,
      1.726924,
      2.369894,
      NULL,
      NULL,
      NULL,
      0.193121,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      4.774667,
      7.915324,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.701848,
      2.140401,
      2,
      0,
      1.437596,
      NULL,
      NULL,
      1,
      NULL,
      0.478627,
      1,
      0.497201,
      NULL,
      0,
      NULL,
      NULL,
      7.832985,
      2.815710,
      0.264653,
      1.934613,
      NULL,
      NULL,
      0.873615,
      NULL,
      NULL,
      1.885606,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.431900,
      NULL,
      NULL,
      1.374681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620821,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      0.622101,
      1,
      NULL,
      NULL,
      7.567101,
      9,
      3,
      4,
      0.017056,
      2,
      2,
      5.835535,
      1.941077,
      3,
      NULL,
      3.050603,
      0.938594,
      1,
      1.825717,
      1.535142,
      0.609516,
      3.376397,
      NULL,
      9,
      6,
      2.640461,
      0.539452,
      1.076975,
      3,
      0.855188,
      0.655517,
      NULL,
      0.039634,
      3,
      0.887195,
      0.803182,
      0.960673,
      4.427556,
      NULL,
      2,
      4,
      2,
      1,
      3,
      3,
      NULL,
      1,
      1,
      1,
      0,
      0.335981,
      1.453045,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.309448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375127,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.431134,
      NULL,
      NULL,
      0.932900,
      NULL,
      NULL,
      2.439061,
      0.721263,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.813598,
      NULL,
      NULL,
      NULL,
      0.470040,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.022741,
      NULL,
      NULL,
      NULL,
      2.428998,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.670782,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.059889,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.101320,
      NULL,
      NULL,
      NULL,
      0.545861,
      NULL,
      NULL,
      NULL,
      3.991090,
      NULL,
      NULL,
      NULL,
      0.461642,
      NULL,
      NULL,
      NULL,
      0.010335,
      NULL,
      NULL,
      NULL,
      10.206386,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      NULL,
      2,
      164.273992,
      NULL,
      2,
      165.601495,
      29,
      0.548675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316565,
      16.012024,
      12.126894,
      0,
      0.822870,
      0,
      NULL,
      0.590914,
      NULL,
      1.563176,
      0.539748,
      1.192244,
      NULL,
      1.263056,
      0,
      0.019790,
      1.946812,
      1,
      0,
      0.559018,
      0.747788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537478,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.046620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596903,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852989,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.389231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.114264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.925574,
      NULL,
      NULL,
      1.681658,
      NULL,
      1.242677,
      NULL,
      NULL,
      NULL,
      0.615690,
      NULL,
      0.439940,
      NULL,
      1.138293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      10.761176,
      1.652990,
      NULL,
      4.995163,
      1,
      NULL,
      0.452006,
      2,
      NULL,
      NULL,
      1,
      0,
      1.965565,
      1.968432,
      NULL,
      NULL,
      NULL,
      0.326846,
      0,
      0,
      0.886569,
      0.437735,
      3.122330,
      NULL,
      1,
      1,
      0.176758,
      1.102349,
      2,
      3,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      0.315101,
      NULL,
      0.588666,
      0,
      2,
      1.738139,
      2.683820,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.126415,
      3,
      2,
      0.838666,
      0,
      0.697156,
      0,
      3.031650,
      NULL,
      1,
      2,
      0.659099,
      1,
      0,
      0.231479,
      0.285869,
      NULL,
      2.497120,
      1.978625,
      0,
      2.224642,
      NULL,
      2,
      3,
      3,
      2,
      3,
      22,
      0,
      NULL,
      0.388556,
      1,
      3.846609,
      3.982174,
      1.128713,
      1,
      2,
      2,
      NULL,
      NULL,
      0.123952,
      NULL,
      NULL,
      104,
      2,
      0.162706,
      0.723548,
      NULL,
      '01240',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


