set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604647';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1300230',
      1,
      0,
      NULL,
      1,
      NULL,
      2.066624,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      NULL,
      2,
      NULL,
      8.085133,
      ' 2- 9-1999',
      37,
      NULL,
      295,
      54.085203,
      2,
      ' 6-12-1984',
      '11- 4-1996',
      ' 8-22-1981',
      3.330286,
      3.532709,
      0.922014,
      NULL,
      1,
      1,
      1,
      0.738644,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      9,
      NULL,
      18.315874,
      NULL,
      NULL,
      5.564535,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1.242406,
      0.014997,
      0,
      0,
      7,
      3,
      4,
      0,
      1,
      3,
      1,
      0,
      5,
      NULL,
      1,
      1,
      1,
      1,
      3,
      1,
      0,
      0,
      0,
      1.815730,
      NULL,
      NULL,
      0.232939,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.382421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      5,
      NULL,
      1,
      0.943729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0.817576,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      3,
      NULL,
      0,
      5,
      2,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3,
      5,
      NULL,
      NULL,
      3,
      NULL,
      0.855147,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854764,
      NULL,
      2.663298,
      2.337771,
      1,
      3,
      0.686885,
      NULL,
      NULL,
      NULL,
      1.525360,
      NULL,
      1.159306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.392802,
      NULL,
      1.084461,
      0.783054,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      3,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      2,
      1,
      19,
      19.301418,
      132,
      91,
      55,
      162,
      44.963026,
      187,
      NULL,
      110.885751,
      NULL,
      74,
      NULL,
      124.105031,
      1,
      6.881739,
      16,
      NULL,
      7,
      2,
      1.369047,
      9.361093,
      6,
      3,
      1.709355,
      0.036843,
      4.903399,
      2,
      NULL,
      0.773840,
      61.956828,
      3,
      NULL,
      NULL,
      70,
      62,
      35,
      2,
      4,
      NULL,
      '',
      '',
      '',
      2.497040,
      '24322',
      '',
      '',
      1.685944,
      '',
      '',
      NULL,
      1,
      NULL,
      106.611323,
      NULL,
      1,
      13.942063,
      NULL,
      NULL,
      1,
      1.154367,
      1,
      3.812918,
      0.366203,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.005166,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.011565,
      NULL,
      NULL,
      1.396773,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.423871,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      1,
      NULL,
      NULL,
      0.455945,
      NULL,
      NULL,
      1.295733,
      1,
      1,
      1,
      0,
      0.645853,
      NULL,
      NULL,
      NULL,
      1.150878,
      0.268968,
      0.313877,
      2,
      2,
      2,
      0.680499,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.185531,
      NULL,
      NULL,
      4.307145,
      NULL,
      3,
      1,
      1.995668,
      NULL,
      NULL,
      NULL,
      1.200487,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.465816,
      1.418251,
      0.279408,
      1,
      1,
      1.712977,
      0,
      NULL,
      NULL,
      0.635516,
      2.218190,
      0.109244,
      NULL,
      NULL,
      NULL,
      1.944091,
      0,
      2,
      4.192131,
      4.101144,
      NULL,
      1.031272,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.652294,
      NULL,
      NULL,
      0.725747,
      NULL,
      NULL,
      1.471535,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475263,
      NULL,
      NULL,
      0.297042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.765026,
      4.266784,
      1,
      0.694585,
      0,
      NULL,
      NULL,
      3,
      0.673954,
      NULL,
      3,
      1,
      1.853993,
      5,
      2,
      NULL,
      NULL,
      2,
      1,
      1,
      1.673006,
      3,
      0,
      1,
      0,
      2,
      NULL,
      1,
      2.440384,
      NULL,
      NULL,
      NULL,
      1.048236,
      NULL,
      NULL,
      NULL,
      0.342242,
      0,
      0.718120,
      0,
      0.010280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631000,
      0.271527,
      0.856281,
      0.199230,
      1,
      0.532496,
      0.382669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.555861,
      NULL,
      NULL,
      3.396616,
      4.033933,
      0,
      0,
      NULL,
      0.212535,
      186.537289,
      4.482090,
      1,
      2.357747,
      NULL,
      1.132340,
      0,
      0,
      0,
      3.280702,
      1,
      0.254007,
      1.253399,
      2,
      NULL,
      NULL,
      1.932743,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.920865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      11.684629,
      NULL,
      3,
      24,
      2,
      0,
      0.259252,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761420,
      NULL,
      0,
      NULL,
      1.463159,
      NULL,
      0,
      NULL,
      1.478675,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.096478,
      NULL,
      1.101464,
      NULL,
      1.192283,
      NULL,
      NULL,
      NULL,
      1.653565,
      1.795118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.050789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237684,
      2.658966,
      NULL,
      1,
      NULL,
      3,
      NULL,
      109,
      NULL,
      3.055013,
      NULL,
      3.130905,
      NULL,
      1,
      NULL,
      NULL,
      1.430621,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.781197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700969,
      0.818567,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      259,
      NULL,
      3.192139,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.475133,
      35,
      8,
      0.001211,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      13.140262,
      0.128637,
      0,
      0.012817,
      0,
      4,
      1.720159,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.188882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.552807,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.321261,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826968,
      NULL,
      NULL,
      NULL,
      0.154831,
      NULL,
      1,
      3,
      NULL,
      3,
      1,
      1.862650,
      75.784698,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '21123',
      NULL,
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


