set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604647';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      '44',
      NULL,
      28,
      '2003121',
      2.238109,
      NULL,
      1,
      0,
      '1420',
      5.492884,
      NULL,
      NULL,
      NULL,
      NULL,
      64.709108,
      9.449229,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '11-17-1976',
      NULL,
      NULL,
      3.763321,
      3.315667,
      2.134481,
      1,
      0.710039,
      2,
      1,
      1,
      0,
      2,
      8,
      10.948643,
      10.001577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.212258,
      3,
      0,
      0.605527,
      1.956765,
      NULL,
      0,
      0.225649,
      1,
      1.439375,
      NULL,
      0,
      4,
      4,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.861490,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418769,
      NULL,
      NULL,
      5,
      1,
      0.708529,
      2,
      1,
      1.778424,
      2,
      0.444957,
      2,
      0,
      NULL,
      1.778039,
      1.392686,
      1.569859,
      0.483081,
      0.789468,
      2,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1.875154,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      5,
      3,
      5,
      2,
      5,
      4,
      1,
      1,
      1.577340,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.165198,
      1.622309,
      0.227668,
      NULL,
      NULL,
      NULL,
      0.676199,
      1.009467,
      0.393310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.455316,
      0.030307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      1,
      1,
      1,
      2,
      2,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.960509,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.453094,
      9,
      2,
      10,
      4.635919,
      2.928652,
      4,
      3.793814,
      7,
      0,
      3,
      1,
      41.570472,
      1,
      1.682754,
      37,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      '',
      NULL,
      NULL,
      '13412',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      0.940259,
      291,
      13.653764,
      2.835468,
      13,
      0.041713,
      6,
      1,
      2.368498,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.429817,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.061551,
      NULL,
      2.644355,
      NULL,
      NULL,
      NULL,
      0.719578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351683,
      NULL,
      NULL,
      0.486943,
      NULL,
      NULL,
      2.251048,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.991972,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.861601,
      NULL,
      NULL,
      NULL,
      1,
      1.510169,
      0.210375,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.330448,
      1,
      0.235320,
      2.472915,
      1.489541,
      0,
      NULL,
      0.601008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.215709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.590695,
      2,
      1.824043,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.996567,
      0,
      0.521445,
      NULL,
      NULL,
      3.352832,
      3,
      2.880116,
      4,
      NULL,
      1,
      0.044566,
      NULL,
      NULL,
      1.440643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.004842,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.510149,
      NULL,
      NULL,
      0.298327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.765014,
      NULL,
      NULL,
      3.071351,
      1,
      0,
      3.018264,
      0.271469,
      2.254141,
      0,
      5.858601,
      5.344124,
      NULL,
      1.763932,
      1,
      NULL,
      1,
      0,
      2.122756,
      2,
      2,
      2.652126,
      3.524751,
      1.475848,
      NULL,
      1.693835,
      6.250629,
      2.727314,
      1,
      NULL,
      NULL,
      1.506476,
      NULL,
      NULL,
      1,
      1.248683,
      0,
      1.854459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.030832,
      NULL,
      NULL,
      0.492283,
      0.343472,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458016,
      NULL,
      NULL,
      NULL,
      0,
      4.166939,
      2,
      1.545425,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.429579,
      4.544730,
      1,
      0,
      NULL,
      1.633861,
      209.056127,
      8.926907,
      0,
      2.172356,
      1,
      0.538967,
      1.102475,
      NULL,
      0,
      2,
      NULL,
      0.537522,
      0.865030,
      3,
      NULL,
      1.584499,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.325985,
      NULL,
      0.567112,
      NULL,
      0.257103,
      NULL,
      1,
      NULL,
      1.408985,
      NULL,
      6.011070,
      NULL,
      3,
      NULL,
      NULL,
      1.872018,
      1,
      NULL,
      NULL,
      0.392262,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.225586,
      NULL,
      NULL,
      NULL,
      1.404882,
      NULL,
      0,
      NULL,
      1.640377,
      NULL,
      0.839311,
      NULL,
      0.600782,
      NULL,
      1,
      NULL,
      1.957343,
      3,
      1.663166,
      0.127731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.193981,
      0,
      NULL,
      0.660231,
      NULL,
      1,
      NULL,
      248,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0.428906,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520169,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.052622,
      3,
      NULL,
      3.274898,
      NULL,
      279.095294,
      NULL,
      3.692938,
      NULL,
      1.605198,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.322838,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3,
      2,
      NULL,
      1,
      0,
      2,
      11,
      3.156440,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.305795,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.909751,
      NULL,
      NULL,
      3.270395,
      NULL,
      NULL,
      1.541225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.352778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.965518,
      NULL,
      0,
      NULL,
      1.599023,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      1.570613,
      51.169809,
      91.334761,
      1,
      NULL,
      7,
      '01111',
      '00402',
      '31043',
      3,
      '30234',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


