set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9671395';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '44',
      '11',
      NULL,
      18.207805,
      '0313132',
      1,
      0.449563,
      1,
      NULL,
      NULL,
      0.079972,
      0.801302,
      NULL,
      NULL,
      ' 2-19-1979',
      NULL,
      7,
      NULL,
      2.885100,
      0.296777,
      ' 4-22-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-24-2002',
      NULL,
      ' 8- 6-1985',
      2.179177,
      3,
      1.093673,
      2.979774,
      NULL,
      NULL,
      1,
      NULL,
      0,
      29.897071,
      4,
      12,
      0.551729,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      2,
      0.101305,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      5.082824,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.423207,
      2.814589,
      1.042904,
      1,
      0.306437,
      2.448786,
      NULL,
      3,
      0.506264,
      0.043259,
      3,
      2,
      NULL,
      8,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      3,
      NULL,
      3,
      0,
      0,
      0,
      1,
      0,
      0,
      1.991831,
      1,
      1,
      0,
      0,
      1.547974,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3,
      5,
      2,
      1,
      4,
      5,
      1,
      0,
      0,
      5,
      2,
      3,
      NULL,
      5,
      2,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      3228,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.998366,
      0,
      0.072975,
      1.386637,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.426946,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.869495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226155,
      0.821391,
      0,
      NULL,
      0,
      0.806325,
      3.805778,
      36,
      NULL,
      1.797368,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      3,
      2,
      0,
      3,
      0,
      3,
      2,
      NULL,
      2,
      1.531735,
      0.013328,
      0.387482,
      1,
      0,
      0,
      NULL,
      1.034596,
      1,
      1,
      0.710870,
      1,
      1.972815,
      0,
      0.433972,
      NULL,
      6.959309,
      7.598837,
      2,
      11.378332,
      1,
      2.683193,
      3,
      0,
      1,
      NULL,
      0,
      54.822992,
      NULL,
      1.031175,
      18,
      NULL,
      14,
      56.772202,
      0,
      0,
      2.321533,
      '40233',
      '',
      '',
      0.758211,
      '',
      '',
      '',
      NULL,
      '43312',
      NULL,
      '',
      NULL,
      13,
      NULL,
      49,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.560927,
      2.915951,
      NULL,
      NULL,
      NULL,
      0.100101,
      NULL,
      1.666265,
      1,
      NULL,
      NULL,
      1,
      3,
      3.945835,
      NULL,
      NULL,
      NULL,
      0.788834,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.215505,
      NULL,
      NULL,
      6,
      2,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2.021282,
      0,
      0.848857,
      1,
      NULL,
      0.368331,
      1,
      NULL,
      1,
      2,
      1.268177,
      1.975517,
      NULL,
      2,
      2,
      3,
      1.153643,
      NULL,
      3.602587,
      0,
      1,
      0.224593,
      2,
      1.957261,
      1,
      NULL,
      NULL,
      0.979138,
      4,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.427948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.757882,
      NULL,
      NULL,
      3.042334,
      NULL,
      2.185893,
      1.088703,
      NULL,
      NULL,
      4,
      0,
      3.583938,
      0.710011,
      1,
      0.695977,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.682994,
      0.958029,
      NULL,
      NULL,
      1.713071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398258,
      NULL,
      NULL,
      0.865791,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.394512,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328117,
      1,
      1.484529,
      1.972060,
      0.628627,
      NULL,
      0,
      NULL,
      NULL,
      3.017204,
      1.894435,
      1.044708,
      0.533300,
      NULL,
      1,
      0.950942,
      1.499119,
      0,
      4.435021,
      1.161841,
      0.892560,
      NULL,
      0,
      2,
      NULL,
      1.006461,
      1,
      1.943594,
      0.239683,
      0,
      2,
      1,
      0.042208,
      NULL,
      3,
      5.121241,
      2.621433,
      1,
      3,
      2,
      NULL,
      NULL,
      1.797788,
      0,
      0,
      1,
      NULL,
      1.377122,
      NULL,
      NULL,
      1.799893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.193129,
      NULL,
      1,
      1,
      1,
      1.855565,
      NULL,
      NULL,
      NULL,
      0.101616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.467209,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.658568,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.280789,
      NULL,
      NULL,
      NULL,
      0.802255,
      NULL,
      NULL,
      NULL,
      1.487255,
      5.513832,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.473774,
      1.921128,
      0,
      3,
      0.781939,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0.157000,
      1.603203,
      1,
      NULL,
      3.647875,
      0,
      1,
      NULL,
      3,
      NULL,
      1.155242,
      NULL,
      NULL,
      NULL,
      0.041404,
      NULL,
      1.323504,
      NULL,
      3.367008,
      NULL,
      221,
      NULL,
      0.020468,
      NULL,
      78,
      NULL,
      0.278708,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308461,
      NULL,
      0.658908,
      NULL,
      0.212426,
      NULL,
      NULL,
      NULL,
      2.284220,
      NULL,
      2.473910,
      NULL,
      NULL,
      NULL,
      3.857006,
      NULL,
      1,
      NULL,
      1.775753,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.024955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      9.490388,
      4,
      0,
      5.943890,
      NULL,
      NULL,
      0.838843,
      NULL,
      0.298816,
      NULL,
      0,
      NULL,
      0.061698,
      0.867029,
      NULL,
      NULL,
      1.359263,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.022323,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581949,
      3,
      NULL,
      0.158009,
      0,
      NULL,
      0,
      1.761352,
      0.157252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464878,
      NULL,
      NULL,
      NULL,
      1.351237,
      NULL,
      NULL,
      1,
      0,
      3.140137,
      0.419627,
      NULL,
      47.695907,
      NULL,
      2,
      NULL,
      NULL,
      '41434',
      '14443',
      '',
      0,
      '',
      '',
      '',
      3.922553,
      NULL,
      NULL,
      '');
commit;
end;
/


