set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6702192';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6,
      NULL,
      NULL,
      1,
      0.415817,
      NULL,
      NULL,
      ' 3-29-1975',
      43,
      NULL,
      NULL,
      1,
      1,
      ' 4-13-1992',
      20,
      NULL,
      312,
      118,
      NULL,
      ' 7-13-1975',
      ' 0- 4-1990',
      ' 8- 8-1978',
      3,
      3,
      NULL,
      3.224078,
      NULL,
      2,
      1,
      0.264320,
      0,
      33,
      1,
      2.258248,
      16,
      6.164243,
      8.435204,
      4,
      21,
      4,
      0,
      7,
      0.106263,
      1,
      0,
      0.735147,
      1,
      NULL,
      1,
      3.448764,
      6.083270,
      0,
      0.303741,
      NULL,
      0,
      0,
      0.697463,
      NULL,
      0,
      4,
      1,
      4,
      3,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1.237198,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2.231519,
      NULL,
      NULL,
      2.668487,
      1,
      1,
      NULL,
      1.779731,
      1,
      1.702744,
      NULL,
      1,
      3.429382,
      1,
      2.303083,
      3.526513,
      1,
      0,
      0,
      4.383000,
      1,
      2,
      3.612359,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0,
      NULL,
      4,
      1,
      4,
      4,
      NULL,
      5,
      4,
      NULL,
      3,
      2,
      2,
      1,
      0,
      0.925207,
      1,
      2.136191,
      4,
      5,
      5,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      4,
      2,
      2,
      5,
      1,
      4,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      4,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 8-1983',
      NULL,
      1.590583,
      0,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      5,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      1.800010,
      0.065603,
      2.495279,
      2.663657,
      1,
      2.325996,
      NULL,
      2,
      4,
      0.934252,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.043039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.889064,
      NULL,
      1.733550,
      1,
      0,
      1.393719,
      1,
      0,
      85.593164,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.840498,
      1,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      0,
      1,
      1,
      2,
      0.124173,
      2.406547,
      2,
      0.393367,
      1.224476,
      0.218028,
      4,
      2.716488,
      0,
      0,
      1.742861,
      NULL,
      0,
      0,
      0,
      1,
      14,
      NULL,
      0.693297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.246217,
      1.490399,
      0,
      1,
      NULL,
      NULL,
      2.297205,
      63.722730,
      NULL,
      1.173739,
      NULL,
      25,
      9,
      NULL,
      NULL,
      1.276386,
      4.459272,
      '41343',
      '33041',
      '',
      1.616322,
      '',
      '',
      '',
      0.346180,
      '',
      '',
      '',
      3.444629,
      NULL,
      51,
      1,
      2.064675,
      3.883092,
      0.382712,
      0,
      0,
      2.693704,
      NULL,
      1.788120,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.536890,
      1.979166,
      0.341726,
      1,
      0,
      0,
      3,
      NULL,
      1,
      0,
      1.905983,
      NULL,
      0,
      NULL,
      NULL,
      3.764601,
      1.113605,
      NULL,
      NULL,
      NULL,
      NULL,
      2.645645,
      0,
      NULL,
      1,
      NULL,
      0.507509,
      4,
      1.785083,
      2.378343,
      1,
      2.009290,
      1,
      0.569026,
      0,
      1,
      2,
      0,
      0.505192,
      2.675804,
      NULL,
      NULL,
      0.762575,
      NULL,
      NULL,
      1.028757,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      1,
      0,
      2,
      1.441241,
      1,
      3,
      2,
      1,
      1.460170,
      NULL,
      0,
      0.829974,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0.270324,
      3,
      0,
      3,
      NULL,
      5,
      3,
      3,
      3,
      0,
      1,
      2.357362,
      1,
      NULL,
      2.653738,
      NULL,
      NULL,
      2.272431,
      1,
      1,
      1.799755,
      NULL,
      NULL,
      1.913111,
      2.120580,
      0.978228,
      3.919413,
      3,
      3.550160,
      2,
      3.643591,
      2,
      7,
      0.756741,
      5,
      2.959346,
      NULL,
      1.514489,
      1.775100,
      NULL,
      NULL,
      0.291322,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.828094,
      NULL,
      7,
      NULL,
      1.406478,
      2.105812,
      0,
      0,
      NULL,
      0.651930,
      1,
      NULL,
      NULL,
      3.830465,
      3.258419,
      1.910859,
      1,
      0.720735,
      1,
      3,
      0,
      0,
      0.479398,
      3,
      0,
      0.966341,
      NULL,
      1.810681,
      3,
      1.235139,
      2.845088,
      NULL,
      3.056820,
      3.989178,
      3.907997,
      2.318379,
      NULL,
      1,
      0.115651,
      1.354797,
      0.800167,
      2,
      0,
      0,
      4.053534,
      NULL,
      NULL,
      5.423218,
      3,
      2.830547,
      NULL,
      0,
      2,
      NULL,
      1,
      3,
      3,
      0,
      2,
      0,
      NULL,
      2.512304,
      9.579553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.243828,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.137062,
      1.720131,
      NULL,
      0.544259,
      1,
      NULL,
      2.140702,
      0,
      NULL,
      3,
      0.823448,
      NULL,
      0.866016,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      0.850292,
      3,
      3.423014,
      0.136440,
      3,
      3.557074,
      1,
      NULL,
      4,
      5.514369,
      NULL,
      NULL,
      5,
      3.211499,
      NULL,
      NULL,
      3,
      1.894396,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.283556,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.729657,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213136,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.521123,
      0.957254,
      NULL,
      NULL,
      1.891082,
      1.403045,
      NULL,
      NULL,
      3.688417,
      3,
      NULL,
      NULL,
      NULL,
      0.763808,
      NULL,
      NULL,
      2,
      1.418341,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      10.050062,
      26.406925,
      0.157913,
      NULL,
      NULL,
      0.637256,
      NULL,
      NULL,
      0.362917,
      NULL,
      NULL,
      3.497067,
      0.235744,
      1.126117,
      1,
      NULL,
      NULL,
      0.411895,
      NULL,
      0,
      133.747554,
      13,
      0.895011,
      0,
      0.988339,
      0,
      0.755083,
      0.338474,
      0,
      2.433119,
      1.376314,
      1,
      0.796345,
      2.505293,
      1,
      0,
      1.169783,
      1,
      0.712582,
      3,
      NULL,
      1.542319,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.611914,
      NULL,
      13.000389,
      NULL,
      NULL,
      26,
      0.383127,
      1.155358,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.723359,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.974392,
      NULL,
      0.459876,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.317463,
      NULL,
      0,
      0.795728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2.773100,
      2,
      2,
      NULL,
      1,
      7.430015,
      1,
      NULL,
      0.365085,
      0.067851,
      NULL,
      NULL,
      0,
      1.152248,
      NULL,
      1.115983,
      3,
      NULL,
      3,
      0,
      NULL,
      3.951527,
      2,
      NULL,
      NULL,
      0.937173,
      NULL,
      1.034060,
      2.991406,
      NULL,
      1.211875,
      1.263758,
      NULL,
      0,
      0,
      NULL,
      1.359155,
      0,
      NULL,
      1,
      1.773967,
      NULL,
      2,
      0.244358,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.554324,
      NULL,
      1,
      NULL,
      NULL,
      0,
      7,
      0.706167,
      NULL,
      NULL,
      16.327202,
      36.507227,
      1,
      0.710564,
      NULL,
      NULL,
      '33133',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


