set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8104004';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4231000',
      1.983590,
      0.145551,
      0,
      1,
      '1201',
      3,
      1.264344,
      NULL,
      NULL,
      ' 3- 0-1984',
      8,
      NULL,
      5,
      1.518449,
      0,
      ' 9-25-1994',
      69.940045,
      NULL,
      323.024428,
      84.628264,
      0,
      NULL,
      ' 8-25-1974',
      ' 3-27-1992',
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      5,
      0.231976,
      NULL,
      122,
      169.009487,
      4,
      9,
      0,
      4,
      NULL,
      1.277041,
      NULL,
      0,
      NULL,
      1.489651,
      1.315985,
      NULL,
      NULL,
      0.934353,
      0,
      156.355280,
      3,
      3,
      NULL,
      1.958794,
      4,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1.528779,
      NULL,
      0,
      0,
      0,
      0.490334,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      3,
      3.582428,
      0.237014,
      1,
      0.651529,
      NULL,
      0.764129,
      0.709971,
      1,
      NULL,
      0.748529,
      1.796618,
      NULL,
      1.929244,
      0.465055,
      1.796893,
      0.663447,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      1.905403,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      1,
      0,
      3,
      1,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0.557866,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0.955488,
      5,
      2,
      0,
      2,
      NULL,
      5,
      NULL,
      4,
      NULL,
      NULL,
      3,
      2,
      2,
      1,
      3,
      0,
      4,
      4,
      5,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      ' 2- 8-1986',
      55,
      ' 7- 8-1986',
      26.824253,
      0,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.947086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.742506,
      0,
      0.120558,
      0,
      0.337546,
      NULL,
      0.655973,
      1.426094,
      16,
      3.143669,
      0.429337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.450255,
      NULL,
      22,
      NULL,
      4,
      2,
      0.009675,
      NULL,
      '04233',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      NULL,
      40.179541,
      64,
      67.159692,
      NULL,
      52,
      16,
      NULL,
      4,
      2,
      3.445140,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.227852,
      NULL,
      NULL,
      1.959307,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831594,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.510961,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.434584,
      0,
      0.379863,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.227683,
      1,
      0,
      0,
      1,
      0.487731,
      NULL,
      1.352841,
      0,
      0,
      1.080463,
      0.516187,
      0.612682,
      1.628443,
      0.307923,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.788078,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.214839,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.270957,
      0,
      1.589816,
      0,
      1.129860,
      1.713107,
      NULL,
      NULL,
      9.885379,
      9.818954,
      0.983380,
      NULL,
      0.041668,
      1.194000,
      0,
      NULL,
      NULL,
      NULL,
      1.975655,
      NULL,
      0.850207,
      0,
      1.542574,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0.941819,
      1,
      1.535733,
      2.527765,
      1,
      NULL,
      0,
      NULL,
      5,
      NULL,
      3.420121,
      6.148415,
      8,
      0.916950,
      0.601889,
      NULL,
      NULL,
      0.086371,
      1,
      0,
      2.800369,
      NULL,
      NULL,
      3,
      NULL,
      1.632769,
      1.758979,
      8,
      6,
      1,
      2,
      1,
      1,
      NULL,
      0.067221,
      1,
      3.745829,
      0.952554,
      1,
      1.421203,
      0,
      NULL,
      2,
      7,
      0.753281,
      NULL,
      NULL,
      0.077058,
      NULL,
      1,
      1.267711,
      1,
      1,
      0,
      0.177162,
      1.567149,
      NULL,
      NULL,
      0.477301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585521,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.225376,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.178450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309406,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.664656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987519,
      NULL,
      NULL,
      NULL,
      0.524558,
      NULL,
      NULL,
      NULL,
      3.361615,
      2,
      NULL,
      NULL,
      NULL,
      1.524944,
      NULL,
      NULL,
      1.381334,
      NULL,
      NULL,
      NULL,
      1,
      0.093588,
      NULL,
      NULL,
      0.474265,
      0.892132,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1.760226,
      NULL,
      NULL,
      NULL,
      0.605683,
      57.117443,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.259181,
      11122,
      979.738494,
      1.649805,
      1.023499,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.838992,
      NULL,
      NULL,
      0,
      1.638221,
      1.013070,
      NULL,
      0.866865,
      1.753654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      1,
      NULL,
      1,
      3,
      8.252208,
      1.286708,
      NULL,
      3,
      5,
      10,
      0.783689,
      12,
      NULL,
      1,
      NULL,
      4,
      1.716089,
      13,
      NULL,
      0.092490,
      7,
      NULL,
      1.244409,
      NULL,
      9.782349,
      NULL,
      13,
      11.698623,
      1,
      18,
      NULL,
      0,
      13.717533,
      12.990088,
      0,
      17.467361,
      13.526935,
      0.818854,
      NULL,
      4.810479,
      3.369372,
      3,
      2,
      1.947697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172836,
      NULL,
      0,
      0,
      1.623870,
      NULL,
      0,
      5,
      0,
      0,
      NULL,
      14.660307,
      41.338437,
      2,
      NULL,
      0,
      '02401',
      '',
      '',
      1.597881,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


