set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8423044';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '3143231',
      0,
      NULL,
      0,
      NULL,
      '4433',
      0,
      NULL,
      NULL,
      NULL,
      '10-13-1993',
      57.494094,
      NULL,
      2,
      3.698924,
      1,
      ' 0- 5-1974',
      43.007477,
      0.406844,
      243.615197,
      80,
      2,
      '10-28-1998',
      ' 3-18-1982',
      '11- 1-1981',
      0,
      2,
      1,
      3.310302,
      1.433249,
      2.300833,
      3,
      1.499217,
      1.270779,
      45.820142,
      7,
      1.546156,
      4.268747,
      4,
      17.258201,
      4,
      15,
      2,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0.387876,
      1,
      0,
      0,
      1.059907,
      0,
      5,
      3,
      2,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1,
      5,
      5,
      1,
      1,
      8.398139,
      1,
      0,
      NULL,
      1,
      1.753672,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      2,
      2.630096,
      NULL,
      1,
      0.582403,
      NULL,
      1,
      0.911767,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.102760,
      2.396701,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      5,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      3,
      5,
      4,
      NULL,
      5,
      5,
      NULL,
      3,
      1,
      1,
      0.227749,
      NULL,
      ' 2-28-1981',
      733,
      ' 9- 1-2001',
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      143.331799,
      1,
      1.370227,
      4,
      2,
      0.184767,
      0.377467,
      0,
      0,
      1,
      2,
      1.906353,
      NULL,
      NULL,
      NULL,
      0.266030,
      1.357784,
      4.648130,
      2,
      2,
      8.621001,
      2,
      2,
      5,
      1,
      NULL,
      3,
      0.304693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.684428,
      1,
      NULL,
      0,
      0.620094,
      1.892800,
      NULL,
      26.647373,
      1,
      1.689754,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      3,
      2,
      2,
      1,
      2,
      2.778341,
      3,
      1.972189,
      0.930011,
      1.621664,
      0.261887,
      1,
      NULL,
      NULL,
      1.099372,
      0,
      0,
      0.682842,
      NULL,
      1.723667,
      1,
      0.471111,
      3,
      1.941192,
      8.036251,
      10.044375,
      2.757642,
      4,
      NULL,
      1,
      2.550503,
      NULL,
      2,
      0.386856,
      2.415736,
      NULL,
      17,
      NULL,
      2.891732,
      NULL,
      2,
      8,
      26.129340,
      1,
      1,
      0,
      '12104',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.473834,
      NULL,
      '',
      NULL,
      0.263807,
      NULL,
      30,
      2.013881,
      1.190799,
      23,
      0.473308,
      NULL,
      5,
      2.857536,
      0,
      3,
      1.595260,
      NULL,
      NULL,
      3,
      3.059562,
      0.006990,
      1,
      NULL,
      NULL,
      0.985051,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.136068,
      0.477106,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2.270753,
      1.028629,
      3.972945,
      0.237716,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      3,
      7.815485,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.222760,
      1,
      3,
      1.392601,
      0,
      NULL,
      2,
      3,
      0.271405,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      2.127577,
      1.779274,
      1,
      3,
      0,
      1,
      2,
      NULL,
      1.188335,
      NULL,
      0,
      2.591621,
      1.807134,
      NULL,
      NULL,
      0.101623,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.700720,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.652602,
      1,
      NULL,
      NULL,
      0.483812,
      2,
      4.119640,
      1.925666,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.560751,
      NULL,
      NULL,
      1.887850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065293,
      NULL,
      NULL,
      0.508685,
      NULL,
      NULL,
      1,
      0,
      2.360670,
      0,
      NULL,
      NULL,
      NULL,
      4.267144,
      NULL,
      1.490685,
      1,
      0.408769,
      3,
      3,
      3.054532,
      2,
      NULL,
      1.251764,
      NULL,
      1.806234,
      0.317142,
      2,
      NULL,
      0.849309,
      6.636651,
      NULL,
      3.128067,
      2,
      3.482422,
      NULL,
      3.619119,
      3.362971,
      1,
      0,
      1,
      NULL,
      0,
      3.360281,
      3.844362,
      NULL,
      9,
      NULL,
      2.235575,
      NULL,
      0,
      1.690881,
      2,
      NULL,
      3.501370,
      0.377461,
      0.385177,
      1,
      0.585830,
      3.478639,
      NULL,
      NULL,
      2.199341,
      NULL,
      NULL,
      29,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.456973,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.146426,
      NULL,
      NULL,
      1.323179,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.435283,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.629124,
      NULL,
      0,
      0.061866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.521081,
      2.972147,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.123041,
      NULL,
      NULL,
      NULL,
      1.263968,
      2.488621,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      3.212295,
      NULL,
      NULL,
      3.850705,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.628357,
      1.091437,
      NULL,
      NULL,
      0,
      0.323987,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.754891,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.472934,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      3.168725,
      NULL,
      NULL,
      15,
      4,
      NULL,
      NULL,
      7,
      3,
      NULL,
      7,
      5,
      1,
      12.227571,
      0,
      NULL,
      8.294949,
      13.217258,
      1.337714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.694090,
      NULL,
      NULL,
      3,
      25.486355,
      0.099673,
      1124.788529,
      1.898454,
      0.286607,
      1.780025,
      0,
      1,
      1,
      1,
      0.850865,
      0,
      1,
      0.240341,
      0.034406,
      0.873801,
      0,
      0,
      0,
      1.155329,
      0,
      0.350367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      3,
      NULL,
      0.288223,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.436068,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748699,
      1.203704,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.808574,
      NULL,
      1.543442,
      1.120109,
      NULL,
      NULL,
      3,
      NULL,
      3.889811,
      2.661310,
      NULL,
      1,
      0.334162,
      NULL,
      1,
      0.202825,
      NULL,
      0.217919,
      1.723838,
      NULL,
      3.641198,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806096,
      NULL,
      0.324761,
      NULL,
      0.166879,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.052882,
      NULL,
      0.515069,
      NULL,
      1.965853,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.784953,
      NULL,
      0,
      5,
      5,
      0.477376,
      NULL,
      NULL,
      30,
      NULL,
      NULL,
      0,
      0,
      '21214',
      '',
      '',
      1.432012,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


