set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7128938';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      '03',
      NULL,
      19.940030,
      '2300011',
      2.661416,
      0,
      0,
      3,
      NULL,
      4.090820,
      NULL,
      NULL,
      NULL,
      ' 6-22-1990',
      115.165759,
      NULL,
      NULL,
      0.207837,
      1,
      ' 9-10-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.969408,
      0,
      NULL,
      1,
      1.084872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.480437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      0,
      1.713288,
      0,
      1,
      1.682195,
      NULL,
      3,
      0,
      2,
      0.993534,
      4,
      0,
      1,
      1,
      1,
      0,
      NULL,
      3,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355146,
      1,
      2,
      0,
      1,
      0.695198,
      0,
      3.241293,
      0.948010,
      0.673250,
      2.431906,
      0,
      0,
      NULL,
      1,
      3.762440,
      0,
      0,
      NULL,
      1.129450,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0.248660,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      3,
      0,
      5,
      1,
      0,
      3,
      0,
      1,
      NULL,
      2,
      NULL,
      1,
      1,
      1,
      0,
      1.364470,
      0.573279,
      '11-16-1986',
      1951,
      NULL,
      NULL,
      0.158373,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      2.543779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.888921,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492920,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.922102,
      0.706417,
      0,
      NULL,
      1.468304,
      1,
      0.400443,
      1,
      NULL,
      2.745026,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.241940,
      1.624054,
      1,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      0,
      4,
      3.046140,
      0.291849,
      1.028183,
      1,
      1,
      1,
      1.781420,
      NULL,
      1.498885,
      NULL,
      1,
      1.900023,
      0,
      1,
      2,
      NULL,
      NULL,
      1,
      1,
      9,
      7.185253,
      10.724315,
      NULL,
      5.201284,
      1,
      2.637190,
      3.967655,
      3,
      3.685665,
      3,
      41.749849,
      1,
      0,
      80,
      NULL,
      NULL,
      NULL,
      5,
      0.430956,
      NULL,
      '41440',
      '04231',
      NULL,
      0,
      '',
      '',
      '',
      3,
      '01240',
      '',
      '',
      0.056001,
      14,
      NULL,
      38.565572,
      3.061940,
      24,
      3,
      4,
      NULL,
      2.746388,
      1.406030,
      3.807036,
      0.346211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      2,
      1.954472,
      NULL,
      1.018521,
      0,
      0.535842,
      3.778106,
      0.809706,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274366,
      NULL,
      NULL,
      NULL,
      1.515815,
      NULL,
      1.746781,
      NULL,
      NULL,
      2.625566,
      3,
      6.066274,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0.581702,
      NULL,
      NULL,
      1.265878,
      NULL,
      NULL,
      2,
      3.191777,
      1.448303,
      1.144330,
      NULL,
      0.858005,
      0,
      0.653958,
      NULL,
      0,
      1,
      3.445243,
      2,
      NULL,
      2,
      NULL,
      3,
      3.477658,
      1.677489,
      0.047465,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      7,
      7.369702,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911186,
      NULL,
      NULL,
      NULL,
      1.066049,
      NULL,
      NULL,
      0.200073,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.428417,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.997308,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.140766,
      NULL,
      NULL,
      0.869913,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154044,
      NULL,
      NULL,
      0.256557,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.562334,
      NULL,
      NULL,
      0.912779,
      NULL,
      NULL,
      4.257523,
      0,
      0,
      1.658008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402927,
      2,
      NULL,
      1.202966,
      NULL,
      NULL,
      4.117518,
      NULL,
      3.801923,
      NULL,
      0,
      NULL,
      2,
      0,
      3,
      0.077663,
      NULL,
      NULL,
      0.846487,
      NULL,
      NULL,
      2.944129,
      1.694500,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.931303,
      1.231485,
      1,
      0.888329,
      1.366607,
      2.509634,
      NULL,
      NULL,
      3.147611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912453,
      NULL,
      NULL,
      0.539778,
      NULL,
      NULL,
      1.976241,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737636,
      NULL,
      NULL,
      0.583033,
      NULL,
      NULL,
      0.236870,
      0.175327,
      0.106318,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576701,
      NULL,
      NULL,
      NULL,
      0.034101,
      NULL,
      NULL,
      NULL,
      0.253073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419384,
      NULL,
      NULL,
      NULL,
      0.612577,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.931489,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.489144,
      NULL,
      1,
      1.834516,
      0,
      1,
      0.763023,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      2.813864,
      1,
      0.308387,
      NULL,
      3.342643,
      NULL,
      1,
      NULL,
      0.244696,
      NULL,
      0.809712,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      21.138889,
      NULL,
      1.342268,
      NULL,
      37,
      NULL,
      1.042404,
      NULL,
      NULL,
      NULL,
      NULL,
      3.034450,
      NULL,
      2.559570,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.407244,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.698125,
      NULL,
      0.301350,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      7.441055,
      NULL,
      2,
      0,
      1,
      3,
      3.609023,
      0,
      1.907341,
      0.734668,
      1.400199,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.322613,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0.035985,
      0.669260,
      NULL,
      1.106346,
      1.084568,
      NULL,
      1.949314,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.693509,
      0,
      NULL,
      2.032207,
      NULL,
      0.870385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.171046,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      4,
      1.774913,
      NULL,
      NULL,
      NULL,
      89.229908,
      3,
      NULL,
      2.701905,
      '11444',
      '02000',
      NULL,
      1.706089,
      '',
      '',
      '',
      1,
      '41304',
      '',
      '');
commit;
end;
/


