set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      3.531798,
      NULL,
      2,
      NULL,
      2.282362,
      1.591309,
      1.860386,
      '014',
      '43234431',
      2,
      NULL,
      '1324023',
      0.767118,
      1,
      2,
      0,
      '0311',
      6,
      0,
      NULL,
      NULL,
      NULL,
      115.458857,
      158.954635,
      NULL,
      NULL,
      NULL,
      ' 5-12-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 0-15-1983',
      NULL,
      '10-18-2000',
      3,
      0.727473,
      0,
      1,
      NULL,
      0.072069,
      3,
      0.477752,
      0,
      3,
      0,
      5,
      7.027728,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2,
      1,
      1.476315,
      0,
      1.344093,
      1.347971,
      0.813581,
      NULL,
      0.323201,
      NULL,
      1,
      3,
      5,
      2.841395,
      3,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      1,
      3.789838,
      1,
      NULL,
      NULL,
      0,
      0.316380,
      NULL,
      NULL,
      1.830610,
      NULL,
      NULL,
      0,
      3,
      0,
      1.999423,
      2.346006,
      NULL,
      0,
      1,
      1.080354,
      3.345223,
      3.663528,
      0,
      0.593501,
      1,
      3.162949,
      0.823376,
      3,
      1.323233,
      1.100857,
      0,
      0,
      NULL,
      6,
      1,
      1,
      2.480094,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      3,
      1,
      3,
      1,
      0,
      NULL,
      1,
      0,
      1,
      2.424423,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      1,
      0,
      1,
      0,
      3,
      NULL,
      1,
      4,
      1,
      1,
      2,
      3,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      3,
      5,
      1,
      1,
      1,
      3.442751,
      3.196986,
      ' 2-15-1987',
      82.173142,
      ' 8-17-1974',
      2,
      3,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      1,
      0,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.121629,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      6,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.906411,
      0,
      0,
      3.497305,
      4.755495,
      0,
      1.944297,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.294874,
      NULL,
      3,
      1,
      0,
      3,
      2,
      1,
      1,
      2,
      2,
      3.485961,
      1.209755,
      1.633596,
      2.130970,
      NULL,
      NULL,
      0,
      0.187405,
      1.826764,
      NULL,
      1,
      1.347468,
      1,
      0,
      0.163892,
      0,
      1.509515,
      0,
      NULL,
      NULL,
      NULL,
      5,
      7.464096,
      5,
      NULL,
      0,
      2,
      6.685279,
      0.517715,
      NULL,
      3.734475,
      12.586689,
      NULL,
      3,
      45,
      NULL,
      46,
      6,
      2,
      5.516224,
      3.895351,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      1,
      '22404',
      '3120',
      '',
      1,
      9,
      42.922110,
      14.997618,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.806226,
      2.826270,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.166667,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.824933,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.015228,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      1.362047,
      1,
      1.392972,
      NULL,
      NULL,
      NULL,
      0.607924,
      NULL,
      NULL,
      NULL,
      1.960520,
      NULL,
      1.594775,
      1,
      NULL,
      NULL,
      0.016074,
      NULL,
      NULL,
      3.095000,
      1,
      0.563889,
      NULL,
      0,
      0,
      3,
      2,
      0,
      NULL,
      1,
      3,
      0,
      3.522622,
      2,
      3.899893,
      1.607406,
      NULL,
      NULL,
      1.512266,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5.468553,
      1.188217,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276747,
      NULL,
      NULL,
      NULL,
      1.648307,
      NULL,
      NULL,
      1.870050,
      NULL,
      NULL,
      0,
      1.742899,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.576869,
      NULL,
      NULL,
      1.616771,
      NULL,
      NULL,
      1.356349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.980282,
      NULL,
      NULL,
      1.571348,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      2.762728,
      0.618670,
      0.900135,
      2,
      NULL,
      NULL,
      0.024623,
      NULL,
      NULL,
      0.764610,
      0,
      1.362776,
      0,
      0.530960,
      0,
      4.837228,
      1,
      NULL,
      0,
      1,
      NULL,
      1.774842,
      NULL,
      2.187814,
      0.357641,
      0.446263,
      2,
      2,
      1.131639,
      2,
      0,
      1.128057,
      1.397983,
      0.449738,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      3.618049,
      NULL,
      NULL,
      0.203252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.525201,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.072557,
      NULL,
      1.691202,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      0.358531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.983697,
      NULL,
      NULL,
      NULL,
      1.231550,
      NULL,
      NULL,
      NULL,
      1.883413,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.039806,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.332954,
      NULL,
      NULL,
      NULL,
      0.721857,
      NULL,
      NULL,
      NULL,
      1.394799,
      NULL,
      NULL,
      NULL,
      5.976176,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.675582,
      NULL,
      1,
      2.280883,
      25.457006,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398347,
      NULL,
      0,
      16.705471,
      1.831035,
      0.059632,
      0.035127,
      1.117425,
      0,
      1,
      NULL,
      0.843873,
      1.425453,
      0.924317,
      1.103199,
      0.615066,
      1,
      0,
      1,
      1.224139,
      1.308881,
      0.954050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.387301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.622807,
      0,
      1.762990,
      0,
      0.568573,
      NULL,
      NULL,
      0,
      0.774553,
      0,
      1.883007,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      1,
      4,
      3.563280,
      4,
      4,
      NULL,
      NULL,
      0.383588,
      3,
      1,
      0,
      1.490850,
      NULL,
      3.190155,
      0,
      NULL,
      3,
      3,
      NULL,
      2,
      1.982761,
      NULL,
      0,
      3,
      NULL,
      1.794208,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867635,
      0.722429,
      NULL,
      1.441347,
      0.643398,
      NULL,
      0.894914,
      1.574216,
      NULL,
      1.745215,
      0.896906,
      0.411623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675067,
      NULL,
      0.207181,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      2,
      1,
      3,
      51,
      66.129524,
      2,
      NULL,
      1.741331,
      '41011',
      NULL,
      '',
      0.584317,
      '',
      '',
      '',
      2,
      '33212',
      NULL,
      '');
commit;
end;
/


