set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5613373';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '4440044',
      3,
      1.010433,
      NULL,
      0,
      '3331',
      NULL,
      1.655370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0.550878,
      ' 1- 2-1987',
      14.729476,
      0.129310,
      39,
      167.177789,
      NULL,
      ' 1-21-1984',
      ' 8- 9-1995',
      ' 4- 8-1983',
      1.109710,
      NULL,
      2.682045,
      1.034873,
      1,
      0,
      NULL,
      1,
      1.518372,
      112,
      0,
      6,
      1,
      12,
      18,
      5,
      NULL,
      2,
      3,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1.325193,
      0,
      1.117526,
      0.165858,
      0.677895,
      1,
      2,
      2,
      NULL,
      3.468728,
      3,
      0,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      0,
      0,
      0,
      0,
      10,
      0,
      1,
      NULL,
      0,
      1.967813,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      3,
      0,
      5,
      1.940118,
      1.706616,
      NULL,
      0.382344,
      NULL,
      NULL,
      2,
      2,
      1,
      4,
      0,
      1,
      2,
      1,
      4,
      4,
      NULL,
      4,
      NULL,
      1.394439,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0.045624,
      1,
      1,
      1,
      2,
      2,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      3,
      1,
      1,
      3,
      0,
      5,
      1,
      0,
      5,
      3,
      5.720682,
      NULL,
      ' 9-16-1976',
      NULL,
      ' 4-23-2003',
      6.163123,
      3,
      2,
      0,
      3,
      NULL,
      NULL,
      5,
      0,
      3,
      2,
      NULL,
      1,
      4,
      0,
      3,
      5,
      4,
      8.568763,
      1,
      7,
      3.691012,
      ' 5-11-2000',
      9,
      ' 2-11-1974',
      4,
      3.546090,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.684004,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.642471,
      1.146607,
      0.776003,
      NULL,
      NULL,
      3.911607,
      NULL,
      NULL,
      NULL,
      1.086691,
      4,
      1.462113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0,
      0.833526,
      1.280071,
      3,
      161,
      0.568938,
      3.544346,
      20.104476,
      NULL,
      5.911944,
      2,
      1,
      2.020514,
      1,
      NULL,
      2,
      3,
      1,
      NULL,
      1,
      2,
      1,
      3,
      1.629093,
      1.053278,
      0.458138,
      0.146403,
      1,
      0.844368,
      2,
      NULL,
      0,
      1,
      1,
      0.612320,
      0,
      1.557159,
      1,
      0,
      0.143512,
      1,
      0,
      3.719249,
      10.105386,
      1.755498,
      11,
      2.893805,
      1.065166,
      4.317775,
      1.156643,
      0,
      1.082028,
      1.218560,
      NULL,
      55,
      2,
      0,
      NULL,
      NULL,
      35,
      80,
      NULL,
      0,
      0.490628,
      '11430',
      NULL,
      '',
      1.428795,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.238528,
      8.384687,
      104,
      20,
      1.135432,
      2,
      2.493822,
      9,
      0,
      1,
      2.833868,
      1.621072,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.489106,
      2,
      2,
      3.220782,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      2.060750,
      NULL,
      1,
      0.486905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993897,
      NULL,
      NULL,
      0.350747,
      NULL,
      NULL,
      7.731484,
      1,
      6.609062,
      0,
      3.388702,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.829926,
      0,
      NULL,
      NULL,
      0.396176,
      NULL,
      NULL,
      0.440989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.967641,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.086534,
      NULL,
      1,
      2,
      0.508305,
      0.475027,
      0.972086,
      1,
      1.781626,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.123858,
      3,
      2,
      2,
      1.376419,
      1.762731,
      NULL,
      0,
      0,
      2,
      1.796572,
      3,
      0.199199,
      0,
      NULL,
      0,
      1.253182,
      1.374508,
      NULL,
      0,
      4.727867,
      NULL,
      NULL,
      NULL,
      1.667351,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.926009,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.830319,
      0.548327,
      2,
      6,
      3,
      NULL,
      1.479105,
      NULL,
      NULL,
      4.718490,
      5.928608,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.873540,
      NULL,
      0,
      NULL,
      NULL,
      3.415763,
      0.991004,
      5.326658,
      3.718245,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.554891,
      0,
      NULL,
      1,
      1.943965,
      3.367597,
      1,
      2.369456,
      2,
      0.440081,
      NULL,
      3.579665,
      3,
      NULL,
      2.225417,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      108.761906,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      2,
      0,
      NULL,
      1.422022,
      1.641299,
      NULL,
      2,
      NULL,
      NULL,
      3,
      3.135541,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.378504,
      NULL,
      3,
      2.906489,
      NULL,
      3.022494,
      2,
      NULL,
      9.175962,
      6,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      3.811755,
      NULL,
      NULL,
      1.576870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.683026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.892282,
      3.899831,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.686517,
      0.791804,
      NULL,
      NULL,
      0,
      0.366931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640055,
      0,
      NULL,
      NULL,
      0,
      1.237307,
      NULL,
      NULL,
      1,
      1.791149,
      NULL,
      NULL,
      1.733612,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.640800,
      NULL,
      NULL,
      NULL,
      0,
      0.725867,
      NULL,
      NULL,
      5.810861,
      4.609261,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      18.682415,
      1.198065,
      NULL,
      NULL,
      1.499687,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.746618,
      NULL,
      NULL,
      463,
      6.275081,
      1,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.798807,
      3.943778,
      2.103087,
      3,
      0.238638,
      1.550047,
      0,
      0.690617,
      1.516000,
      NULL,
      1,
      NULL,
      0,
      1,
      0.535004,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      5.623175,
      271.300066,
      NULL,
      5.664822,
      16,
      NULL,
      2.603660,
      NULL,
      3,
      NULL,
      1,
      0,
      1.533138,
      1,
      NULL,
      0.639597,
      0,
      0.488745,
      2,
      NULL,
      NULL,
      2,
      3,
      1,
      0.665394,
      NULL,
      3.646891,
      0.879218,
      2,
      0.730926,
      0.073169,
      NULL,
      NULL,
      0.874464,
      NULL,
      NULL,
      0,
      0.350145,
      0,
      2.235026,
      NULL,
      2,
      NULL,
      2,
      NULL,
      56.879746,
      NULL,
      NULL,
      NULL,
      1.162717,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.637051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274073,
      NULL,
      0.663218,
      NULL,
      1.933121,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.885012,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.819147,
      NULL,
      1.875012,
      NULL,
      1.191461,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.457250,
      NULL,
      2,
      NULL,
      1.914866,
      NULL,
      124,
      NULL,
      9,
      NULL,
      1,
      NULL,
      0,
      0.433189,
      2,
      10,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      2.854016,
      1,
      0,
      1.014802,
      0,
      0,
      NULL,
      NULL,
      1,
      3.338474,
      0,
      NULL,
      NULL,
      0.282134,
      3.707907,
      NULL,
      1,
      3,
      1.466960,
      0.359768,
      0.437897,
      0,
      NULL,
      0,
      1.642726,
      0,
      1,
      NULL,
      0,
      2.194987,
      3.204416,
      2.434802,
      3.397374,
      2.277392,
      1.175660,
      1,
      2.753446,
      1,
      NULL,
      0.427434,
      1.996436,
      3.337684,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.708112,
      NULL,
      0,
      NULL,
      0.878487,
      NULL,
      1.088666,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2.162566,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.218279,
      NULL,
      NULL,
      33.454731,
      NULL,
      NULL,
      1.706570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.783372,
      0,
      0.017619,
      0,
      1,
      1,
      7,
      NULL,
      NULL,
      1.378608,
      30.884040,
      NULL,
      2,
      1.217533,
      NULL,
      '20441',
      NULL,
      '44423',
      0,
      '',
      '',
      '',
      0.285097,
      NULL,
      '',
      '');
commit;
end;
/


