set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726236';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '0201203',
      1,
      0.847391,
      3,
      1,
      '2041',
      2.857561,
      NULL,
      NULL,
      NULL,
      '11-10-1984',
      0,
      NULL,
      2,
      1.814220,
      NULL,
      ' 5-10-1975',
      92.945040,
      3,
      151.984265,
      110.192561,
      1,
      '11- 5-1979',
      ' 5- 3-1984',
      ' 3-10-1981',
      1,
      0,
      3,
      1,
      1.511571,
      0,
      6,
      2,
      NULL,
      NULL,
      NULL,
      5,
      6,
      1.962838,
      21.604016,
      4,
      8,
      4,
      1,
      NULL,
      0,
      1,
      3,
      0.582995,
      0.854186,
      NULL,
      NULL,
      1.238035,
      0.414355,
      1,
      1,
      7,
      1,
      NULL,
      0.911216,
      0,
      5,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      8,
      0,
      1,
      0,
      NULL,
      1.227129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      1.536508,
      0,
      1.283082,
      1,
      NULL,
      0,
      1,
      2,
      1,
      0,
      1.196302,
      1.890775,
      0,
      1,
      5,
      2,
      4,
      1.605987,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      5,
      NULL,
      1,
      NULL,
      1,
      1.159361,
      NULL,
      1.760085,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      4,
      NULL,
      1,
      NULL,
      4,
      NULL,
      4,
      0,
      1,
      3,
      6,
      2.310471,
      ' 9-29-1980',
      NULL,
      ' 3-20-1982',
      9,
      1.830493,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509926,
      0.964476,
      0.191814,
      0,
      0,
      0.460519,
      1.253544,
      NULL,
      NULL,
      NULL,
      1,
      1.622818,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392659,
      3,
      0.022795,
      0,
      1,
      1.382500,
      0,
      0.932265,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      0,
      0,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      0.828575,
      17.358782,
      2.257426,
      1.377561,
      0.247778,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.153618,
      NULL,
      0.582863,
      NULL,
      0.741366,
      1,
      1.213126,
      8.132531,
      NULL,
      0,
      7.882016,
      7.520499,
      3,
      NULL,
      1,
      4,
      NULL,
      0,
      1.654856,
      44,
      2,
      1.792467,
      NULL,
      NULL,
      54,
      64,
      1,
      0.620607,
      1,
      '14421',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.932018,
      NULL,
      59,
      153,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.801380,
      3.817057,
      0.451177,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.687315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.408666,
      3,
      0.816725,
      0.987524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.259862,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.379205,
      NULL,
      NULL,
      2.581708,
      5.643107,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.807320,
      NULL,
      NULL,
      NULL,
      1.632802,
      NULL,
      NULL,
      1.251960,
      NULL,
      NULL,
      0.126658,
      NULL,
      NULL,
      1.790796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.791939,
      NULL,
      NULL,
      1.283383,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.857920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.034400,
      NULL,
      NULL,
      1.747789,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.152836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.217509,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.782774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.080371,
      NULL,
      NULL,
      1.470133,
      NULL,
      NULL,
      1.078005,
      NULL,
      NULL,
      0.426155,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.838011,
      NULL,
      NULL,
      1.967906,
      0.120453,
      0.092745,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.096087,
      NULL,
      NULL,
      1.368697,
      NULL,
      NULL,
      0.276347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.085426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213082,
      NULL,
      1.571586,
      1.242973,
      1.783788,
      1.490091,
      1,
      NULL,
      NULL,
      0.851427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.251972,
      NULL,
      NULL,
      NULL,
      0.388932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900014,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.180055,
      NULL,
      NULL,
      NULL,
      1.828153,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.119070,
      2.994580,
      NULL,
      1.385045,
      1.679241,
      1.610738,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421837,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.937346,
      NULL,
      1.857887,
      NULL,
      NULL,
      0,
      1.558582,
      NULL,
      1,
      1.929427,
      0.094539,
      0.369748,
      1,
      1,
      1,
      0,
      1.943783,
      NULL,
      NULL,
      0,
      1,
      1,
      0.838773,
      NULL,
      1,
      NULL,
      1.806654,
      NULL,
      NULL,
      NULL,
      1.217705,
      NULL,
      2.597483,
      NULL,
      24.036819,
      NULL,
      0.302728,
      65,
      48.167102,
      NULL,
      1,
      NULL,
      NULL,
      0.744835,
      NULL,
      0.742039,
      NULL,
      1.064707,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.330939,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0.611884,
      0.763311,
      0,
      2,
      NULL,
      1.224389,
      NULL,
      0.326647,
      1.707137,
      0,
      NULL,
      0,
      1.952364,
      NULL,
      NULL,
      0.496176,
      NULL,
      0,
      0.033247,
      NULL,
      2.572587,
      3,
      NULL,
      0.045059,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.263533,
      NULL,
      NULL,
      1,
      NULL,
      0.073056,
      3.694680,
      NULL,
      0.658192,
      1.202225,
      NULL,
      1.209310,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.684059,
      NULL,
      0,
      5,
      0,
      0,
      NULL,
      NULL,
      27,
      NULL,
      1,
      0.936854,
      NULL,
      NULL,
      '41041',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


