set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '2103014',
      NULL,
      0,
      NULL,
      2,
      '4424',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      57.555081,
      NULL,
      NULL,
      1.614853,
      3.084259,
      NULL,
      44.317960,
      1.664062,
      165.599581,
      24.276117,
      1,
      '11- 6-1975',
      NULL,
      ' 1- 4-1997',
      2,
      0,
      3,
      3,
      1.296113,
      NULL,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      4.657400,
      2.662649,
      25,
      4,
      2.765349,
      NULL,
      3,
      NULL,
      1,
      2,
      1,
      0.912888,
      0,
      0,
      0.436773,
      2.784656,
      0.435296,
      0,
      1.325130,
      3,
      0,
      2,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      5,
      0,
      5,
      2,
      0,
      3,
      2.887309,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      3,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1.916160,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1.548777,
      0.614743,
      2,
      NULL,
      2,
      7,
      0,
      2,
      1,
      0.289233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      0,
      2,
      2,
      3,
      1,
      3,
      0,
      5,
      4,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1.775360,
      NULL,
      1,
      0,
      3,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      5,
      0,
      1,
      2,
      NULL,
      5,
      4,
      2,
      NULL,
      5,
      1,
      4,
      2,
      3,
      NULL,
      4,
      1.678067,
      2.467556,
      ' 9- 9-1986',
      7,
      NULL,
      20.991591,
      2,
      0,
      0,
      1,
      1,
      NULL,
      5,
      0,
      1,
      1,
      1,
      2,
      4,
      0,
      NULL,
      4,
      NULL,
      NULL,
      0.620340,
      1.481265,
      0.193847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.940793,
      3.771308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0.672617,
      1,
      1,
      0.860378,
      1.438136,
      1.137087,
      1,
      0.884388,
      1,
      6,
      NULL,
      0.346772,
      NULL,
      NULL,
      3,
      NULL,
      0.297521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.456959,
      0,
      1,
      1,
      1.068572,
      1.145223,
      0.236580,
      18.557874,
      1.282231,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.316689,
      1.862797,
      3,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      3,
      3,
      3.627555,
      2.298506,
      NULL,
      1,
      1.577500,
      0,
      0,
      1.327415,
      NULL,
      1.135541,
      0,
      0.057328,
      NULL,
      NULL,
      0,
      0,
      1.115255,
      2,
      0,
      3.148839,
      0,
      3,
      0.012135,
      4,
      5.799808,
      1,
      2.818333,
      NULL,
      2,
      2,
      1,
      25.159951,
      2,
      1,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      5,
      0.954330,
      '21122',
      '31444',
      '',
      NULL,
      NULL,
      '',
      '',
      1.521249,
      '',
      '',
      '',
      0,
      23,
      57,
      16,
      NULL,
      35,
      5.497731,
      1.011857,
      5,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.391569,
      NULL,
      1.700770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      NULL,
      3.803317,
      1.505972,
      3.691463,
      2.035695,
      1.908871,
      NULL,
      3,
      NULL,
      2,
      0,
      1.025016,
      1.224868,
      NULL,
      1,
      7.679463,
      2.046388,
      0.106732,
      NULL,
      NULL,
      3,
      1.422877,
      2,
      0.779710,
      NULL,
      NULL,
      NULL,
      2.565129,
      0,
      3,
      0,
      0.340506,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.847325,
      0,
      3.209748,
      2,
      NULL,
      3,
      NULL,
      2.646433,
      NULL,
      0,
      2,
      1,
      0,
      1,
      NULL,
      3.173978,
      NULL,
      1.536175,
      NULL,
      NULL,
      NULL,
      3,
      0.146839,
      8,
      NULL,
      3,
      3,
      3,
      NULL,
      1.273388,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.925579,
      1,
      0,
      1.284588,
      2.470255,
      0.222072,
      NULL,
      NULL,
      6,
      6.047154,
      0.312617,
      3,
      2.278097,
      0,
      3,
      1.133639,
      NULL,
      NULL,
      3.209469,
      NULL,
      1.484773,
      NULL,
      NULL,
      0.494514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0,
      3,
      4.779685,
      0.365753,
      2,
      2,
      1,
      1.280932,
      3,
      2.404661,
      3,
      4.676973,
      5,
      7,
      NULL,
      5.282172,
      2,
      6.785233,
      1,
      0,
      2.319168,
      0.118400,
      3,
      3.174046,
      0.981901,
      3,
      NULL,
      1,
      5,
      0,
      0.994779,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.357382,
      1,
      3,
      NULL,
      0,
      5,
      6,
      2.546323,
      3,
      6,
      3,
      3.351287,
      3,
      2,
      0,
      1,
      0.767616,
      NULL,
      NULL,
      1.221042,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.183249,
      NULL,
      NULL,
      1.232510,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      1,
      NULL,
      0.662213,
      1,
      NULL,
      2.120501,
      3,
      NULL,
      2,
      1.031802,
      NULL,
      0.111031,
      NULL,
      NULL,
      3.617010,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      3.895872,
      1.616035,
      NULL,
      NULL,
      5,
      0.918392,
      NULL,
      NULL,
      2.945712,
      NULL,
      NULL,
      NULL,
      3.852993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.893537,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.324617,
      NULL,
      NULL,
      NULL,
      0,
      0.696105,
      NULL,
      NULL,
      1.691555,
      NULL,
      NULL,
      NULL,
      1.196685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586356,
      0,
      NULL,
      NULL,
      0.776894,
      0,
      NULL,
      NULL,
      3.247442,
      0,
      NULL,
      NULL,
      NULL,
      0.260427,
      NULL,
      NULL,
      14,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      7,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.072601,
      0.443839,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249771,
      20,
      1.404703,
      0.876576,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.602912,
      1,
      1,
      0.091021,
      0,
      1,
      1,
      0.539287,
      0.629824,
      0.681451,
      2,
      NULL,
      1.489695,
      NULL,
      0.308190,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      144.808727,
      NULL,
      0.513939,
      NULL,
      27,
      NULL,
      2,
      3.248712,
      NULL,
      1.840073,
      NULL,
      1,
      NULL,
      0.052389,
      NULL,
      1.969447,
      NULL,
      1.101050,
      NULL,
      1.957361,
      NULL,
      0,
      NULL,
      0.979894,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.624117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.556454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      NULL,
      780.531997,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0.658214,
      NULL,
      NULL,
      0.178856,
      NULL,
      537,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.990824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.560375,
      1,
      0.324239,
      NULL,
      2,
      NULL,
      531,
      NULL,
      0,
      NULL,
      2.248155,
      NULL,
      2.244259,
      NULL,
      2,
      NULL,
      142.169798,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      27,
      NULL,
      3,
      NULL,
      2.348016,
      NULL,
      1,
      1,
      NULL,
      1.981500,
      0,
      0.974459,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0.809227,
      NULL,
      1,
      NULL,
      0,
      1.776629,
      1,
      1,
      1,
      1,
      0.757844,
      0.729242,
      NULL,
      1,
      0.053538,
      3.055565,
      NULL,
      NULL,
      0.422690,
      1,
      1.019984,
      NULL,
      0,
      NULL,
      0.962981,
      0.449050,
      0.008734,
      1,
      0.052091,
      1.336097,
      0.373084,
      2,
      2,
      0.448692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.016928,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      4,
      2,
      3.745252,
      3,
      51.883807,
      16.717735,
      0,
      NULL,
      NULL,
      '23230',
      '34024',
      '02422',
      0.421721,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


