set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.871696,
      4.961611,
      7,
      2,
      7.202489,
      3,
      3.206012,
      2.793707,
      '044',
      '11413224',
      58.954579,
      16.345946,
      '2414422',
      NULL,
      1.217710,
      1,
      0,
      NULL,
      3.449129,
      1.208492,
      NULL,
      NULL,
      ' 3-18-1975',
      NULL,
      32.489048,
      NULL,
      0.118073,
      1.582858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-25-1974',
      '11-22-1989',
      ' 5-28-1993',
      0.088613,
      0.399849,
      2.739333,
      0,
      1.414873,
      NULL,
      NULL,
      0,
      1,
      55.426598,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      3,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0.648352,
      NULL,
      4,
      2,
      0.934191,
      0,
      0,
      0,
      0,
      0,
      1,
      3,
      1,
      1,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.476345,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.238856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      3,
      NULL,
      0,
      4,
      0,
      3,
      NULL,
      1,
      1,
      4,
      0,
      NULL,
      2,
      0,
      2,
      1,
      1,
      4,
      2,
      1,
      4,
      1,
      4,
      NULL,
      0,
      1.781861,
      1.641763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1.221477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.826415,
      1,
      0,
      1.694657,
      0,
      1.090461,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.926816,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167887,
      1,
      1.113877,
      1.262438,
      1,
      0,
      0.385205,
      0.197690,
      NULL,
      0.513077,
      1.933506,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215572,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      3,
      1,
      0,
      3,
      0,
      NULL,
      1.732425,
      2.988813,
      0,
      1,
      0.521109,
      1.227456,
      1,
      1.838820,
      1.643044,
      0,
      0.985363,
      0,
      1,
      0.558633,
      0,
      NULL,
      1,
      0,
      10.813843,
      NULL,
      NULL,
      4.635310,
      1.127938,
      NULL,
      4.199644,
      0.839253,
      1,
      1,
      NULL,
      3.525668,
      20.042031,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      5.443458,
      3,
      '13230',
      '32414',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      15,
      101.814504,
      34,
      0.645619,
      NULL,
      16.061409,
      10,
      NULL,
      NULL,
      NULL,
      2,
      0.606564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.290805,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.840417,
      NULL,
      3.281441,
      3.106687,
      1.026142,
      3.690579,
      NULL,
      0,
      3.457961,
      NULL,
      NULL,
      NULL,
      2.806312,
      1,
      3.447450,
      1,
      2,
      3,
      NULL,
      7.438338,
      3,
      1.014288,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.925299,
      1,
      NULL,
      3.890892,
      NULL,
      0.428944,
      NULL,
      0,
      1.447514,
      1.614766,
      0,
      2.577419,
      0.930126,
      3,
      1.647685,
      NULL,
      3,
      NULL,
      0.981089,
      2,
      NULL,
      NULL,
      0.048317,
      0.913919,
      2.723189,
      1,
      1.546014,
      3,
      0,
      3,
      NULL,
      1.056652,
      2,
      NULL,
      1.421410,
      5.792581,
      1,
      1.826974,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.394514,
      NULL,
      NULL,
      NULL,
      0.676732,
      1.737113,
      2.369903,
      NULL,
      1.626653,
      NULL,
      NULL,
      NULL,
      4.331541,
      3.368034,
      1,
      0.440357,
      0,
      3,
      1.837768,
      2,
      3.505959,
      5,
      NULL,
      0.436444,
      1.248306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670553,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.501382,
      1.666837,
      0.350527,
      0,
      0.249515,
      NULL,
      3.237800,
      3,
      NULL,
      0.380162,
      2.169036,
      NULL,
      0,
      5.068159,
      1.264850,
      6.549554,
      6.801119,
      1,
      8,
      NULL,
      NULL,
      3,
      3.963750,
      1,
      1,
      2,
      3,
      2.673078,
      3,
      3,
      3.825535,
      3,
      0,
      0,
      1.504489,
      2.098173,
      2.950491,
      0.267631,
      NULL,
      1.118903,
      3.244774,
      0,
      NULL,
      3,
      NULL,
      0.052149,
      4.688878,
      NULL,
      3.711987,
      1.271715,
      NULL,
      NULL,
      4,
      0,
      0.342184,
      NULL,
      1,
      0,
      1.770329,
      0.193302,
      NULL,
      8.522812,
      3.562465,
      NULL,
      10,
      6,
      NULL,
      3.010027,
      3.860196,
      NULL,
      1.476994,
      0.564159,
      NULL,
      1,
      1.196648,
      NULL,
      1.938244,
      0.111982,
      NULL,
      1.599304,
      0.326664,
      NULL,
      0.196662,
      0.730603,
      NULL,
      3.754819,
      0.333705,
      NULL,
      3.513145,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.718872,
      NULL,
      NULL,
      2,
      1,
      NULL,
      9.677879,
      5,
      NULL,
      0.153382,
      2,
      3,
      3.700658,
      NULL,
      1.964194,
      1,
      2.637912,
      NULL,
      NULL,
      1.184770,
      5.277051,
      NULL,
      NULL,
      22.181991,
      15.830203,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1.030566,
      1,
      NULL,
      NULL,
      0.819924,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.320639,
      NULL,
      NULL,
      NULL,
      0.230775,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.219841,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826991,
      0.863343,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.528419,
      2,
      NULL,
      NULL,
      1.326799,
      0.923744,
      NULL,
      NULL,
      0.155178,
      1.598016,
      NULL,
      NULL,
      7,
      7,
      NULL,
      NULL,
      1,
      2,
      NULL,
      4,
      2,
      NULL,
      32,
      2,
      0.431772,
      1.511792,
      0.230003,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.867649,
      NULL,
      1.962597,
      NULL,
      28,
      0.995410,
      3,
      1,
      3.088772,
      0.359724,
      1,
      1.857994,
      0.996911,
      1,
      0.869536,
      0,
      NULL,
      1,
      1.791640,
      0.784653,
      1,
      NULL,
      3.666848,
      NULL,
      0.142327,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.904959,
      NULL,
      NULL,
      NULL,
      262,
      NULL,
      NULL,
      NULL,
      26,
      0,
      0.579572,
      13,
      NULL,
      0.372652,
      NULL,
      1.990979,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.723594,
      NULL,
      NULL,
      NULL,
      1.387464,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.729635,
      NULL,
      0.694613,
      2,
      NULL,
      1.754066,
      0.498633,
      NULL,
      1.212130,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.890640,
      NULL,
      0.213073,
      NULL,
      1.066734,
      NULL,
      0.351534,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.555910,
      2.686550,
      0.812577,
      0,
      NULL,
      0,
      0,
      NULL,
      0.319771,
      1.476315,
      2,
      1.255288,
      NULL,
      2,
      56,
      207,
      0.314873,
      1.044074,
      NULL,
      1.981757,
      NULL,
      NULL,
      0.756904,
      1,
      0,
      0.011306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.961228,
      2.437822,
      0.648020,
      NULL,
      0.168627,
      0.630956,
      NULL,
      759.080919,
      0,
      NULL,
      NULL,
      NULL,
      3.556061,
      NULL,
      3,
      NULL,
      NULL,
      146,
      NULL,
      5,
      0,
      1.768608,
      0.048735,
      1.176466,
      1,
      1,
      NULL,
      NULL,
      3.201917,
      3.229516,
      0.808771,
      0,
      0,
      1,
      0,
      0.274697,
      1.501785,
      NULL,
      3,
      0,
      NULL,
      2.164769,
      2,
      1,
      0.830962,
      0,
      3,
      0,
      0,
      NULL,
      0.991941,
      NULL,
      2,
      1.450908,
      NULL,
      1.911065,
      0,
      1.789718,
      0.453052,
      NULL,
      0.316448,
      1.917132,
      1,
      0.655464,
      0.808577,
      1,
      1.147646,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1.061962,
      1.752678,
      0,
      0.218441,
      1.029763,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.135313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.407806,
      1.686153,
      0.675636,
      1.296962,
      1,
      5,
      0,
      0,
      NULL,
      NULL,
      55.675287,
      14,
      2,
      5,
      4.299129,
      '00123',
      '44004',
      '',
      0,
      '',
      '',
      '',
      0.581491,
      '',
      '',
      '');
commit;
end;
/


