set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      3,
      3,
      NULL,
      2,
      NULL,
      3,
      1.558915,
      '300',
      '23241132',
      NULL,
      43,
      '2303123',
      0.458144,
      1,
      NULL,
      2,
      '1334',
      1,
      0,
      NULL,
      NULL,
      NULL,
      83,
      58.091652,
      NULL,
      1.238113,
      0.543995,
      ' 4- 1-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 4-24-1994',
      ' 1-10-1984',
      NULL,
      3,
      2,
      2,
      NULL,
      1,
      3.723018,
      0,
      1.313693,
      0,
      NULL,
      NULL,
      NULL,
      0.945048,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      0,
      1.456682,
      0.887304,
      NULL,
      NULL,
      1,
      1.898006,
      0.536420,
      28,
      7,
      2,
      3,
      1.684018,
      NULL,
      1,
      1,
      4,
      0,
      1,
      4,
      3,
      1,
      1,
      0,
      1,
      3.437576,
      0,
      NULL,
      NULL,
      0,
      1.816300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      0,
      1,
      0,
      1.643337,
      NULL,
      0.313215,
      3,
      0.196819,
      0,
      1,
      1,
      2,
      0.390607,
      NULL,
      3.960837,
      3,
      1,
      3,
      3.701296,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0.018892,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      2,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      0.504777,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      4,
      NULL,
      1,
      1,
      1,
      1,
      5,
      0,
      0,
      NULL,
      2,
      1,
      3,
      3,
      1,
      1,
      2,
      0,
      NULL,
      5,
      1,
      NULL,
      618.351411,
      ' 3-17-1980',
      116,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1.921240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.617098,
      0,
      1.864408,
      1.700949,
      1,
      NULL,
      0,
      0,
      3.774578,
      0.420274,
      0.911820,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076649,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306707,
      1.058778,
      0,
      NULL,
      1,
      0.403808,
      1.798250,
      3.257137,
      15.915086,
      2,
      2.293922,
      82,
      108.785436,
      3,
      3,
      NULL,
      1,
      1,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      0,
      3,
      0,
      3,
      0,
      0.439522,
      0,
      1.313309,
      0.956237,
      0,
      0,
      1,
      0.859297,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      4,
      11,
      0,
      3,
      1.043900,
      NULL,
      1.973841,
      0.992419,
      0.792900,
      2.829906,
      NULL,
      2,
      6,
      2,
      1.926049,
      13,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '43302',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      '',
      NULL,
      9,
      NULL,
      5,
      2,
      15.622896,
      5.337255,
      NULL,
      NULL,
      3.223945,
      2.970766,
      3.353785,
      0.424951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.140953,
      NULL,
      NULL,
      1.957022,
      NULL,
      1.609248,
      2.673491,
      0.323754,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.268834,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.175650,
      NULL,
      NULL,
      8.182627,
      NULL,
      2.506088,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.092031,
      3,
      0.870358,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      3.796160,
      0,
      1,
      3,
      3.228538,
      NULL,
      0.268541,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.591544,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      4,
      0,
      0,
      0.919433,
      NULL,
      NULL,
      NULL,
      0.955396,
      1.969681,
      2.162851,
      1.831560,
      0,
      NULL,
      NULL,
      1,
      0.819118,
      2,
      NULL,
      NULL,
      NULL,
      1.413670,
      NULL,
      NULL,
      2,
      1.156308,
      0.250399,
      2.673526,
      1,
      0.507334,
      0,
      NULL,
      NULL,
      0.363377,
      1.459336,
      1,
      0.746767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167935,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.030241,
      NULL,
      NULL,
      0.311591,
      NULL,
      NULL,
      0.565211,
      NULL,
      3,
      0.363492,
      NULL,
      NULL,
      2.465671,
      1,
      3.528625,
      2,
      1.830524,
      NULL,
      1,
      0,
      0,
      5.789587,
      1,
      2,
      1,
      3.874126,
      0,
      2.469570,
      NULL,
      2,
      0,
      3.955709,
      NULL,
      2,
      0.505467,
      NULL,
      8,
      3.209911,
      NULL,
      2,
      1,
      3,
      1,
      2,
      4,
      NULL,
      0.144621,
      1,
      NULL,
      0,
      2.034553,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083202,
      NULL,
      NULL,
      1.293748,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.814258,
      NULL,
      NULL,
      1.687648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941688,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.350204,
      0,
      2,
      1,
      0.070362,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      4.283692,
      NULL,
      NULL,
      NULL,
      2.660416,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.799054,
      NULL,
      NULL,
      NULL,
      0.773682,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.370343,
      NULL,
      NULL,
      NULL,
      6.280581,
      NULL,
      NULL,
      NULL,
      0.583980,
      0,
      5.036069,
      4,
      4,
      0.412298,
      53,
      18.870971,
      3.094088,
      37.691446,
      7.918841,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.286157,
      NULL,
      NULL,
      0.420482,
      NULL,
      1.869915,
      NULL,
      1,
      0.142961,
      NULL,
      NULL,
      NULL,
      0.123622,
      0,
      0.547593,
      NULL,
      0,
      0.681830,
      0.282887,
      1.422253,
      1.011623,
      1,
      0,
      1.469092,
      1.515271,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.306992,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1.288133,
      0.069508,
      NULL,
      1.536190,
      NULL,
      1.651816,
      NULL,
      NULL,
      0.907757,
      2.252740,
      NULL,
      NULL,
      1.609942,
      NULL,
      1.810154,
      1.218113,
      NULL,
      1.651920,
      1.749371,
      NULL,
      1.860698,
      2,
      NULL,
      1,
      1.751770,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0.979843,
      0,
      NULL,
      0.034645,
      0.549221,
      0.867270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858699,
      1.892647,
      NULL,
      NULL,
      NULL,
      0.515843,
      NULL,
      NULL,
      NULL,
      1.711564,
      NULL,
      3,
      NULL,
      0.554549,
      NULL,
      1.282499,
      NULL,
      1.053658,
      NULL,
      1,
      NULL,
      0.093574,
      NULL,
      1.570890,
      NULL,
      1.459470,
      NULL,
      66,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      5,
      1,
      1.965177,
      NULL,
      NULL,
      26,
      26,
      2,
      NULL,
      0.641856,
      '20044',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.172475,
      '3311',
      '31442',
      '');
commit;
end;
/


