set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.806845,
      1,
      0.330779,
      2.206062,
      0,
      2,
      1,
      NULL,
      '001',
      '43044024',
      32.984204,
      NULL,
      '4302041',
      7,
      0,
      3,
      NULL,
      '3411',
      2.275411,
      1,
      NULL,
      NULL,
      ' 0-29-1976',
      46.431799,
      44,
      NULL,
      NULL,
      1.909589,
      ' 8-21-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-10-1987',
      ' 2-12-1985',
      ' 5-22-1976',
      1,
      NULL,
      0.649246,
      NULL,
      3.546797,
      NULL,
      1,
      0.443811,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4,
      6,
      3.145400,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.111519,
      NULL,
      0,
      0,
      NULL,
      0.322670,
      NULL,
      NULL,
      1.024550,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      2,
      3,
      0,
      NULL,
      0,
      0,
      2,
      NULL,
      4.091548,
      0,
      1,
      NULL,
      0,
      5.866792,
      2,
      7.132473,
      1,
      4,
      0,
      0,
      0,
      4,
      0,
      NULL,
      1,
      5,
      1,
      3,
      5,
      0,
      0,
      4,
      NULL,
      0,
      5,
      0,
      2,
      5,
      NULL,
      1,
      1,
      1.643606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.851430,
      1.463604,
      2,
      0.474632,
      1,
      5.881887,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.379907,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.708468,
      NULL,
      0,
      2,
      0.093501,
      1,
      NULL,
      NULL,
      24,
      3,
      0.375933,
      97.244658,
      2.147404,
      34.530149,
      0,
      0.361532,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      3,
      1,
      2,
      0.725838,
      0,
      2.962623,
      NULL,
      NULL,
      0,
      NULL,
      1.347027,
      0.353434,
      1.547369,
      NULL,
      1.254853,
      1,
      1,
      1,
      0,
      1.608924,
      1,
      1.826703,
      NULL,
      NULL,
      5,
      6,
      3.922681,
      5,
      3,
      2,
      5,
      2,
      NULL,
      2,
      55.320937,
      1,
      NULL,
      81,
      NULL,
      67,
      NULL,
      4,
      5.985254,
      NULL,
      '13112',
      '',
      '',
      1.842071,
      '',
      '',
      NULL,
      0.749063,
      '0023',
      '',
      '',
      NULL,
      29.030136,
      315,
      24,
      1.131975,
      37,
      13,
      2,
      5,
      NULL,
      2,
      1.405214,
      1.734246,
      NULL,
      NULL,
      1.083576,
      NULL,
      NULL,
      3.524624,
      1.172233,
      NULL,
      1.997474,
      NULL,
      NULL,
      1.283125,
      0.306234,
      0,
      0,
      1.455394,
      3.536501,
      1.726537,
      NULL,
      NULL,
      0.495920,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.815653,
      1.156876,
      0,
      NULL,
      1.502555,
      1.412069,
      0,
      2.397552,
      0,
      0.121720,
      3.278356,
      0.004411,
      NULL,
      3.368638,
      NULL,
      0.650733,
      NULL,
      0.541391,
      1,
      1.571149,
      3,
      1,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      3.404418,
      1,
      NULL,
      NULL,
      1.992771,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.699303,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      2.750167,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.165544,
      1,
      0,
      2.372580,
      0,
      NULL,
      NULL,
      3.891588,
      0,
      NULL,
      1.215790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.066792,
      NULL,
      NULL,
      0,
      1.648004,
      NULL,
      3,
      0.778921,
      1,
      3.497201,
      1.162144,
      4.045906,
      1.814742,
      NULL,
      NULL,
      0.498906,
      0.917040,
      0.593631,
      2,
      2,
      3.037065,
      1.514905,
      NULL,
      1,
      0.400489,
      4.204120,
      NULL,
      2.877098,
      1,
      3,
      3.889692,
      2.283549,
      NULL,
      3,
      2.229908,
      2.547219,
      NULL,
      2.430396,
      0,
      4,
      0,
      5,
      3.915166,
      NULL,
      1,
      2.949141,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.950431,
      NULL,
      NULL,
      0.497436,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.664144,
      NULL,
      NULL,
      1.460695,
      NULL,
      NULL,
      1,
      1.013993,
      0.062305,
      1.320812,
      2.650230,
      2,
      NULL,
      NULL,
      2,
      3.427938,
      0,
      NULL,
      6,
      2.190704,
      NULL,
      NULL,
      NULL,
      1.715897,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.895769,
      NULL,
      0.996817,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.086668,
      NULL,
      1.768143,
      NULL,
      NULL,
      NULL,
      2.312071,
      NULL,
      NULL,
      NULL,
      2.278812,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.445019,
      1,
      NULL,
      NULL,
      3.300564,
      1,
      NULL,
      2.584320,
      1.336741,
      1.869173,
      NULL,
      1,
      1,
      0.756378,
      NULL,
      2,
      0,
      1,
      NULL,
      2,
      0.436986,
      1,
      NULL,
      8.526563,
      NULL,
      5.797763,
      NULL,
      1,
      3.701140,
      NULL,
      1,
      6,
      0.195947,
      NULL,
      5,
      2,
      NULL,
      12.447763,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213404,
      NULL,
      0.338134,
      4,
      2.532783,
      1.759375,
      NULL,
      NULL,
      1,
      NULL,
      0.477748,
      407.742660,
      3,
      0,
      NULL,
      0.394573,
      1.165388,
      0,
      1,
      0.910223,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.410487,
      1.290008,
      1,
      1,
      0.670422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.424401,
      1.771605,
      1.473080,
      0.491757,
      NULL,
      0,
      3,
      2.127087,
      1,
      0.585874,
      0.555842,
      1,
      1,
      2.104767,
      1,
      1.655007,
      3.011698,
      NULL,
      0.582745,
      1,
      1,
      1.803723,
      1,
      1.175956,
      0,
      1.559630,
      3.473296,
      0.110297,
      2,
      0,
      1,
      0.865314,
      NULL,
      0.727804,
      1,
      1.636160,
      0.794017,
      3.038263,
      1.369592,
      0,
      NULL,
      1,
      0.184099,
      3,
      0.250612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.907560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909220,
      0.306365,
      NULL,
      NULL,
      1,
      1.985908,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      28,
      NULL,
      3,
      4,
      NULL,
      '24222',
      '4213',
      '',
      1.552895,
      '',
      '',
      '',
      4,
      '0122',
      '4402',
      '41423');
commit;
end;
/


