set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      1,
      2,
      1,
      2.666671,
      0,
      0,
      0.422215,
      NULL,
      '14322330',
      46,
      33.243511,
      '2442330',
      4,
      1.277336,
      NULL,
      0,
      '4231',
      0.383574,
      1.817870,
      NULL,
      NULL,
      NULL,
      98,
      NULL,
      NULL,
      1.419229,
      1,
      ' 9-16-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 5-15-1988',
      '11-15-1988',
      ' 9- 3-1987',
      NULL,
      3,
      3.213936,
      1,
      0.648958,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      6.894526,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      3.179655,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1.220677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.465830,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3,
      0,
      1.538642,
      1.199090,
      0.580321,
      2,
      1,
      NULL,
      0.891728,
      NULL,
      0,
      0,
      0.577193,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1.329863,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      3,
      1,
      3.081489,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      4,
      0,
      NULL,
      4,
      1,
      3,
      3,
      1,
      5,
      0,
      NULL,
      5,
      NULL,
      NULL,
      3,
      5,
      NULL,
      1,
      4,
      3,
      NULL,
      ' 1- 5-1974',
      12,
      NULL,
      0.499761,
      1.813743,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.084037,
      NULL,
      2,
      NULL,
      0,
      0,
      2.307404,
      2.321085,
      5,
      2,
      3,
      0.404042,
      2,
      3,
      1,
      NULL,
      NULL,
      3.298711,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.234060,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.601164,
      1.008933,
      0,
      1,
      1.864894,
      1,
      3,
      24.831951,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.694104,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      1,
      NULL,
      1.982699,
      NULL,
      NULL,
      1,
      NULL,
      1.038366,
      0.594696,
      1,
      1,
      1.924001,
      0.135225,
      0,
      0.822566,
      0,
      1,
      0,
      0.773508,
      3,
      0,
      1.639551,
      NULL,
      6,
      NULL,
      1.994063,
      3.761734,
      0,
      2,
      NULL,
      3.655311,
      NULL,
      NULL,
      56.287387,
      0,
      2.687710,
      41,
      NULL,
      66,
      51.724266,
      2,
      4.229655,
      0.416983,
      '12441',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.195683,
      '4340',
      NULL,
      NULL,
      2,
      57.610533,
      NULL,
      NULL,
      NULL,
      70.943822,
      2,
      NULL,
      4,
      3,
      3.584539,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.184077,
      0.824903,
      NULL,
      NULL,
      NULL,
      NULL,
      1.087142,
      NULL,
      0,
      3,
      1.471567,
      NULL,
      NULL,
      0.236809,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.881048,
      NULL,
      NULL,
      1.601656,
      NULL,
      NULL,
      10.251210,
      NULL,
      4.770976,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.175808,
      1,
      NULL,
      0.803496,
      2.533615,
      3.532162,
      2.295907,
      1.617413,
      0.777929,
      1,
      0,
      0,
      1.270956,
      0,
      1.777010,
      NULL,
      2.677409,
      3,
      3.618095,
      1.528071,
      2,
      2.737039,
      1.573323,
      0.327990,
      2,
      NULL,
      1,
      1,
      NULL,
      1.864455,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.450945,
      1,
      3.341591,
      2.091482,
      2.838194,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.504907,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.083294,
      NULL,
      NULL,
      1.189453,
      NULL,
      NULL,
      NULL,
      1.594844,
      1.872952,
      1.005393,
      1,
      1.746892,
      NULL,
      NULL,
      NULL,
      1,
      0.170376,
      5.605153,
      1.682449,
      NULL,
      NULL,
      1.614660,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.162524,
      NULL,
      NULL,
      1.256448,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.137064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      5,
      0,
      NULL,
      NULL,
      2,
      2.701465,
      NULL,
      0.656138,
      0.338953,
      NULL,
      2,
      2.330412,
      3,
      NULL,
      7.833658,
      0.877567,
      0,
      3.041220,
      1,
      3,
      2,
      NULL,
      3.665258,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      1,
      1,
      3.826653,
      1,
      0,
      1,
      1.124822,
      1.026865,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.291021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158635,
      NULL,
      NULL,
      1.938006,
      NULL,
      NULL,
      0.468351,
      NULL,
      NULL,
      0.809673,
      NULL,
      NULL,
      0.809759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3,
      1,
      NULL,
      6,
      NULL,
      0.221333,
      NULL,
      1,
      5.752118,
      NULL,
      NULL,
      3.265330,
      NULL,
      NULL,
      NULL,
      0.451708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.789490,
      NULL,
      NULL,
      NULL,
      0.196768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774714,
      1,
      1,
      NULL,
      3,
      0,
      1,
      NULL,
      1,
      1,
      0.642151,
      NULL,
      1.503530,
      2.822111,
      0,
      NULL,
      2.700614,
      NULL,
      1.274207,
      NULL,
      3.155450,
      0.493858,
      0.267524,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      16.873804,
      NULL,
      0.659697,
      NULL,
      0.849991,
      NULL,
      4,
      4,
      NULL,
      2,
      100.291291,
      18.037141,
      1.949077,
      NULL,
      5.333805,
      0,
      NULL,
      NULL,
      1.174023,
      NULL,
      NULL,
      1.211083,
      5.406184,
      0.520003,
      1.688525,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      366,
      3.959274,
      0.647414,
      NULL,
      1.638760,
      0.270255,
      0,
      1,
      0.609071,
      0,
      1.860791,
      0.887673,
      0,
      0,
      0,
      1.101700,
      NULL,
      0,
      0.287563,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.912882,
      1.522937,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.467526,
      1.338187,
      1.616280,
      1.896147,
      1.601212,
      1,
      2.785295,
      1,
      NULL,
      1.069438,
      NULL,
      1.436127,
      0.208048,
      0.758507,
      0,
      0,
      NULL,
      0,
      1.760670,
      3,
      NULL,
      1,
      3,
      1.776077,
      1,
      1.788341,
      0.080005,
      NULL,
      1,
      0.824415,
      NULL,
      NULL,
      NULL,
      3.912426,
      NULL,
      2,
      0.922605,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.703066,
      1.905730,
      0,
      0.193025,
      1,
      1,
      1,
      NULL,
      0.980218,
      NULL,
      NULL,
      100.752622,
      NULL,
      5,
      NULL,
      5.616386,
      '01431',
      '2133',
      NULL,
      0.091822,
      '',
      '',
      '',
      2,
      '2012',
      '0020',
      '31310');
commit;
end;
/


