set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9915007';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.927405,
      1.370655,
      3.784361,
      NULL,
      NULL,
      0,
      3,
      0,
      '004',
      '13424120',
      31.132091,
      64,
      '1300401',
      NULL,
      0.419698,
      NULL,
      2,
      '4242',
      NULL,
      0,
      NULL,
      NULL,
      ' 3- 3-1978',
      NULL,
      228.514644,
      NULL,
      NULL,
      0.575991,
      '10-14-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 4-1996',
      NULL,
      NULL,
      3.240012,
      1.897442,
      0,
      2.103980,
      1,
      1,
      NULL,
      71.969282,
      0,
      NULL,
      4.531377,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1.277792,
      3,
      2,
      4,
      NULL,
      1,
      0,
      2,
      NULL,
      0,
      NULL,
      2,
      1,
      3,
      2,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.185332,
      1.401936,
      1,
      NULL,
      1.051503,
      0.822631,
      0,
      3,
      NULL,
      0.852395,
      NULL,
      0.975152,
      NULL,
      3.980450,
      1.379515,
      2.000957,
      2,
      0,
      0,
      0.071484,
      1,
      1,
      2,
      1.521723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1.651871,
      0,
      1,
      0,
      1,
      3.563653,
      NULL,
      NULL,
      5,
      0,
      4,
      0,
      0,
      3,
      1,
      0,
      3,
      4,
      1,
      2,
      5,
      1,
      2,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      2,
      4,
      1,
      1.860726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      1.157200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.017034,
      0,
      NULL,
      NULL,
      NULL,
      0.032354,
      NULL,
      7.459041,
      2.710536,
      0.354872,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1.871255,
      3.342010,
      0.851832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617146,
      0,
      0.719235,
      1.116208,
      0.081296,
      NULL,
      1.077152,
      NULL,
      1,
      1.319783,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      NULL,
      2,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      3.274058,
      NULL,
      0,
      0.134870,
      0,
      NULL,
      NULL,
      0.461533,
      1,
      NULL,
      1.556213,
      1,
      1,
      0,
      1,
      0.197773,
      NULL,
      0.611225,
      4.633419,
      7.410181,
      2,
      1.433581,
      0.708285,
      3.716126,
      3,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      1.013658,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.295729,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.514554,
      '',
      '',
      '',
      0,
      13.861211,
      45.709418,
      18.299895,
      1.594539,
      NULL,
      0.726869,
      3.716550,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.400624,
      NULL,
      NULL,
      1.192255,
      NULL,
      NULL,
      1.536685,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.954135,
      NULL,
      NULL,
      0.320794,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.312906,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844355,
      1.620585,
      1.512145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.802155,
      0.271010,
      0.756909,
      2.241207,
      NULL,
      1.803164,
      1.594789,
      NULL,
      0.389572,
      1.483676,
      1,
      1.222555,
      1.135525,
      2.546238,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.459844,
      NULL,
      NULL,
      3.341075,
      3.207730,
      2.491344,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.852837,
      NULL,
      NULL,
      NULL,
      0.837191,
      NULL,
      NULL,
      3.450833,
      1,
      1.795558,
      1.078263,
      NULL,
      NULL,
      1.580572,
      NULL,
      NULL,
      NULL,
      2,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.957321,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.333524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437345,
      NULL,
      NULL,
      9.076484,
      6.381696,
      0.423486,
      2.611093,
      3.749811,
      2.416363,
      0.495493,
      NULL,
      NULL,
      2,
      7.849412,
      7,
      8,
      0.961167,
      3,
      1.149865,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      2.768404,
      0,
      1,
      3,
      0.184918,
      NULL,
      NULL,
      2.792471,
      0.379766,
      3,
      3.437816,
      1,
      2,
      0,
      0.645979,
      0,
      1,
      0.014408,
      NULL,
      0.300774,
      6.219342,
      9,
      7,
      4,
      7.535227,
      6,
      2.722423,
      2,
      1,
      1,
      NULL,
      1,
      1.474740,
      NULL,
      3.905968,
      NULL,
      NULL,
      0.806543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510076,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.167561,
      NULL,
      NULL,
      0.633455,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.522638,
      NULL,
      NULL,
      1.773356,
      NULL,
      NULL,
      NULL,
      0.713566,
      0.536578,
      1,
      NULL,
      2.331368,
      NULL,
      NULL,
      NULL,
      1,
      1.070084,
      NULL,
      NULL,
      2.520273,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.954395,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.999921,
      NULL,
      NULL,
      NULL,
      0,
      2.583125,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.759905,
      1.664968,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.782853,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.391984,
      0.089521,
      NULL,
      NULL,
      0,
      3.457745,
      NULL,
      NULL,
      NULL,
      0.638899,
      NULL,
      NULL,
      2.443182,
      0.161425,
      NULL,
      NULL,
      0.995166,
      1,
      NULL,
      NULL,
      6.549685,
      5.242270,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.739470,
      2,
      70.517070,
      2,
      0,
      NULL,
      NULL,
      2.663426,
      7,
      1.578834,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462098,
      373.924119,
      22.338805,
      NULL,
      0,
      0.374622,
      0,
      1,
      1,
      0,
      0.431643,
      0,
      1.397174,
      1.337363,
      1,
      1,
      NULL,
      1,
      1.045616,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639589,
      1.545848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884523,
      1.279048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156058,
      0.637896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      0,
      NULL,
      0.106098,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      NULL,
      5,
      1.139725,
      0.171806,
      0,
      14.828618,
      NULL,
      3,
      NULL,
      0.196311,
      NULL,
      0,
      NULL,
      1.208878,
      0,
      1.606696,
      1.912014,
      NULL,
      1.053970,
      0,
      1.664994,
      1.235227,
      0,
      NULL,
      1.926829,
      0,
      3.406211,
      0.481542,
      3,
      NULL,
      2.459733,
      2.256418,
      3,
      1.814318,
      NULL,
      2.767006,
      1.771368,
      1,
      1,
      0,
      NULL,
      1.411980,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565795,
      0,
      1,
      NULL,
      NULL,
      1.169978,
      1,
      NULL,
      4,
      1,
      1.845964,
      0,
      38.424893,
      52,
      3,
      1.709289,
      2.046033,
      '03242',
      '',
      '',
      1.349877,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


