set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703349';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.284625,
      1,
      3.936613,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      59.299373,
      NULL,
      '3334102',
      7,
      NULL,
      1,
      0,
      '1114',
      6,
      NULL,
      NULL,
      NULL,
      ' 5-17-1986',
      77,
      NULL,
      NULL,
      1,
      NULL,
      ' 0-27-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 4- 4-1994',
      ' 1- 3-1987',
      NULL,
      0.639250,
      1,
      0,
      NULL,
      0.965654,
      3.697325,
      1,
      1,
      1.959709,
      6.031516,
      8,
      12,
      1.916489,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      2,
      0,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      3.205172,
      1,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.745421,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      5,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.133146,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      0,
      NULL,
      5,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      1,
      1,
      5,
      5,
      3,
      3,
      0,
      1,
      NULL,
      NULL,
      ' 3-12-2002',
      116,
      0.646005,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.052822,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      7.564859,
      1,
      6.303694,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      0.728198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610332,
      3,
      0.703724,
      0.655305,
      0.964344,
      1.763626,
      0.253181,
      1.544367,
      62,
      1,
      0.053016,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      2,
      3,
      NULL,
      2,
      1,
      2,
      0,
      2.473174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.755210,
      0,
      0,
      NULL,
      1.572958,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      10.433525,
      6,
      NULL,
      2.233635,
      6,
      0,
      2.742348,
      2.727100,
      2,
      2.031012,
      1,
      NULL,
      17.740972,
      2,
      0.397568,
      23,
      NULL,
      15,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      1.647039,
      '',
      NULL,
      NULL,
      0.142777,
      '',
      '',
      NULL,
      2.528434,
      NULL,
      NULL,
      34.741274,
      0.891012,
      3,
      2.896270,
      1,
      0,
      0.596533,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.073584,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.146327,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.079107,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.999541,
      NULL,
      1.943259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.945869,
      NULL,
      NULL,
      1.798053,
      0.603459,
      0,
      0,
      0,
      0,
      NULL,
      1.107593,
      0.124067,
      1,
      0,
      NULL,
      3.960372,
      0,
      0.042023,
      1,
      3,
      0,
      3.591240,
      0,
      2.606812,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.827093,
      NULL,
      NULL,
      NULL,
      6,
      1.182866,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.268710,
      NULL,
      NULL,
      NULL,
      0.259292,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3.623699,
      2.171705,
      3.848985,
      1.934635,
      NULL,
      NULL,
      1,
      5.493606,
      0,
      3,
      1,
      0,
      0.876711,
      NULL,
      NULL,
      5,
      5.604602,
      0.557470,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071876,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.061167,
      1.213844,
      1.284521,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.459571,
      NULL,
      1,
      7.840129,
      3.389455,
      1.260214,
      2,
      NULL,
      0,
      3.798758,
      3,
      0.285382,
      3.889134,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.637224,
      2.043670,
      3,
      0,
      0,
      2.301960,
      3.728901,
      3.538561,
      1.055317,
      4.566473,
      8,
      4,
      3,
      0.991499,
      6,
      NULL,
      1,
      NULL,
      0.037562,
      1.431277,
      NULL,
      1.828568,
      NULL,
      0.567789,
      NULL,
      NULL,
      1.411720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464184,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.101560,
      NULL,
      NULL,
      1.398257,
      NULL,
      NULL,
      0.897039,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.130154,
      1,
      0.598657,
      NULL,
      2,
      0.703257,
      NULL,
      NULL,
      2.999382,
      NULL,
      NULL,
      NULL,
      12.682647,
      NULL,
      NULL,
      NULL,
      2.031356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.567609,
      NULL,
      NULL,
      NULL,
      1.114146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.849244,
      NULL,
      NULL,
      NULL,
      2.231466,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.242856,
      NULL,
      NULL,
      3,
      0.734542,
      NULL,
      1.183914,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.791930,
      NULL,
      0,
      NULL,
      NULL,
      1.758166,
      1,
      0.828881,
      NULL,
      1,
      0.055732,
      1.872366,
      0,
      0.645836,
      1,
      1.368129,
      NULL,
      NULL,
      0.114782,
      0.759175,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.700197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973304,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030739,
      1.148637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593354,
      0.863692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.623003,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      91,
      NULL,
      3.356237,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.847902,
      NULL,
      29.746189,
      1.666815,
      0,
      1.478056,
      NULL,
      1,
      1,
      0,
      2,
      1.492680,
      NULL,
      NULL,
      2,
      10,
      1.536719,
      0.936319,
      0.397449,
      1,
      1.370295,
      NULL,
      0,
      1.966549,
      NULL,
      1.216664,
      NULL,
      NULL,
      0.810152,
      NULL,
      NULL,
      1,
      1.925665,
      NULL,
      NULL,
      0.167933,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.458973,
      NULL,
      0.854673,
      0,
      NULL,
      1.211619,
      0.176146,
      NULL,
      NULL,
      1,
      0.866970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.585206,
      NULL,
      0.940540,
      NULL,
      1.193174,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.563880,
      3.808392,
      24,
      64.014445,
      5,
      5,
      NULL,
      '01301',
      NULL,
      '10233',
      NULL,
      '',
      '',
      '',
      0.521213,
      '',
      '',
      '');
commit;
end;
/


