set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9030238';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '0144310',
      NULL,
      1,
      2,
      3,
      '2024',
      0,
      1.491496,
      NULL,
      NULL,
      '10-10-1989',
      79.405917,
      NULL,
      4,
      NULL,
      0.876195,
      ' 0-20-1982',
      64,
      2.526606,
      235.633848,
      29,
      0,
      ' 7-16-1999',
      ' 6-18-1996',
      ' 2-27-1984',
      1,
      NULL,
      1,
      NULL,
      1,
      3,
      3,
      1.428424,
      NULL,
      66.612048,
      NULL,
      10.484383,
      4,
      152.865214,
      183.696528,
      5,
      24.362675,
      0,
      0,
      3,
      NULL,
      0,
      0,
      0.960792,
      1,
      NULL,
      0.113354,
      0,
      NULL,
      1.535451,
      5,
      5,
      6,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      0.222857,
      NULL,
      NULL,
      1,
      0,
      1,
      1.951504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.966601,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      4,
      2,
      1,
      1,
      1,
      1,
      0,
      3,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      0,
      3,
      NULL,
      4,
      0,
      3,
      3,
      NULL,
      4,
      1,
      4,
      2,
      4,
      5,
      1,
      0,
      1,
      NULL,
      0,
      5,
      NULL,
      3.447882,
      1.915080,
      ' 6-12-1993',
      NULL,
      ' 4-17-1982',
      1355.905249,
      NULL,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1.028293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      2.392324,
      1.612966,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.475607,
      0,
      3.063361,
      1,
      1.998720,
      0,
      NULL,
      NULL,
      NULL,
      0.793679,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.480625,
      0,
      1.391593,
      0,
      1,
      0,
      0.310759,
      0,
      3,
      0.043951,
      1.529649,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.848252,
      2,
      NULL,
      1,
      3,
      3,
      3,
      NULL,
      3,
      0,
      3,
      2,
      2.523295,
      NULL,
      0,
      0.290745,
      0.744348,
      4,
      1.042385,
      0.372144,
      0.103085,
      NULL,
      1.791091,
      0,
      1,
      1,
      1,
      1.860864,
      0,
      0.636468,
      10.392794,
      5,
      7,
      5,
      11,
      2.201439,
      5,
      0.735412,
      3.396293,
      1,
      0,
      1,
      30.729450,
      3,
      2,
      NULL,
      53,
      NULL,
      47.333303,
      3,
      1.719339,
      5.951352,
      '02010',
      NULL,
      '',
      0.802742,
      '',
      '',
      '',
      4,
      '1433',
      NULL,
      '',
      3.101527,
      NULL,
      15,
      22.121585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.292582,
      3.064892,
      0.239518,
      0.921231,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.194410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649421,
      3,
      1,
      1.849586,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.825969,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954768,
      NULL,
      NULL,
      NULL,
      3,
      1.390584,
      1,
      2.790706,
      2.094179,
      0,
      0,
      NULL,
      NULL,
      1.174442,
      NULL,
      1.052741,
      3,
      0.169026,
      0.640540,
      1,
      1,
      0,
      1.309645,
      1,
      3,
      NULL,
      0,
      1.680420,
      1.806478,
      NULL,
      1,
      1,
      1.182816,
      1.262432,
      1,
      2.205406,
      3,
      1.293903,
      6.943832,
      NULL,
      1.808148,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.202897,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.155282,
      NULL,
      NULL,
      1.965549,
      0,
      1,
      4,
      NULL,
      NULL,
      2.343625,
      NULL,
      0.334769,
      0.710616,
      NULL,
      NULL,
      1,
      6,
      0.176159,
      1.204416,
      NULL,
      0.058546,
      0.676300,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.350617,
      1,
      3.773847,
      1.109299,
      NULL,
      NULL,
      0,
      7.622646,
      5.475649,
      1,
      2.973564,
      1.983930,
      1,
      0.292883,
      0,
      7.420580,
      4.277374,
      1.411287,
      5,
      4,
      6,
      5,
      1,
      2,
      3,
      1,
      2.487213,
      0,
      0,
      0,
      3,
      NULL,
      1.606768,
      NULL,
      6,
      0,
      2,
      2.946465,
      3.907616,
      1,
      3.065403,
      3.808516,
      0.746077,
      0,
      NULL,
      NULL,
      0.269092,
      1.597374,
      4.304383,
      5.417893,
      5,
      NULL,
      2.820166,
      3,
      1.936646,
      NULL,
      4,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.469897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.423448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.843259,
      NULL,
      NULL,
      0,
      0,
      0.370177,
      0.120600,
      NULL,
      0,
      1,
      NULL,
      NULL,
      4.742831,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.298423,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.932838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.312931,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      10.098703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.563392,
      NULL,
      NULL,
      NULL,
      1.041179,
      NULL,
      NULL,
      NULL,
      2.722305,
      NULL,
      NULL,
      NULL,
      0.842633,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      49.929575,
      1,
      NULL,
      NULL,
      1.501763,
      NULL,
      NULL,
      3.913137,
      60,
      25,
      1.158343,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.715030,
      NULL,
      1,
      9834.929316,
      762.185779,
      NULL,
      0,
      0,
      1.658571,
      NULL,
      1.135226,
      1,
      1.164678,
      NULL,
      1,
      NULL,
      0.909587,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.681194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      6.370453,
      3.115463,
      3,
      5.683867,
      2,
      12,
      0.575455,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.523306,
      NULL,
      NULL,
      NULL,
      1.799810,
      NULL,
      2,
      NULL,
      NULL,
      3.202829,
      0.359656,
      NULL,
      2.529690,
      2.352463,
      NULL,
      0,
      NULL,
      NULL,
      3.582514,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.797438,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890725,
      3,
      NULL,
      NULL,
      NULL,
      1.968644,
      NULL,
      0.644982,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.101623,
      NULL,
      2.531856,
      NULL,
      1.068832,
      NULL,
      3.980431,
      NULL,
      3,
      NULL,
      3.476054,
      NULL,
      0.573027,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      2.256657,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      17,
      2,
      2,
      0.456261,
      5,
      '40013',
      '10430',
      NULL,
      0,
      NULL,
      NULL,
      '',
      2,
      NULL,
      NULL,
      '');
commit;
end;
/


