set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0141275';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0,
      3.551652,
      2.461094,
      NULL,
      1,
      2.866639,
      0.345132,
      NULL,
      '1',
      80,
      22,
      '0100022',
      NULL,
      NULL,
      6,
      1,
      '0144',
      0,
      1,
      NULL,
      NULL,
      ' 1-14-1986',
      52.730853,
      11.753826,
      NULL,
      2.853321,
      0.874822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 6-29-2003',
      2,
      1.030704,
      0.588976,
      1,
      1.953879,
      NULL,
      2,
      NULL,
      1,
      5.513296,
      2,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.477034,
      0.463805,
      0,
      1.628040,
      NULL,
      1.827288,
      0,
      2,
      2,
      NULL,
      2,
      0,
      0,
      5,
      0,
      3,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0.626061,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      1,
      1,
      3,
      0,
      0,
      NULL,
      5,
      NULL,
      1,
      2,
      1,
      1,
      0,
      0,
      1.383754,
      NULL,
      0,
      1,
      NULL,
      5,
      0,
      0,
      5,
      0,
      1,
      1,
      0,
      5,
      1,
      5,
      0,
      1,
      0,
      1,
      4,
      3,
      NULL,
      3,
      3,
      1,
      NULL,
      0,
      3,
      1.221094,
      NULL,
      76,
      NULL,
      20.042076,
      3,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0.425338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257851,
      2.376303,
      3,
      NULL,
      0,
      6.178578,
      0.681379,
      0.385275,
      1.190772,
      0.300500,
      6,
      0.694343,
      NULL,
      NULL,
      NULL,
      0.151500,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.949456,
      NULL,
      1,
      3.892479,
      1,
      1.230189,
      NULL,
      0,
      4,
      1.423805,
      1.464737,
      NULL,
      NULL,
      NULL,
      1,
      0.992962,
      1.872161,
      1,
      NULL,
      NULL,
      3,
      3,
      1,
      2,
      1,
      3,
      1,
      1,
      2.326507,
      1.948169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990688,
      0,
      0,
      0.373018,
      1,
      0.020389,
      NULL,
      NULL,
      0.272299,
      1,
      4.719598,
      NULL,
      NULL,
      2,
      4.718058,
      NULL,
      3,
      0,
      7,
      3,
      2,
      3.325037,
      36,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.945682,
      1,
      '30013',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '30140',
      '',
      NULL,
      2,
      NULL,
      25.334403,
      36,
      2,
      47.154290,
      1.309080,
      3,
      3,
      NULL,
      2.353062,
      3.214317,
      1.520688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687523,
      0.359928,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.834296,
      NULL,
      NULL,
      1,
      3,
      0.842664,
      0,
      NULL,
      NULL,
      8.454924,
      5,
      NULL,
      NULL,
      1.622773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183580,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.634650,
      NULL,
      NULL,
      0.946416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.309452,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.103264,
      2.738265,
      1.067267,
      0,
      3.641503,
      1,
      0,
      2.797147,
      1.976146,
      3.943740,
      0.618850,
      4.724318,
      0.266335,
      3,
      2,
      0,
      2.020139,
      3.320727,
      NULL,
      0.736733,
      4.774940,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.708799,
      NULL,
      NULL,
      0.339565,
      2,
      0,
      3.486792,
      4,
      NULL,
      0.242677,
      5.598281,
      2,
      1.703177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084238,
      0.213666,
      NULL,
      2,
      NULL,
      3.609447,
      3.016028,
      4.378887,
      3.497174,
      0,
      2.551466,
      0.040671,
      3,
      1,
      3,
      1.074962,
      1,
      NULL,
      NULL,
      2,
      1,
      5,
      1.447624,
      3.264630,
      NULL,
      1.273731,
      5,
      0,
      2,
      1,
      1.073084,
      0.854460,
      1.211714,
      0.845013,
      1.092058,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.035841,
      NULL,
      NULL,
      1.951082,
      NULL,
      NULL,
      0.242674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.681733,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.015223,
      1,
      0.021237,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991786,
      NULL,
      NULL,
      NULL,
      3.064507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.118861,
      NULL,
      NULL,
      NULL,
      0.709113,
      NULL,
      NULL,
      NULL,
      1.164663,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.973474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0,
      1.028710,
      0.037818,
      NULL,
      NULL,
      NULL,
      2.484984,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      51.767255,
      19,
      0.588103,
      1,
      0,
      1,
      0.569074,
      1.341742,
      1,
      NULL,
      NULL,
      1.227218,
      0,
      1.932912,
      1.442490,
      0.084188,
      0,
      0.564739,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.995267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.018612,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355969,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444053,
      0.268989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297352,
      0.355463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      0.778482,
      1,
      NULL,
      NULL,
      0.714726,
      1.819365,
      0.144449,
      1.513809,
      0.773857,
      1,
      1,
      0.010618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0.317520,
      1,
      1.220330,
      0.079119,
      1,
      0,
      0.971970,
      0.765394,
      NULL,
      1.987536,
      3,
      NULL,
      0,
      0.304929,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.776455,
      NULL,
      NULL,
      1.768408,
      NULL,
      0.371321,
      0.687798,
      NULL,
      0.662553,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.882563,
      0.384441,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.130448,
      NULL,
      0,
      NULL,
      0,
      1.761297,
      NULL,
      NULL,
      28,
      NULL,
      1,
      5,
      0,
      '03321',
      '',
      '',
      1,
      '',
      '',
      '',
      0.998949,
      '03444',
      '',
      NULL);
commit;
end;
/


