set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      0,
      0.474861,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      ' 5-16-1992',
      44.441802,
      NULL,
      1,
      0.665236,
      0,
      NULL,
      29.703875,
      3,
      81,
      0,
      3,
      ' 6-16-1977',
      NULL,
      ' 4-26-1986',
      0.401097,
      1.453596,
      3,
      1.720153,
      0,
      2.839939,
      3,
      2,
      NULL,
      NULL,
      NULL,
      11.671538,
      4,
      136,
      169,
      5,
      1.317136,
      1,
      NULL,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      2.388782,
      1,
      1,
      1,
      2,
      1,
      0,
      1,
      NULL,
      0,
      5,
      0,
      3,
      NULL,
      1,
      2,
      1,
      2,
      1,
      NULL,
      NULL,
      3,
      2,
      0,
      5,
      NULL,
      NULL,
      3,
      1,
      1.141464,
      2.661415,
      NULL,
      1,
      1,
      1.492691,
      1,
      NULL,
      0,
      1,
      1.799381,
      NULL,
      1,
      2.052992,
      1,
      0,
      NULL,
      6,
      1,
      1,
      4.034826,
      0.920532,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      0,
      1,
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      3,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      5,
      3,
      1,
      1,
      0,
      3,
      4,
      4,
      2,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      5,
      NULL,
      1,
      5,
      0,
      3,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.437610,
      ' 5- 6-1978',
      7.686242,
      ' 1- 3-1997',
      2,
      0.597209,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.590197,
      3.842569,
      NULL,
      3.066835,
      2,
      0.586507,
      1.116246,
      1,
      0.858357,
      1,
      3.119780,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.311999,
      NULL,
      NULL,
      NULL,
      2.005829,
      8.458277,
      3.544214,
      0,
      5,
      2,
      7,
      ' 3-28-1979',
      NULL,
      ' 9-29-2002',
      6,
      1.658650,
      0,
      1,
      0.780750,
      1,
      0.687186,
      1,
      NULL,
      0.263613,
      1,
      0,
      9,
      3.752578,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.798469,
      2,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      3,
      3,
      2.213301,
      NULL,
      NULL,
      0.425295,
      2.727336,
      0.206665,
      NULL,
      1.723521,
      1,
      1,
      0,
      0.045701,
      20,
      NULL,
      NULL,
      3,
      1.359054,
      NULL,
      NULL,
      8.435866,
      NULL,
      NULL,
      0.685110,
      1.059626,
      4.617517,
      1,
      3.325401,
      NULL,
      3.008349,
      NULL,
      0,
      0,
      2,
      2.299259,
      NULL,
      12,
      67,
      NULL,
      0,
      NULL,
      2,
      NULL,
      '',
      '',
      1.992422,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395214,
      NULL,
      NULL,
      1.547817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700826,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354597,
      NULL,
      0.136293,
      NULL,
      1205,
      1.299563,
      1.010968,
      1,
      0.380549,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.814662,
      1.012029,
      NULL,
      1,
      0,
      1,
      1,
      1.888431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.472060,
      1.922770,
      0.413418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2.704930,
      NULL,
      NULL,
      NULL,
      16.499512,
      NULL,
      3.723012,
      NULL,
      0.006479,
      NULL,
      0.387023,
      NULL,
      3.272960,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864896,
      0.390765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419514,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.096524,
      NULL,
      3.480383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.402097,
      0.961259,
      3,
      29.101475,
      NULL,
      1.011644,
      0.469694,
      NULL,
      2,
      0,
      2,
      NULL,
      2,
      NULL,
      0.431763,
      2,
      1,
      3.215596,
      2.477970,
      3.811987,
      1.400032,
      1,
      0,
      NULL,
      1,
      0.514489,
      NULL,
      1,
      2.246684,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.715106,
      NULL,
      NULL,
      1.140048,
      NULL,
      0.786304,
      1.594199,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.752830,
      NULL,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406181,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      5,
      NULL,
      1,
      NULL,
      NULL,
      18.859288,
      NULL,
      5,
      0,
      6.353738,
      '34321',
      '22411',
      '34241',
      1,
      '',
      NULL,
      '',
      1.926081,
      '',
      '',
      '');
commit;
end;
/


