set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '3112431',
      3,
      1.902715,
      5,
      0,
      '2434',
      0,
      1,
      NULL,
      NULL,
      ' 3- 8-2000',
      44,
      NULL,
      1,
      0.754763,
      0,
      ' 4-17-1994',
      NULL,
      0.543914,
      186.906933,
      41.476614,
      0,
      NULL,
      ' 9- 5-1982',
      ' 3- 9-1993',
      1,
      1,
      3,
      3,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137895,
      7,
      102,
      12,
      3,
      7.446639,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.069097,
      5,
      1,
      5,
      0,
      1,
      2,
      5,
      3,
      0,
      5,
      3,
      2,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      1,
      0,
      2.956794,
      NULL,
      0,
      1.733263,
      NULL,
      2,
      1.506800,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.802988,
      NULL,
      1,
      NULL,
      5,
      1,
      NULL,
      NULL,
      2,
      2,
      3.254125,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      3,
      2,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      3.405270,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0.092079,
      NULL,
      NULL,
      2,
      2,
      2,
      5,
      NULL,
      4,
      5,
      2,
      1,
      0,
      5,
      2,
      1,
      2,
      4,
      1,
      5,
      2,
      2,
      1,
      5,
      0,
      1,
      3,
      NULL,
      ' 8-15-1993',
      43,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      2.418107,
      1,
      5,
      NULL,
      1.651799,
      0,
      1.622445,
      0,
      1,
      1.587405,
      0,
      0,
      NULL,
      NULL,
      7.914226,
      5,
      3.360281,
      1,
      1,
      NULL,
      3.234968,
      0.324045,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      0,
      4.319357,
      ' 0- 3-1990',
      26,
      ' 5- 9-1985',
      3.439829,
      1,
      2,
      0,
      2,
      1.821119,
      0.476087,
      0,
      NULL,
      1,
      0,
      1,
      48.368358,
      0.742180,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      2,
      0,
      3,
      1,
      2,
      0.756457,
      NULL,
      2,
      0,
      1,
      0.747778,
      NULL,
      NULL,
      0,
      1,
      14.443380,
      126.842575,
      NULL,
      3,
      3,
      3,
      0,
      9,
      8.351746,
      NULL,
      0.616964,
      0,
      5.889867,
      3.920629,
      3.543405,
      2.023534,
      3.897807,
      1.004916,
      1.040262,
      25.660470,
      3,
      0.420190,
      NULL,
      11,
      NULL,
      8.612186,
      3,
      NULL,
      1,
      '40032',
      '',
      '',
      0.081649,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1.695871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4.162435,
      1.822598,
      NULL,
      NULL,
      0.747166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686421,
      NULL,
      NULL,
      0.466908,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2781.998928,
      NULL,
      0.031303,
      3.169148,
      NULL,
      1.750331,
      1,
      1.557420,
      0,
      NULL,
      0.128437,
      1,
      NULL,
      1.279567,
      1.204723,
      1,
      1.106748,
      1.593564,
      1,
      NULL,
      NULL,
      1.129062,
      NULL,
      1,
      NULL,
      0.808009,
      NULL,
      0.287304,
      NULL,
      0.413079,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      1.759535,
      NULL,
      NULL,
      NULL,
      0.212387,
      NULL,
      0.595661,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.874483,
      NULL,
      0.175045,
      NULL,
      0.546331,
      NULL,
      0.345235,
      NULL,
      0.005126,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.439851,
      NULL,
      0,
      1,
      0.354631,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.701019,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.957878,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348299,
      0.970708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.851261,
      3,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.517171,
      NULL,
      2,
      NULL,
      1.961403,
      0,
      0.599580,
      17.174523,
      26.685458,
      3.632633,
      0.197876,
      1.106835,
      NULL,
      1,
      2,
      3,
      6,
      NULL,
      1.130375,
      0,
      NULL,
      4,
      3.516112,
      3.462069,
      1,
      NULL,
      3.291844,
      NULL,
      0.844860,
      1.757909,
      NULL,
      0,
      0.762139,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      NULL,
      2,
      0.670352,
      NULL,
      1.646636,
      1,
      NULL,
      2.388099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.271860,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628732,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      5,
      NULL,
      NULL,
      NULL,
      77,
      132.724941,
      4,
      1.596938,
      2.427681,
      '41124',
      '10412',
      '33434',
      0.608377,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


