set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '0111412',
      NULL,
      1.083228,
      2,
      0,
      '1030',
      3.197787,
      NULL,
      NULL,
      NULL,
      ' 1-23-1984',
      20.645877,
      NULL,
      NULL,
      2,
      2.615772,
      NULL,
      45.476440,
      2,
      234,
      59.731678,
      0,
      ' 5-20-1995',
      '11- 7-1975',
      NULL,
      0.765915,
      NULL,
      1.617965,
      2.858280,
      0.623600,
      1.191757,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      11,
      25,
      5,
      NULL,
      1,
      NULL,
      4,
      1.491394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      5,
      0,
      5,
      NULL,
      0,
      3,
      2,
      3,
      0,
      1,
      4,
      5,
      3.279613,
      0,
      2,
      1,
      NULL,
      1.296852,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      0.282862,
      2.835259,
      0,
      0.269029,
      3.190072,
      0.931524,
      0.586733,
      NULL,
      NULL,
      1,
      0.166964,
      0,
      0,
      1.480957,
      0,
      1,
      1,
      2,
      2,
      NULL,
      1.293670,
      1,
      NULL,
      0.763800,
      1.973802,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      0,
      3,
      NULL,
      5,
      1,
      2,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.061706,
      NULL,
      1,
      1,
      0,
      2,
      0,
      NULL,
      2,
      1,
      4,
      1,
      NULL,
      NULL,
      2,
      0,
      2,
      5,
      3,
      3,
      2,
      5,
      5,
      0,
      NULL,
      5,
      6,
      3,
      '11- 1-1976',
      69,
      NULL,
      15,
      0.684700,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.385726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9,
      2.649185,
      NULL,
      NULL,
      1,
      1,
      3.690512,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      0,
      6.516514,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.097753,
      NULL,
      NULL,
      1,
      5,
      0,
      6.147116,
      ' 3-21-1980',
      43.582076,
      ' 2-28-1997',
      4.425694,
      0.274303,
      0,
      0.176106,
      2,
      1,
      0,
      1,
      0,
      0.256200,
      0.821981,
      0,
      31,
      0.651182,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.808850,
      3.821195,
      NULL,
      1,
      2,
      NULL,
      3,
      3,
      3,
      0,
      1,
      NULL,
      3.967500,
      2.588854,
      2.069963,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.598306,
      0,
      0,
      0,
      11,
      181.309853,
      199.178483,
      0,
      2.816246,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      37,
      61,
      72.845361,
      0,
      0,
      NULL,
      '33003',
      '',
      '',
      1,
      '',
      '',
      '',
      1.182316,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      2,
      1.864049,
      NULL,
      1,
      NULL,
      NULL,
      0.557805,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.715717,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      18804,
      NULL,
      NULL,
      1,
      0.319249,
      1,
      0.468808,
      1,
      0,
      1,
      1.013248,
      0.282421,
      1.653289,
      NULL,
      0.861575,
      0.969622,
      1.605159,
      1,
      1,
      0.716045,
      NULL,
      0,
      NULL,
      2.416914,
      NULL,
      1.518029,
      NULL,
      1,
      NULL,
      0,
      NULL,
      11.620664,
      NULL,
      NULL,
      25.293464,
      23,
      3,
      3,
      4.735263,
      NULL,
      1.254863,
      NULL,
      1.052044,
      NULL,
      1,
      NULL,
      0.536006,
      NULL,
      NULL,
      NULL,
      1.287203,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.813863,
      NULL,
      1.148349,
      NULL,
      0,
      NULL,
      0.721384,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.554247,
      NULL,
      3,
      NULL,
      1,
      NULL,
      100.799022,
      NULL,
      1.990431,
      NULL,
      1.052497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282090,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043360,
      0.612031,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782716,
      NULL,
      0.461756,
      NULL,
      3.557281,
      0.230626,
      0,
      9,
      NULL,
      3.658791,
      3.627643,
      2.599904,
      3.316691,
      NULL,
      3,
      2,
      6,
      2.870748,
      3.977776,
      1.318161,
      1,
      2,
      3.765711,
      3,
      0.876706,
      0.646673,
      0.812777,
      NULL,
      NULL,
      3,
      NULL,
      1.438741,
      NULL,
      NULL,
      1.954482,
      0,
      NULL,
      2.957011,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.398248,
      NULL,
      3,
      1.403693,
      NULL,
      0.271888,
      1,
      NULL,
      3.650696,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2.384206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.360890,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      56.825563,
      21.571229,
      0,
      1.101534,
      2,
      '04321',
      '01040',
      '11410',
      1.871480,
      NULL,
      '',
      '',
      1.234408,
      '',
      '',
      '');
commit;
end;
/


