set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6316025';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '4441141',
      0,
      0.901632,
      2,
      2,
      '1310',
      1,
      NULL,
      NULL,
      NULL,
      '10-20-1981',
      24,
      NULL,
      NULL,
      NULL,
      0,
      ' 6- 8-1992',
      49,
      4,
      252.878900,
      102.287069,
      0,
      NULL,
      NULL,
      ' 9- 4-1981',
      NULL,
      NULL,
      NULL,
      0,
      1.755729,
      NULL,
      8,
      1,
      1,
      270,
      5,
      6.474645,
      NULL,
      9.556954,
      13,
      2,
      15.740160,
      1,
      3,
      6.161805,
      3.852707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      4,
      3.687265,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      1,
      3,
      NULL,
      0,
      3,
      5,
      1,
      1,
      4,
      5,
      0,
      2,
      0,
      NULL,
      1.181345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.387001,
      NULL,
      NULL,
      NULL,
      4,
      0.309073,
      1.378753,
      0.737275,
      2.207323,
      1.730359,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.644107,
      1,
      0.095817,
      0.814129,
      0.471422,
      1.135449,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.498893,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      2,
      2,
      3,
      3,
      2,
      NULL,
      3.885392,
      5.056629,
      0.476730,
      NULL,
      0,
      1,
      NULL,
      1.930316,
      0.791061,
      1,
      1.508858,
      1,
      1.607409,
      1,
      1,
      2,
      0.631929,
      2.375180,
      5.554300,
      1.576668,
      2,
      1,
      1.213382,
      2.999268,
      2.205386,
      7,
      NULL,
      NULL,
      0,
      17.282891,
      2,
      0,
      69,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.283290,
      '12312',
      '14120',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '1332',
      '1243',
      '',
      NULL,
      28,
      1155,
      6.190141,
      0,
      12.508743,
      5,
      12.874250,
      0,
      1.773793,
      NULL,
      NULL,
      0.674750,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.477832,
      NULL,
      NULL,
      1.841480,
      NULL,
      NULL,
      1.376755,
      NULL,
      NULL,
      0.267664,
      NULL,
      NULL,
      1.835508,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.808037,
      NULL,
      NULL,
      1.308263,
      NULL,
      NULL,
      0.402736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315573,
      NULL,
      NULL,
      1.080345,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.468783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.549335,
      NULL,
      NULL,
      1.648033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.457981,
      NULL,
      0.908410,
      1.664162,
      1.813246,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.663772,
      NULL,
      NULL,
      0.860455,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.300578,
      NULL,
      NULL,
      0.497753,
      NULL,
      NULL,
      0.782013,
      NULL,
      NULL,
      1.900990,
      NULL,
      NULL,
      0.545032,
      NULL,
      NULL,
      0,
      NULL,
      2,
      4,
      1,
      4,
      0.514064,
      2.326888,
      0,
      3,
      0.571398,
      NULL,
      0.760654,
      3.276985,
      0.968972,
      4.330797,
      6.897475,
      0,
      1.094768,
      1.705171,
      0.456240,
      0,
      3,
      0.860937,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.223610,
      1,
      1.296467,
      5,
      4.033618,
      0.434362,
      NULL,
      NULL,
      1,
      0,
      2.676916,
      3,
      0.982336,
      1.082848,
      7.985400,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.293967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.880393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      0.043722,
      6.786333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.984205,
      NULL,
      NULL,
      NULL,
      1.896105,
      NULL,
      NULL,
      NULL,
      1.938259,
      NULL,
      NULL,
      NULL,
      0.863748,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.798273,
      NULL,
      NULL,
      NULL,
      1.546927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9.913362,
      NULL,
      NULL,
      NULL,
      62.086910,
      NULL,
      0.089393,
      NULL,
      NULL,
      NULL,
      NULL,
      677.061747,
      256.462957,
      2.616433,
      325,
      399.915743,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868136,
      1625,
      NULL,
      2,
      1321,
      1092,
      0,
      4,
      0,
      NULL,
      46.358339,
      1.411560,
      NULL,
      1,
      0.389075,
      NULL,
      0,
      NULL,
      0.774945,
      NULL,
      1.567832,
      NULL,
      2,
      0.997237,
      NULL,
      NULL,
      1,
      1.883334,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.638367,
      NULL,
      1.536415,
      NULL,
      NULL,
      NULL,
      29.242917,
      NULL,
      18,
      14.134067,
      91,
      1.141213,
      1,
      NULL,
      NULL,
      1.192729,
      NULL,
      1.409587,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.221408,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.382171,
      NULL,
      1,
      NULL,
      1,
      1.193246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3.631863,
      0.383154,
      2,
      NULL,
      0,
      11.382804,
      2,
      2,
      2.366633,
      0,
      1.658268,
      NULL,
      0.114078,
      0.453204,
      NULL,
      1.398664,
      NULL,
      1,
      0,
      1,
      1.519032,
      3,
      0.605849,
      1,
      1.682247,
      NULL,
      1.130162,
      1,
      0,
      1.587167,
      NULL,
      0.094985,
      0.616202,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      3.986697,
      NULL,
      1,
      2.011668,
      NULL,
      NULL,
      NULL,
      1.772967,
      NULL,
      0.295543,
      NULL,
      1.002369,
      NULL,
      1.070158,
      NULL,
      1.743135,
      NULL,
      0.813721,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.437295,
      NULL,
      0,
      NULL,
      NULL,
      10,
      NULL,
      1.505495,
      0.586650,
      NULL,
      3.415776,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.195842,
      NULL,
      3,
      NULL,
      3.069155,
      NULL,
      3,
      NULL,
      3.945009,
      NULL,
      NULL,
      NULL,
      0.075538,
      NULL,
      0,
      NULL,
      0.805577,
      NULL,
      1.362645,
      8,
      1.516133,
      0.026739,
      NULL,
      0.497413,
      1.912657,
      0,
      1.809336,
      1,
      3,
      NULL,
      4,
      0.736785,
      NULL,
      NULL,
      73.847183,
      3,
      3,
      1,
      7,
      '33441',
      '02244',
      NULL,
      0.285336,
      '',
      '',
      NULL,
      0.949561,
      '0130',
      '1224',
      '41020');
commit;
end;
/


