set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03',
      NULL,
      7.488375,
      40,
      '1001403',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.533492,
      0.526546,
      NULL,
      NULL,
      ' 9-20-1993',
      5.422704,
      42,
      NULL,
      0,
      2,
      ' 2-16-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 1-16-1987',
      ' 8-19-1985',
      '11- 0-1991',
      3.418727,
      0.953147,
      NULL,
      3,
      0,
      3,
      2,
      1,
      0,
      NULL,
      5,
      NULL,
      3.110215,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      0,
      3,
      NULL,
      1.298716,
      NULL,
      1.006325,
      1.969360,
      NULL,
      1.507269,
      NULL,
      1.895423,
      2,
      2,
      NULL,
      2,
      2,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      3,
      1,
      1,
      4,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      0.489341,
      NULL,
      NULL,
      1,
      3,
      1,
      3,
      1,
      0.037019,
      2.046500,
      2,
      0.116573,
      1.661287,
      2,
      0,
      0,
      0,
      1.240286,
      0.008965,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      7,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      0,
      0,
      2,
      5,
      5,
      5,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      5,
      5,
      NULL,
      NULL,
      3,
      2,
      0,
      3,
      NULL,
      3,
      NULL,
      NULL,
      ' 1-28-1982',
      NULL,
      ' 0-12-1984',
      NULL,
      1,
      0,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.739092,
      3.494042,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.631023,
      NULL,
      2,
      1.006007,
      1,
      NULL,
      1,
      NULL,
      5.686372,
      NULL,
      2,
      0.738574,
      NULL,
      NULL,
      NULL,
      0.606539,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.810314,
      0.918201,
      1.323719,
      NULL,
      NULL,
      2,
      52,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      2,
      2,
      0,
      2,
      0,
      1,
      3,
      NULL,
      2,
      NULL,
      0.147581,
      1,
      0,
      0.992675,
      2,
      0,
      0,
      NULL,
      1.233981,
      0.944894,
      NULL,
      0.784956,
      1,
      0,
      1,
      2.680439,
      0.344338,
      10.873230,
      9,
      6.515962,
      NULL,
      4,
      6,
      NULL,
      2,
      0,
      NULL,
      3,
      0,
      30,
      1,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      2,
      NULL,
      3,
      '14112',
      '03122',
      '',
      1,
      '',
      '',
      '',
      1.022183,
      '',
      '',
      '',
      1.194159,
      31.884504,
      NULL,
      33.489489,
      0.798488,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.516024,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.350738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.871743,
      NULL,
      1.925770,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.655787,
      0,
      0.293468,
      NULL,
      NULL,
      1.548867,
      NULL,
      NULL,
      7.655351,
      2.674179,
      0,
      0,
      0.650621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111757,
      1.250094,
      0.036767,
      0,
      2,
      0,
      NULL,
      NULL,
      3.079591,
      NULL,
      NULL,
      3.628503,
      1.849624,
      0.248060,
      0.272293,
      3.842494,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      3,
      3,
      1,
      NULL,
      NULL,
      1.779797,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.027393,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.818615,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.235845,
      0,
      0,
      0.601404,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.184370,
      NULL,
      3.152056,
      1.729962,
      NULL,
      NULL,
      NULL,
      2.948149,
      NULL,
      1,
      2.496235,
      0,
      NULL,
      NULL,
      0.397392,
      NULL,
      5.750170,
      0,
      0,
      1.772577,
      2,
      3.803310,
      1,
      0,
      2.710260,
      NULL,
      NULL,
      2,
      1.004881,
      3.682648,
      1,
      NULL,
      3.955777,
      NULL,
      5,
      0.314640,
      0.710906,
      0,
      0,
      1,
      0.076055,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.188831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969797,
      0,
      1,
      1,
      1.393872,
      0.680884,
      0.746279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      146.472402,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.037015,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.124831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.127112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.066709,
      1,
      0,
      3.300708,
      23,
      3.333216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.890217,
      NULL,
      0,
      423,
      1.420468,
      0.994758,
      1.443178,
      0.226115,
      NULL,
      0.333478,
      0,
      1.457867,
      0,
      1.234548,
      1,
      0.021063,
      1,
      1,
      0.316660,
      NULL,
      NULL,
      1.359366,
      2.124805,
      NULL,
      0.499873,
      NULL,
      1.094542,
      NULL,
      0,
      NULL,
      3.739207,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.776906,
      1.067496,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.471202,
      NULL,
      0.036971,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.488348,
      NULL,
      1.839661,
      NULL,
      1,
      NULL,
      0.796050,
      NULL,
      1.491479,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      3.800761,
      0.665733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167833,
      0.671404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.689209,
      NULL,
      NULL,
      NULL,
      0.508111,
      NULL,
      1.789802,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081205,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.859692,
      0.848521,
      1.875280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.352569,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.367644,
      NULL,
      0,
      NULL,
      0,
      1.568431,
      0,
      14.079424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      6.882598,
      1,
      2.193129,
      3.692435,
      2,
      8,
      NULL,
      0.850352,
      1,
      1.342372,
      0,
      NULL,
      1.693564,
      1.830165,
      NULL,
      0,
      0.813157,
      NULL,
      0,
      NULL,
      NULL,
      1.144022,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.849448,
      NULL,
      0.814994,
      0.018040,
      NULL,
      0,
      0.553256,
      NULL,
      0.334138,
      1.409113,
      NULL,
      0.105983,
      1.311180,
      1.558663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.007920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      22.122381,
      60.643310,
      1,
      1.270326,
      2.380145,
      '24321',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


