set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      '3232',
      1,
      1,
      1.036496,
      NULL,
      ' 2-13-1977',
      48,
      NULL,
      2,
      0,
      3.400708,
      '10-25-1990',
      NULL,
      NULL,
      29.737566,
      30.486958,
      1,
      ' 2-17-2002',
      ' 8- 9-1991',
      NULL,
      3,
      NULL,
      NULL,
      2.427865,
      1,
      0.926078,
      1,
      0.528049,
      0,
      23.008010,
      5,
      11.090577,
      5.262164,
      0,
      12,
      3,
      16.697720,
      3,
      0,
      6.292147,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.573950,
      NULL,
      NULL,
      1,
      1.390206,
      4.029820,
      5,
      5,
      3,
      1.769345,
      1,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1.083354,
      NULL,
      1.340100,
      3,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      4,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      2,
      4,
      0,
      5.269599,
      0.931498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      0.779023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      17,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.970033,
      1,
      NULL,
      NULL,
      0.915974,
      NULL,
      NULL,
      NULL,
      NULL,
      3.241425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700083,
      3,
      NULL,
      3,
      NULL,
      1,
      0.317698,
      0.043897,
      7.097874,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.743466,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      2,
      0,
      2.304263,
      1,
      0.758017,
      NULL,
      0,
      0.531344,
      6.288698,
      NULL,
      1,
      0.230587,
      1.687307,
      0.646437,
      NULL,
      NULL,
      1,
      1,
      12.480767,
      NULL,
      1.317128,
      6.566053,
      8,
      NULL,
      9.457712,
      0.058086,
      1.007864,
      4,
      1,
      3,
      3.253073,
      0.879789,
      3,
      39,
      NULL,
      2.165581,
      NULL,
      11,
      NULL,
      3,
      2,
      NULL,
      3,
      '30330',
      '',
      '',
      1.291427,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      4.298055,
      25,
      19.476554,
      1,
      52.637079,
      NULL,
      9,
      4,
      NULL,
      2,
      0.525767,
      0,
      NULL,
      NULL,
      1.522057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794900,
      NULL,
      NULL,
      3,
      2.781058,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.527836,
      NULL,
      NULL,
      0.143518,
      NULL,
      NULL,
      1.812861,
      NULL,
      NULL,
      6,
      NULL,
      0,
      1,
      0.680443,
      NULL,
      NULL,
      NULL,
      0.078042,
      NULL,
      NULL,
      NULL,
      1,
      0.785459,
      1.537054,
      0,
      NULL,
      NULL,
      0.052486,
      NULL,
      NULL,
      1.131605,
      0,
      NULL,
      2,
      1,
      0.452314,
      2.706963,
      0.375874,
      2,
      1.569635,
      0,
      3,
      0,
      NULL,
      2,
      NULL,
      0.737616,
      NULL,
      NULL,
      1.913614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8,
      1.776245,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.008990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.912507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625680,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.739092,
      1.698935,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.859891,
      2,
      3,
      0.431108,
      1.613768,
      0,
      NULL,
      8.126834,
      NULL,
      5,
      5,
      9,
      0.073074,
      NULL,
      NULL,
      3,
      NULL,
      1.913419,
      0,
      0,
      2,
      NULL,
      1,
      NULL,
      10.882289,
      1.924603,
      6,
      2,
      2,
      2.664994,
      0,
      NULL,
      1,
      1.508673,
      1.608195,
      0,
      2.118751,
      2,
      0.577688,
      6.565032,
      1,
      NULL,
      5,
      3.901833,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0.723269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.086706,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.284005,
      NULL,
      NULL,
      3.619098,
      NULL,
      1,
      0.903571,
      NULL,
      2.297339,
      2,
      NULL,
      NULL,
      5.663095,
      NULL,
      NULL,
      NULL,
      2.409619,
      9,
      NULL,
      NULL,
      1.654247,
      3.615837,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.785371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.255161,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.301174,
      3,
      NULL,
      NULL,
      0.027656,
      2,
      NULL,
      NULL,
      0.828253,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.146178,
      4.968047,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      35.685745,
      3,
      6.618120,
      0,
      1.428199,
      NULL,
      NULL,
      NULL,
      11,
      3,
      1.659278,
      13,
      0.437761,
      0.385041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2058,
      5.125121,
      NULL,
      0.246686,
      NULL,
      3,
      1,
      3,
      0,
      1.196233,
      NULL,
      1,
      1.702859,
      1,
      0,
      0.808901,
      1,
      0.622855,
      1.345942,
      2.876302,
      NULL,
      1,
      NULL,
      1.748200,
      NULL,
      1.820462,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.713203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.675060,
      NULL,
      1.624121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.127974,
      NULL,
      0.918376,
      0.133077,
      3.467530,
      NULL,
      0,
      NULL,
      0.651014,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.241687,
      NULL,
      NULL,
      1.495024,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.664163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.334052,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.816540,
      NULL,
      NULL,
      0,
      1.598927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1.685060,
      3.043424,
      3,
      2,
      3,
      2,
      0,
      0.342974,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.656480,
      0,
      0,
      1.083414,
      NULL,
      NULL,
      1.198310,
      0,
      0.463136,
      0.763327,
      1,
      NULL,
      1.946104,
      NULL,
      1.118942,
      NULL,
      2.895707,
      0.841673,
      0.461878,
      NULL,
      NULL,
      NULL,
      0.851721,
      1,
      1.436780,
      NULL,
      1.544578,
      1.767231,
      2,
      NULL,
      1,
      1.873913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.367978,
      NULL,
      0.265555,
      NULL,
      1.345335,
      NULL,
      3,
      NULL,
      3.604087,
      NULL,
      2.516478,
      NULL,
      1,
      NULL,
      0.196499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.695364,
      NULL,
      1,
      17.292897,
      1,
      NULL,
      1.274165,
      1.531966,
      1.444602,
      1.035621,
      1.204971,
      0.124661,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      45,
      17.537075,
      5,
      1,
      2.021294,
      '22130',
      '',
      '',
      0.756081,
      '',
      '',
      '',
      1.254417,
      '',
      NULL,
      NULL);
commit;
end;
/


