set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228176';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '0314402',
      2.427735,
      0,
      NULL,
      NULL,
      NULL,
      1.081455,
      1,
      NULL,
      NULL,
      ' 9- 9-1985',
      45.641951,
      NULL,
      0,
      1,
      1.234944,
      ' 0- 6-1983',
      54.762996,
      5.471628,
      211,
      68,
      0,
      ' 2- 4-1978',
      NULL,
      ' 5- 5-2001',
      1.107350,
      0,
      3,
      0,
      0.008913,
      0,
      1,
      1,
      1,
      11.872348,
      2,
      NULL,
      NULL,
      NULL,
      22,
      0,
      6,
      1,
      NULL,
      6,
      1.863666,
      2,
      NULL,
      0.881000,
      1,
      1.425232,
      1.128626,
      1.193012,
      0,
      1,
      0.316320,
      0,
      1,
      4,
      0,
      3,
      0,
      3,
      1,
      0,
      0,
      5,
      1,
      0,
      NULL,
      3,
      0,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613164,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      3.991380,
      0,
      1,
      2,
      0.915030,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      4.175233,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      5,
      0,
      1,
      4,
      1,
      1,
      1,
      3,
      3,
      3,
      1,
      4,
      4,
      2,
      2,
      4,
      5,
      2,
      5,
      3,
      0,
      2,
      2,
      NULL,
      2,
      1,
      1,
      ' 2-23-2001',
      1007.674108,
      ' 0-24-2001',
      33.651167,
      2.003994,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      2,
      0,
      1.019147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.770893,
      3.899219,
      0.128363,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.672605,
      1.343939,
      NULL,
      NULL,
      NULL,
      NULL,
      0.116924,
      NULL,
      NULL,
      7.796586,
      5,
      3,
      2.354400,
      4.297557,
      NULL,
      1.247649,
      8.823594,
      0.126700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.365110,
      0,
      0.226410,
      NULL,
      1,
      1,
      1.766767,
      3.386452,
      6,
      0.882614,
      1.232277,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      3,
      1,
      0,
      2,
      2,
      NULL,
      0,
      1,
      1,
      2.402674,
      1.097860,
      NULL,
      2.621030,
      1.166490,
      1.483371,
      1.317320,
      0,
      0,
      0,
      1,
      0.415630,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      11,
      6,
      5.621059,
      5,
      4.796593,
      5.046542,
      0.693675,
      5.548207,
      3,
      0.546265,
      0.011477,
      NULL,
      1,
      NULL,
      NULL,
      17,
      37,
      NULL,
      2,
      1,
      3.185030,
      '13434',
      '33312',
      '',
      1.081059,
      '',
      '',
      NULL,
      0.107495,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      46,
      0,
      39,
      3.138852,
      1,
      2,
      0,
      1.660108,
      1,
      0,
      NULL,
      NULL,
      1,
      1.071571,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041052,
      NULL,
      NULL,
      0.497639,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.300673,
      NULL,
      NULL,
      11.526436,
      2.839991,
      3,
      2,
      0.507570,
      NULL,
      NULL,
      NULL,
      2.314553,
      NULL,
      0.960852,
      NULL,
      NULL,
      1,
      0.199722,
      0.967022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043804,
      0,
      0,
      NULL,
      0.020278,
      1,
      1.886381,
      0.854830,
      1,
      NULL,
      0.938382,
      1,
      NULL,
      1.772756,
      0,
      NULL,
      0.389833,
      NULL,
      NULL,
      1.307759,
      NULL,
      NULL,
      1,
      NULL,
      1.947120,
      2.472230,
      0,
      1.125569,
      0,
      0.130865,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.400378,
      0.186509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      1,
      NULL,
      NULL,
      7.514320,
      3,
      0,
      3.132410,
      1.614616,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1.620062,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3.158783,
      1,
      NULL,
      NULL,
      0.561682,
      1,
      2.737659,
      5.983872,
      2.228826,
      NULL,
      0,
      NULL,
      NULL,
      2.238279,
      1,
      1.305818,
      NULL,
      3.918781,
      3,
      NULL,
      0,
      2,
      3,
      3.457121,
      3.974788,
      3,
      2,
      3,
      NULL,
      NULL,
      NULL,
      2.093481,
      0.418307,
      0,
      1.178911,
      1,
      1.323928,
      1.492156,
      NULL,
      3,
      5,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      1,
      1,
      0,
      3.736468,
      NULL,
      NULL,
      1.872233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734545,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.037596,
      1,
      0,
      1.543214,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.463492,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0.821885,
      NULL,
      NULL,
      NULL,
      1.398248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934533,
      1.998988,
      NULL,
      NULL,
      3,
      1.916890,
      NULL,
      NULL,
      1.177559,
      0.079217,
      NULL,
      NULL,
      1.030177,
      1,
      NULL,
      NULL,
      0,
      0.857030,
      NULL,
      NULL,
      1.511994,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.103599,
      3.806896,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.276949,
      9.985116,
      NULL,
      NULL,
      3.738068,
      NULL,
      4.187137,
      0,
      1,
      1.086988,
      3,
      3.591315,
      3,
      0.889086,
      0.868369,
      0.350266,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074020,
      0,
      NULL,
      NULL,
      0.183500,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      222,
      19.404412,
      1.221839,
      0,
      NULL,
      0,
      0.631369,
      1,
      NULL,
      1.477594,
      1,
      1.248127,
      2.856832,
      1.271831,
      NULL,
      1,
      0,
      NULL,
      2.768016,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2.509864,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      2.379808,
      1.047609,
      NULL,
      0.413395,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.757026,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.533134,
      NULL,
      1.451903,
      NULL,
      1.883414,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.428642,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.979341,
      NULL,
      NULL,
      NULL,
      0.074285,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      NULL,
      0.769887,
      NULL,
      8.288919,
      NULL,
      4.725576,
      NULL,
      NULL,
      NULL,
      1.774167,
      NULL,
      1.680455,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.396102,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      51.462808,
      NULL,
      NULL,
      NULL,
      0.134783,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      25.379163,
      0.354914,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      0.880105,
      NULL,
      2.014782,
      0.794180,
      3,
      8,
      0.263814,
      2,
      1.997215,
      1.830580,
      1.488570,
      NULL,
      NULL,
      0.839444,
      NULL,
      1.215981,
      NULL,
      NULL,
      0.683496,
      1,
      NULL,
      2,
      0.001432,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.107169,
      0,
      NULL,
      1,
      0,
      NULL,
      3,
      2,
      NULL,
      0,
      0.542253,
      NULL,
      1.106204,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      6,
      0,
      0.595111,
      NULL,
      NULL,
      2.942664,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.007813,
      NULL,
      '',
      NULL);
commit;
end;
/


