set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9128147';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '3444322',
      2,
      0,
      2,
      3,
      '3313',
      3.128536,
      1,
      NULL,
      NULL,
      ' 2-20-1989',
      9.049495,
      NULL,
      3,
      NULL,
      0.149340,
      ' 2-12-1994',
      43.467453,
      0.852448,
      38.176251,
      83,
      NULL,
      ' 2-11-1990',
      ' 6-13-1999',
      ' 3-26-1995',
      3.095283,
      0,
      NULL,
      1.658279,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.238294,
      0.136171,
      NULL,
      13,
      1,
      4,
      NULL,
      0,
      NULL,
      1,
      0.291611,
      0,
      1,
      1.119560,
      0.160611,
      1.060692,
      1.175985,
      0,
      0,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      5,
      0,
      NULL,
      3,
      3,
      NULL,
      2,
      10.365132,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1.416229,
      0.250007,
      3.020605,
      NULL,
      1,
      2.064708,
      NULL,
      1.529314,
      NULL,
      0,
      0.164521,
      NULL,
      NULL,
      0,
      3.284486,
      NULL,
      2.128969,
      0,
      3,
      2,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.546950,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      1.102960,
      NULL,
      0,
      1,
      3,
      1,
      3,
      1,
      NULL,
      1,
      5,
      4,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      4,
      5,
      4,
      4,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      6,
      2.748077,
      ' 2-11-1995',
      121,
      ' 5-13-1991',
      276,
      1.031601,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0.529261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.826514,
      1,
      2.460047,
      0.364335,
      0.371100,
      0,
      1,
      3,
      4.616039,
      NULL,
      2,
      5,
      0.367688,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693597,
      1,
      1.193606,
      1.274530,
      0.425621,
      1.258142,
      1.400189,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.685028,
      1,
      NULL,
      3,
      1,
      1,
      2,
      1,
      0,
      0,
      0,
      0.188037,
      2.626147,
      1.196736,
      NULL,
      0.007651,
      NULL,
      3.144986,
      0,
      1,
      NULL,
      1,
      NULL,
      0.091033,
      0,
      1,
      0,
      1.581896,
      0,
      NULL,
      1.402671,
      4.383919,
      NULL,
      0.785589,
      4,
      0,
      0.365502,
      2,
      3.561704,
      0.351721,
      0.249203,
      1.766724,
      21.033965,
      0,
      NULL,
      NULL,
      24,
      17,
      58.695596,
      4,
      1.192205,
      NULL,
      '34244',
      '00110',
      '10221',
      0,
      '',
      '',
      '',
      0.668841,
      '',
      NULL,
      '',
      0.082681,
      29,
      NULL,
      31.273873,
      2,
      14.965614,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.883357,
      1,
      NULL,
      NULL,
      0.719881,
      NULL,
      NULL,
      1,
      0.023579,
      2,
      1,
      NULL,
      NULL,
      2,
      2,
      3.665982,
      1,
      1.891379,
      NULL,
      3,
      0.049790,
      0.431533,
      NULL,
      2.600283,
      0.819604,
      2,
      NULL,
      NULL,
      2.446432,
      3.845338,
      2,
      3.275974,
      2,
      1,
      5,
      3.935092,
      2.624714,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.559926,
      0.907909,
      2.250888,
      1,
      0,
      NULL,
      2.695556,
      NULL,
      0,
      0,
      NULL,
      3,
      2,
      2,
      NULL,
      3.060096,
      1.928616,
      1.925636,
      NULL,
      NULL,
      0.349363,
      0,
      0,
      0,
      1,
      0.977606,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.027055,
      NULL,
      5.327666,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.820310,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.209426,
      NULL,
      NULL,
      0.165592,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.043670,
      8,
      1,
      1.160663,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.656611,
      NULL,
      NULL,
      1.727164,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257419,
      1.547316,
      0,
      1.630049,
      NULL,
      0,
      5,
      3,
      1,
      1.865680,
      NULL,
      NULL,
      0.347145,
      NULL,
      NULL,
      1.091364,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.127771,
      7.106898,
      NULL,
      0.963876,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.916263,
      3.986749,
      2,
      2.698436,
      0,
      NULL,
      0.689535,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.157930,
      0.186424,
      1,
      0,
      1,
      0.911776,
      NULL,
      NULL,
      1.570219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.807808,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      2.956593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.771712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.996147,
      NULL,
      NULL,
      NULL,
      1.468797,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.969206,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.430218,
      NULL,
      NULL,
      NULL,
      0.265280,
      NULL,
      NULL,
      NULL,
      6.901217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817933,
      12,
      1,
      1,
      NULL,
      NULL,
      0.224676,
      NULL,
      NULL,
      3,
      0,
      0.814512,
      3,
      4,
      0.430203,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.646720,
      1,
      0,
      0.245488,
      1.504475,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1.053978,
      0.270264,
      1,
      1,
      1.033966,
      0.807695,
      NULL,
      0.809508,
      NULL,
      NULL,
      NULL,
      0.365327,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.805339,
      14,
      NULL,
      1.899422,
      0.483502,
      NULL,
      NULL,
      3,
      NULL,
      1.985176,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.591964,
      NULL,
      0.233299,
      NULL,
      0.148855,
      NULL,
      0.176318,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.807435,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.332149,
      1.258483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508072,
      3.179356,
      NULL,
      0,
      NULL,
      0.448784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218423,
      NULL,
      1.160953,
      2.661495,
      2.220646,
      1,
      2,
      0,
      3,
      NULL,
      78,
      0.540358,
      2,
      1.753404,
      3.760439,
      1.795652,
      1,
      NULL,
      NULL,
      1.590401,
      1.295312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.412938,
      NULL,
      NULL,
      2,
      2.360320,
      1,
      2,
      1.119579,
      0,
      NULL,
      50.192067,
      NULL,
      0.292975,
      NULL,
      0,
      1,
      1.596452,
      1.021397,
      3,
      26,
      43,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      1.931353,
      3,
      1.734353,
      2,
      2.425656,
      1.290999,
      1,
      0.157123,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.171578,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.908680,
      NULL,
      1,
      2.611428,
      NULL,
      0.456880,
      0.668195,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208579,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      2,
      4,
      1,
      NULL,
      NULL,
      7,
      66,
      5,
      0,
      2.020994,
      '13031',
      NULL,
      '11222',
      0,
      '',
      '',
      '',
      1.854273,
      '',
      NULL,
      '');
commit;
end;
/


