set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7310941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.701448,
      0,
      3,
      NULL,
      0.371955,
      2.517986,
      NULL,
      '340',
      '0',
      46.721752,
      40.718829,
      '3040442',
      0,
      1.026325,
      2,
      0,
      '0233',
      0.494161,
      NULL,
      NULL,
      NULL,
      ' 5-17-1981',
      NULL,
      0,
      NULL,
      NULL,
      2.438500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.038076,
      3.254620,
      0,
      2.443811,
      4,
      2.852604,
      NULL,
      NULL,
      NULL,
      9.566735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.254843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      4,
      1.792726,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1.976770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.382465,
      1,
      1,
      NULL,
      1.735482,
      2,
      0.087577,
      0,
      3,
      0.373428,
      0.900411,
      2.597661,
      0.366092,
      0.119162,
      1.910441,
      1.035003,
      0,
      1,
      5,
      2.461159,
      0,
      1,
      0.310893,
      0,
      NULL,
      NULL,
      1.816485,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1.986024,
      1,
      NULL,
      0,
      1,
      0.669094,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      4,
      NULL,
      0,
      NULL,
      4,
      5,
      2,
      3,
      5,
      0,
      5,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5,
      2,
      3.081060,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.178343,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.235387,
      8,
      0.451948,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.198427,
      4,
      1.156870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.845615,
      0.094676,
      1,
      0,
      1.554247,
      1.208791,
      1.937036,
      NULL,
      0.890133,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.551484,
      2.555697,
      3,
      NULL,
      2,
      0,
      3,
      2,
      1,
      0,
      0,
      3,
      3,
      1,
      NULL,
      0.483557,
      1.602984,
      0,
      3,
      0.843249,
      0,
      4,
      0,
      0.213211,
      0,
      0.394987,
      NULL,
      NULL,
      1.675284,
      2,
      1.569813,
      NULL,
      1.343929,
      6.138475,
      1,
      9.756711,
      2.943844,
      NULL,
      NULL,
      3.902289,
      NULL,
      2.793984,
      0.447801,
      8.911450,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1.376579,
      '42313',
      '',
      '',
      1.005277,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      23,
      125,
      13.056640,
      1,
      16.763814,
      NULL,
      2,
      1,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.685094,
      1.820044,
      NULL,
      1.424659,
      NULL,
      NULL,
      1.315603,
      NULL,
      NULL,
      3.955802,
      1.143487,
      NULL,
      1,
      NULL,
      NULL,
      1.927687,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.895209,
      0,
      1,
      1.379352,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.718007,
      1.914516,
      1.863910,
      0,
      0,
      1.846967,
      NULL,
      1.148042,
      NULL,
      3.803636,
      1.628768,
      3,
      NULL,
      2.590585,
      1,
      0.169711,
      2.900351,
      NULL,
      1,
      3.411381,
      1.646370,
      0,
      3,
      NULL,
      0,
      1.118500,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.964989,
      1.054347,
      9.013105,
      1.321496,
      0.278644,
      0,
      0.720120,
      NULL,
      NULL,
      NULL,
      1.134691,
      NULL,
      NULL,
      NULL,
      0.324580,
      NULL,
      1.123477,
      NULL,
      0.696223,
      1,
      3,
      0.063126,
      1.190846,
      0.556375,
      NULL,
      NULL,
      0,
      1.069024,
      0.311132,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      9,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.133090,
      NULL,
      NULL,
      0.053222,
      NULL,
      NULL,
      0.639114,
      NULL,
      NULL,
      0.948423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549780,
      NULL,
      NULL,
      1.342053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.021368,
      NULL,
      NULL,
      2,
      1.477382,
      0.512331,
      NULL,
      3,
      0,
      3.882812,
      1,
      NULL,
      4,
      NULL,
      4.908644,
      NULL,
      1.807337,
      3.823006,
      NULL,
      NULL,
      1.418805,
      3,
      0.010418,
      3,
      3,
      NULL,
      3.882188,
      9,
      NULL,
      4,
      3.419084,
      1,
      1.990848,
      2.495023,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      1.037453,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.875140,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.076682,
      NULL,
      NULL,
      3.379902,
      NULL,
      NULL,
      NULL,
      1,
      0.390765,
      NULL,
      1,
      3.569621,
      2.148039,
      NULL,
      NULL,
      3,
      5,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.131417,
      NULL,
      NULL,
      NULL,
      1,
      1.581911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.560504,
      NULL,
      NULL,
      NULL,
      0.484707,
      1.091443,
      NULL,
      NULL,
      1.867334,
      1,
      NULL,
      NULL,
      0.130724,
      1.245521,
      NULL,
      NULL,
      2.505030,
      1.346145,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.454962,
      NULL,
      NULL,
      0,
      3.409464,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0.372845,
      NULL,
      NULL,
      1.655303,
      1,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      1.974157,
      NULL,
      NULL,
      NULL,
      3.672480,
      20.216131,
      12.943507,
      1.317678,
      12.796814,
      26.538548,
      0.404760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095025,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.888983,
      NULL,
      1,
      77.491501,
      1,
      1.920568,
      0,
      0.474216,
      1.047585,
      1,
      1.938414,
      0.323872,
      1,
      NULL,
      0,
      1.106370,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      2,
      NULL,
      0,
      1,
      4,
      NULL,
      2.184235,
      0.592869,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.032766,
      1.656834,
      0.207522,
      2.533343,
      NULL,
      0.978620,
      1.292851,
      NULL,
      NULL,
      1,
      0,
      0.674309,
      1.692626,
      0.805847,
      3.310093,
      1.462837,
      0.869771,
      3,
      3.714859,
      NULL,
      NULL,
      1.711091,
      0,
      1.014473,
      3.003414,
      1.897031,
      1.320099,
      NULL,
      2,
      0.614228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669691,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      26.927979,
      5,
      4.601010,
      NULL,
      '32114',
      NULL,
      NULL,
      1.696040,
      '',
      '',
      '',
      0.408404,
      '',
      '',
      '');
commit;
end;
/


