set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9220323';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '2300444',
      NULL,
      NULL,
      NULL,
      NULL,
      '0224',
      2,
      1,
      NULL,
      NULL,
      ' 2-14-1975',
      NULL,
      NULL,
      2,
      NULL,
      0.030790,
      NULL,
      26,
      0,
      54,
      1.981680,
      1,
      ' 7- 2-2000',
      ' 5-13-1978',
      ' 1-14-1992',
      0.707501,
      1.102841,
      3.831141,
      NULL,
      0.987306,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.257547,
      28,
      3,
      NULL,
      3,
      NULL,
      7,
      1.793900,
      1,
      1,
      1,
      0.865508,
      1.625080,
      1,
      1.402382,
      1,
      NULL,
      0,
      2,
      1,
      2,
      1.836319,
      NULL,
      NULL,
      1,
      5,
      3,
      NULL,
      3,
      0,
      0,
      0,
      0,
      3,
      1.643272,
      3,
      2,
      1,
      1,
      1.809346,
      NULL,
      NULL,
      0.072316,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.269442,
      3,
      1,
      0.702044,
      1.445131,
      NULL,
      NULL,
      1.614507,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      0,
      1,
      1,
      2.521807,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1,
      3,
      NULL,
      5,
      1,
      0,
      3,
      1,
      0,
      0,
      0,
      1,
      2,
      0,
      0,
      0,
      1,
      4,
      0,
      5,
      3,
      2,
      3,
      0,
      1,
      NULL,
      1,
      ' 8- 3-1991',
      38.568560,
      ' 4-29-1993',
      10,
      1,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      3,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.896853,
      3.723145,
      1,
      0.588797,
      0,
      1.441051,
      0,
      0,
      0.413229,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.163783,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      3,
      2.357197,
      0.830604,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      2,
      2,
      3,
      1,
      0,
      2,
      3,
      1,
      2,
      NULL,
      0.359844,
      1.561564,
      1,
      0,
      NULL,
      0.982193,
      1,
      NULL,
      0.700430,
      0,
      0.771126,
      1.324331,
      1.338121,
      0,
      0,
      0.454879,
      1.751276,
      0,
      1,
      3.271259,
      7,
      0,
      0,
      7.566602,
      4.308674,
      1,
      NULL,
      0,
      2.109882,
      0.522278,
      59,
      0,
      NULL,
      NULL,
      43,
      36,
      42,
      NULL,
      1,
      NULL,
      '41304',
      '32222',
      '42331',
      1,
      '33230',
      '',
      NULL,
      0,
      '',
      '',
      '',
      2,
      15,
      69,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335119,
      NULL,
      NULL,
      1.299110,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.338045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.965644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.951200,
      NULL,
      NULL,
      1.917095,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.660100,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.892059,
      NULL,
      NULL,
      1.735543,
      NULL,
      NULL,
      0.247958,
      NULL,
      NULL,
      2.684830,
      3,
      1.150400,
      0.768780,
      NULL,
      NULL,
      NULL,
      5.145838,
      2.812744,
      1,
      NULL,
      NULL,
      0.224591,
      NULL,
      NULL,
      1.555616,
      NULL,
      NULL,
      1.386186,
      NULL,
      NULL,
      2,
      2.209025,
      0.908751,
      NULL,
      2.425252,
      NULL,
      NULL,
      2.731597,
      3,
      1,
      0.655565,
      1.410961,
      2.215188,
      5.494205,
      5.348531,
      0,
      0.374173,
      1.785514,
      1.034122,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0.270822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641425,
      NULL,
      0.492828,
      1,
      1,
      1.171606,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089551,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      14,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.978710,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.900794,
      0.279836,
      NULL,
      1,
      1.196837,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.734371,
      NULL,
      0,
      NULL,
      0.335277,
      0.182572,
      0.668482,
      1.381918,
      NULL,
      NULL,
      0.341504,
      NULL,
      0,
      NULL,
      0.313972,
      NULL,
      1.176481,
      NULL,
      0,
      NULL,
      0.463886,
      NULL,
      1.881962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.794626,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141907,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.568605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.023546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805805,
      0.323383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.831207,
      1,
      0,
      NULL,
      NULL,
      1.030749,
      NULL,
      3.096561,
      0.607168,
      2,
      NULL,
      2.416171,
      NULL,
      NULL,
      NULL,
      0.010654,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.582100,
      16,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      4,
      NULL,
      1.568311,
      4,
      3,
      0.179725,
      1,
      1.474553,
      NULL,
      NULL,
      2.740719,
      NULL,
      1.924474,
      2.482092,
      NULL,
      0,
      1.162426,
      NULL,
      1,
      0.979370,
      NULL,
      0.970805,
      0,
      NULL,
      0.626742,
      3.511134,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1.831811,
      1.444486,
      NULL,
      0.715135,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.121459,
      NULL,
      NULL,
      NULL,
      1.747172,
      NULL,
      0,
      6,
      0,
      1.544290,
      NULL,
      NULL,
      26.622353,
      29,
      1,
      1,
      3.069192,
      '24232',
      '21113',
      NULL,
      1,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


