set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7112759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '4011422',
      2.709638,
      1,
      2,
      3,
      '4330',
      3.392596,
      3.714473,
      5,
      39.721280,
      ' 4-24-1977',
      39,
      NULL,
      0,
      3.688678,
      0.824988,
      ' 8- 5-1999',
      42,
      NULL,
      292.082552,
      56,
      NULL,
      NULL,
      '11-14-1995',
      ' 0-28-1984',
      1.077216,
      1,
      NULL,
      0.773973,
      1,
      NULL,
      0,
      0.884640,
      NULL,
      32.689664,
      0,
      0.242345,
      NULL,
      10,
      9.952269,
      3,
      NULL,
      4,
      0,
      6.382461,
      NULL,
      0,
      2,
      1,
      1.614947,
      0,
      1.833101,
      1.381382,
      1.890160,
      1.299970,
      0.881141,
      3,
      NULL,
      4,
      1.867101,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      4,
      0,
      0,
      1,
      1,
      1.667637,
      NULL,
      NULL,
      0.924519,
      1,
      NULL,
      5,
      0,
      0,
      2.627813,
      0.985420,
      1.226127,
      3,
      1,
      NULL,
      3.325222,
      2,
      0.554659,
      1,
      1,
      0,
      0,
      3.132835,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      1.755375,
      NULL,
      NULL,
      1.295552,
      0,
      2,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      2,
      NULL,
      0,
      1,
      5,
      1,
      0,
      0,
      0,
      1.852924,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      0,
      2,
      5,
      1,
      1,
      NULL,
      0,
      0,
      3,
      0,
      1,
      0,
      2,
      4,
      5,
      1,
      NULL,
      1,
      0,
      2,
      2,
      NULL,
      NULL,
      ' 4-13-1992',
      24.779997,
      NULL,
      5.646952,
      3,
      2,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1.705075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      16,
      0,
      0,
      3,
      0,
      0,
      0.435109,
      NULL,
      NULL,
      4,
      3.072335,
      1,
      NULL,
      NULL,
      NULL,
      5.330823,
      5.467752,
      NULL,
      8,
      7.450948,
      1.871693,
      NULL,
      1.192166,
      NULL,
      NULL,
      3,
      10.961676,
      3.331744,
      NULL,
      2,
      2,
      0,
      ' 5-12-1991',
      22.608846,
      ' 7- 3-1992',
      12,
      2.750893,
      NULL,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.905010,
      1.850730,
      3.058598,
      0.352533,
      1.197047,
      NULL,
      NULL,
      NULL,
      0,
      1.709252,
      2,
      2,
      3,
      1,
      1,
      1,
      2,
      2,
      3,
      2,
      NULL,
      2,
      NULL,
      2.316958,
      0.399489,
      1.563240,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1.297664,
      NULL,
      0,
      0.504220,
      0.915645,
      0.738799,
      0.525869,
      3.775230,
      7.328794,
      NULL,
      NULL,
      2,
      NULL,
      1.133961,
      6,
      2.568278,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      19,
      65.074986,
      1,
      NULL,
      3.414848,
      '03034',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      2.982022,
      NULL,
      0.899510,
      7,
      0.642827,
      3.370427,
      2.739586,
      0,
      4,
      0,
      NULL,
      NULL,
      1.436520,
      NULL,
      NULL,
      1.847895,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.485716,
      NULL,
      NULL,
      1.595236,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.815517,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.485929,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.637036,
      0.544344,
      0,
      1.803858,
      NULL,
      NULL,
      0.253895,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.854429,
      NULL,
      NULL,
      1.103692,
      NULL,
      NULL,
      0.948757,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.041730,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.254853,
      NULL,
      NULL,
      0.943016,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.795463,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.781760,
      2.729723,
      NULL,
      0.303623,
      NULL,
      3,
      1,
      2.749677,
      5.379785,
      0,
      2.766357,
      1.466002,
      0.980282,
      0.468212,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.749597,
      NULL,
      1.276487,
      NULL,
      0.667680,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.512442,
      1.944051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099489,
      2,
      NULL,
      0.202036,
      NULL,
      1,
      1.556817,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.629292,
      NULL,
      NULL,
      NULL,
      0.939121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.670902,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.486967,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.936683,
      NULL,
      NULL,
      NULL,
      2.885861,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398452,
      NULL,
      NULL,
      NULL,
      3.089902,
      2,
      0.944269,
      1.870676,
      0,
      NULL,
      0.210566,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.300654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.696929,
      NULL,
      5.849470,
      0.565270,
      0,
      1.047908,
      NULL,
      NULL,
      1.920722,
      0,
      0.942078,
      0.973272,
      1.871013,
      0,
      NULL,
      0,
      NULL,
      1,
      0.930918,
      NULL,
      1.802148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      13,
      4,
      NULL,
      2,
      2,
      11,
      2,
      1,
      0,
      NULL,
      0,
      1,
      1.938534,
      0.414715,
      1.686729,
      1,
      1.091569,
      1.724470,
      0,
      0.877491,
      1.677820,
      1,
      NULL,
      1.435408,
      0,
      0.274741,
      1,
      1,
      0,
      0.310915,
      0,
      1.144786,
      0,
      NULL,
      0,
      0.558808,
      1.570491,
      0.558089,
      1,
      1.178956,
      1.331569,
      NULL,
      0.563869,
      NULL,
      0.447754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.040471,
      0,
      1,
      0.817499,
      0,
      0.881435,
      1,
      3,
      3,
      1.707704,
      NULL,
      NULL,
      NULL,
      77,
      4,
      1.506122,
      5,
      '13002',
      NULL,
      '',
      0.765408,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


