set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8900515';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '0344043',
      0.742958,
      1.655696,
      3,
      1,
      '3302',
      3.525055,
      0,
      NULL,
      NULL,
      ' 9- 5-2002',
      24,
      NULL,
      4,
      1,
      0,
      ' 3-14-1987',
      26.696538,
      2,
      NULL,
      135,
      NULL,
      NULL,
      ' 1-20-1988',
      ' 3-10-2002',
      1.992242,
      0,
      3,
      1,
      0.929817,
      1.211339,
      NULL,
      1,
      NULL,
      NULL,
      7,
      1,
      NULL,
      80,
      99.796247,
      5,
      15,
      1,
      1,
      NULL,
      NULL,
      3,
      0,
      1,
      1.933247,
      0.513453,
      1.892227,
      NULL,
      1.701182,
      0.542509,
      NULL,
      0,
      3,
      4,
      0.435765,
      4,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      3,
      1,
      1,
      1,
      2,
      6.790913,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.510693,
      NULL,
      NULL,
      5,
      1,
      0.277724,
      0,
      0.873844,
      1,
      0.918468,
      1.330967,
      NULL,
      0.190020,
      0,
      0.923417,
      NULL,
      0,
      0,
      1.430448,
      1.478980,
      0.544601,
      1,
      1,
      0,
      1,
      3.346925,
      0,
      1,
      1,
      1.646088,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1.642348,
      4,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      1,
      5,
      4,
      1,
      4,
      0,
      NULL,
      1,
      2,
      0,
      5,
      NULL,
      1,
      5,
      NULL,
      ' 7- 1-1976',
      336.901835,
      ' 8- 0-1996',
      54.635103,
      NULL,
      1,
      1,
      1,
      4,
      4,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577710,
      0,
      5.883949,
      0.256934,
      1.140192,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.828595,
      1.815972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196599,
      0,
      1.063057,
      1.519364,
      3,
      3.810835,
      1,
      1,
      86.361627,
      2.628225,
      0.986350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.041560,
      3,
      2,
      3,
      0,
      2,
      3,
      NULL,
      2,
      1,
      NULL,
      2,
      2,
      19.828779,
      0,
      1.458705,
      0.058900,
      0,
      0,
      1,
      0,
      0.414974,
      1,
      1.711111,
      NULL,
      1,
      NULL,
      0.337853,
      5.743802,
      0.479783,
      3,
      7,
      6,
      5.943871,
      0.277536,
      6,
      3.836826,
      3.874144,
      2,
      NULL,
      0,
      0,
      NULL,
      1,
      2.861890,
      NULL,
      NULL,
      NULL,
      33.089785,
      4,
      0,
      2,
      '20134',
      '',
      '',
      0,
      '',
      '',
      NULL,
      2,
      NULL,
      '',
      '',
      3,
      13.898594,
      219.889517,
      6.256133,
      3.888502,
      32,
      1,
      5,
      1,
      0.944161,
      2,
      1.502297,
      0.671507,
      NULL,
      NULL,
      0.356244,
      NULL,
      NULL,
      1,
      1,
      0.750955,
      1.957034,
      NULL,
      NULL,
      0.350388,
      NULL,
      NULL,
      2,
      0.350157,
      0.229478,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.519881,
      NULL,
      NULL,
      0.488174,
      0.000047,
      1,
      1,
      1,
      NULL,
      NULL,
      0.083221,
      3.842040,
      NULL,
      0,
      2.850375,
      1,
      3,
      0.843411,
      2,
      1.073790,
      NULL,
      1.003504,
      0,
      0,
      0,
      0.546101,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.866457,
      NULL,
      1.678246,
      0.243460,
      0,
      0,
      1,
      NULL,
      1,
      1.026185,
      1.386081,
      0.188407,
      0,
      NULL,
      NULL,
      0.543373,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      5,
      1.900988,
      NULL,
      2.612042,
      NULL,
      0,
      3,
      2.048612,
      0,
      2.154181,
      3,
      1,
      NULL,
      NULL,
      1,
      0.015743,
      0,
      3,
      2.550458,
      1,
      1,
      NULL,
      NULL,
      9,
      NULL,
      2,
      1.294013,
      1.146622,
      2.186476,
      0.031492,
      NULL,
      NULL,
      9,
      NULL,
      0,
      0.202255,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.228521,
      NULL,
      NULL,
      1.345201,
      NULL,
      NULL,
      0.337624,
      NULL,
      NULL,
      2.208617,
      0,
      1.448287,
      2.639127,
      1,
      3.719614,
      6,
      5,
      4,
      3,
      NULL,
      NULL,
      9.453420,
      9.773993,
      5.373127,
      2.707726,
      0.720525,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.002740,
      0.781637,
      NULL,
      7.611699,
      7,
      3.038032,
      2.809189,
      3,
      2,
      1,
      2.030411,
      1.355200,
      3,
      NULL,
      NULL,
      1.187162,
      NULL,
      8.022119,
      NULL,
      7.907319,
      2,
      0,
      7.400061,
      3.115294,
      4,
      NULL,
      0,
      NULL,
      1.594634,
      NULL,
      0.667917,
      3,
      NULL,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.683967,
      NULL,
      NULL,
      0.664972,
      NULL,
      NULL,
      0.857300,
      NULL,
      NULL,
      1.652945,
      1.153926,
      NULL,
      1,
      NULL,
      NULL,
      3.766501,
      2.963791,
      NULL,
      3.372718,
      1,
      NULL,
      3,
      3,
      NULL,
      2,
      1.695029,
      NULL,
      3.166844,
      2,
      NULL,
      4.115476,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.141344,
      1.812681,
      0,
      NULL,
      3,
      7.738745,
      5.791412,
      NULL,
      1,
      5,
      275.161838,
      NULL,
      1.450422,
      2.323616,
      0,
      NULL,
      1.423259,
      NULL,
      0.610000,
      NULL,
      1.472690,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2.031733,
      NULL,
      NULL,
      0.102185,
      3.558286,
      NULL,
      3,
      1.761531,
      0,
      NULL,
      2.255782,
      2.477393,
      NULL,
      NULL,
      0,
      0.403092,
      0,
      NULL,
      NULL,
      1.218510,
      0,
      NULL,
      0.872609,
      1.985761,
      0,
      NULL,
      NULL,
      2.234697,
      NULL,
      NULL,
      1,
      2,
      2.835409,
      NULL,
      NULL,
      0,
      0.878369,
      NULL,
      3.861236,
      0,
      2.044800,
      NULL,
      NULL,
      1,
      0.731287,
      NULL,
      NULL,
      4.864429,
      NULL,
      NULL,
      3,
      1.807572,
      NULL,
      NULL,
      NULL,
      2.317078,
      96,
      44.143312,
      1.306213,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.643402,
      1.313489,
      0,
      NULL,
      11,
      11,
      3.696933,
      6,
      2,
      0.098158,
      NULL,
      1.662616,
      NULL,
      0,
      0.211480,
      1.458222,
      1.336728,
      1.444814,
      0,
      1.692424,
      NULL,
      0.899065,
      0.384223,
      0,
      0,
      1.314062,
      1.799886,
      0.037023,
      1.070414,
      0.961779,
      1,
      1.899202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      0.766307,
      9.227740,
      NULL,
      0,
      9.511883,
      2.310422,
      NULL,
      3,
      0,
      0.484817,
      0.270054,
      0,
      NULL,
      0,
      1.784005,
      1,
      1,
      0,
      0,
      1,
      1,
      1.952993,
      0.985844,
      0.335799,
      NULL,
      NULL,
      0.447282,
      NULL,
      0,
      0.033423,
      2,
      0.647086,
      1,
      1.530931,
      1,
      1,
      0,
      NULL,
      NULL,
      0.330218,
      1,
      2,
      3.095679,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.077076,
      NULL,
      NULL,
      1.118669,
      NULL,
      2.498548,
      NULL,
      0.933642,
      NULL,
      3.357152,
      NULL,
      0.467382,
      NULL,
      2.779969,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.326994,
      NULL,
      0.765535,
      NULL,
      0.323063,
      5,
      NULL,
      NULL,
      0.332988,
      0.952174,
      0,
      2,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1.868049,
      66.100189,
      3.258151,
      NULL,
      0.418961,
      0.540945,
      '22441',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '4011',
      '',
      '');
commit;
end;
/


