set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6702935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '0423241',
      NULL,
      0.866605,
      0,
      2,
      '3323',
      NULL,
      2,
      4,
      32,
      ' 8- 4-1997',
      33,
      NULL,
      2,
      2.261774,
      NULL,
      '10- 6-2000',
      108.655658,
      3,
      NULL,
      154.696222,
      3,
      NULL,
      NULL,
      '11- 9-1999',
      1,
      NULL,
      0,
      0.925552,
      NULL,
      0.882847,
      1,
      NULL,
      0,
      267,
      NULL,
      3.455180,
      6.522692,
      4,
      3,
      NULL,
      14.613540,
      1,
      2,
      2.725688,
      0.641754,
      1,
      0,
      0.325158,
      1.701593,
      1,
      0.037424,
      1.769977,
      0,
      1.677851,
      3,
      5,
      4,
      0,
      1.571266,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      3.381931,
      0,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      1.443002,
      NULL,
      NULL,
      1,
      1,
      1,
      0.602433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.896781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      5,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0.862190,
      NULL,
      1,
      0,
      0,
      1,
      2,
      5,
      3,
      4,
      NULL,
      4,
      4,
      4,
      2,
      3,
      1,
      0,
      3,
      2,
      NULL,
      4,
      1,
      5,
      5,
      0,
      NULL,
      1,
      ' 9-13-1999',
      436.447904,
      ' 3-14-1987',
      251.687066,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0.120968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042268,
      0,
      0,
      NULL,
      1,
      1.089894,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441226,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.165127,
      0,
      0.863827,
      0.187358,
      0.117064,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3,
      0,
      0,
      2,
      NULL,
      2,
      2,
      NULL,
      1,
      3,
      1,
      2.184822,
      1.630022,
      9.566447,
      NULL,
      1,
      6.794473,
      NULL,
      NULL,
      1.548122,
      NULL,
      NULL,
      0,
      1.107878,
      0,
      2,
      0.168325,
      3,
      1,
      2,
      5.680714,
      NULL,
      NULL,
      0.899541,
      6.785363,
      2.562715,
      0,
      NULL,
      2.939709,
      0.651377,
      1,
      1.910443,
      3,
      0.797208,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628802,
      NULL,
      '12230',
      '',
      '',
      1,
      '',
      '',
      '',
      4,
      '44222',
      NULL,
      NULL,
      1,
      42.270259,
      NULL,
      NULL,
      2.213989,
      NULL,
      53,
      12.908780,
      3,
      0.202575,
      1.357383,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082862,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.849700,
      3.653367,
      1,
      NULL,
      NULL,
      1.998103,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.332449,
      1.483316,
      1.452174,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      8.899188,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.466663,
      1,
      NULL,
      NULL,
      1.484480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141526,
      NULL,
      1.889689,
      1.530450,
      1.284727,
      1.706192,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      0.613379,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.003437,
      2,
      0.555970,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      2,
      1.073643,
      0.683739,
      NULL,
      NULL,
      3,
      2.458842,
      1,
      2,
      NULL,
      2.493892,
      3.234552,
      1,
      19,
      7,
      1,
      0,
      1.220089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.511480,
      0.969641,
      NULL,
      0.040576,
      1.403592,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      9.749871,
      6.169915,
      5.498824,
      4,
      1.513545,
      0.515384,
      3.035709,
      NULL,
      0.532115,
      3.760911,
      3,
      2.706070,
      NULL,
      3,
      3.708852,
      6,
      0,
      6,
      0.259255,
      3.818058,
      0,
      0,
      13.107381,
      3.332497,
      0.235068,
      3.800680,
      2.304184,
      2,
      3,
      3,
      0.202563,
      4.269758,
      8,
      NULL,
      4,
      NULL,
      1.425754,
      1,
      1,
      2.444717,
      NULL,
      1,
      NULL,
      1.405507,
      1.744538,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.648820,
      NULL,
      NULL,
      1.903148,
      NULL,
      NULL,
      2.497349,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739132,
      NULL,
      NULL,
      0.941468,
      NULL,
      NULL,
      1.938884,
      NULL,
      NULL,
      1.765188,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.002639,
      NULL,
      NULL,
      0.170998,
      3,
      NULL,
      0,
      0,
      NULL,
      3.347047,
      7,
      NULL,
      2,
      1,
      61,
      NULL,
      33.808230,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.977839,
      NULL,
      2,
      NULL,
      3.287458,
      NULL,
      1.985470,
      1,
      0.338084,
      NULL,
      NULL,
      NULL,
      1.082552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803194,
      1.194007,
      3,
      NULL,
      NULL,
      NULL,
      3.082013,
      NULL,
      NULL,
      NULL,
      0.685130,
      NULL,
      NULL,
      NULL,
      1.327282,
      NULL,
      NULL,
      NULL,
      3.224325,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      1,
      1.687430,
      NULL,
      2,
      NULL,
      3.900099,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.873473,
      2,
      1,
      NULL,
      1.592741,
      0.134848,
      3.128749,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      22.618263,
      106.316298,
      3,
      NULL,
      9.443808,
      0,
      NULL,
      NULL,
      0.533969,
      NULL,
      NULL,
      1.692484,
      NULL,
      NULL,
      1.457233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.383087,
      2,
      0.650931,
      1.727253,
      0.517714,
      NULL,
      1.302127,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1.551601,
      1,
      1.431407,
      0.551477,
      NULL,
      1.850197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      4,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      2.990521,
      1.020695,
      0,
      1.404039,
      18.827923,
      6,
      1.782299,
      1.866670,
      0.931333,
      0.798438,
      NULL,
      1,
      NULL,
      2.542071,
      3.979285,
      2,
      2,
      1,
      0.194393,
      NULL,
      0,
      3,
      3,
      NULL,
      1.727894,
      0,
      0.887582,
      1,
      NULL,
      3,
      3,
      0,
      3.531347,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873896,
      0,
      0.008087,
      1,
      1.928706,
      1.278298,
      1,
      NULL,
      5,
      0,
      3.151339,
      NULL,
      38,
      50.508215,
      4,
      1,
      2,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '2403',
      '00433',
      '3043');
commit;
end;
/


