set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8013144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '0121332',
      0,
      1.499419,
      2,
      1,
      '3011',
      0,
      NULL,
      NULL,
      NULL,
      ' 5-21-1980',
      46,
      NULL,
      2,
      NULL,
      0.580663,
      NULL,
      NULL,
      2.079676,
      63,
      120.858444,
      0,
      ' 4-18-1991',
      '11-13-1994',
      ' 4-19-1991',
      NULL,
      NULL,
      3,
      1,
      1.641064,
      NULL,
      7,
      1.699953,
      0,
      NULL,
      NULL,
      8.769043,
      6.446108,
      NULL,
      NULL,
      2,
      24.449590,
      3,
      2,
      1.222874,
      NULL,
      0,
      1,
      0.762838,
      1.042987,
      1,
      1,
      0.402027,
      1.072504,
      0.511906,
      1,
      NULL,
      4,
      6,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      3,
      0,
      0,
      0,
      2,
      5,
      6.815430,
      0,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      0.597517,
      NULL,
      NULL,
      5,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      0,
      1,
      1,
      3,
      0,
      3.784257,
      2,
      NULL,
      0,
      0,
      2,
      7.983475,
      2,
      0,
      2,
      0.690078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      2,
      3,
      NULL,
      0,
      0,
      2,
      4,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      0.589313,
      NULL,
      0,
      1,
      4,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      1,
      4,
      0,
      0,
      2,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4,
      NULL,
      1,
      0,
      1.075187,
      1,
      ' 6- 6-2000',
      NULL,
      ' 5-19-1980',
      NULL,
      0,
      0,
      1,
      1,
      4,
      4,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      3,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.749295,
      1,
      2.417985,
      6.427828,
      NULL,
      5.761936,
      1.161318,
      0,
      NULL,
      NULL,
      0,
      7.721631,
      0.580270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107456,
      3,
      0.212024,
      1.142680,
      1.766427,
      1,
      1,
      2,
      49.921845,
      1.247009,
      0.914910,
      NULL,
      NULL,
      NULL,
      3,
      1.725422,
      NULL,
      3,
      3,
      NULL,
      1,
      NULL,
      3,
      2,
      3,
      0,
      2,
      2,
      0,
      1.761897,
      0,
      0.169004,
      1.149700,
      0,
      0,
      0.747166,
      NULL,
      1.393255,
      0,
      0.271171,
      0,
      1,
      1,
      0,
      1,
      1.960074,
      6,
      5.534543,
      6.027387,
      0.367897,
      11.144079,
      0.872454,
      4.197556,
      1,
      NULL,
      2.794609,
      0,
      1,
      34.395766,
      0,
      NULL,
      NULL,
      64,
      62,
      NULL,
      4,
      1.725155,
      3.966110,
      '34104',
      '20334',
      '',
      1,
      '',
      '',
      '',
      0.241923,
      NULL,
      '',
      '',
      1.375884,
      NULL,
      NULL,
      38.309526,
      0.322919,
      NULL,
      0,
      NULL,
      4,
      2.194412,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370505,
      1.309575,
      1,
      3.068402,
      1.503179,
      1.067977,
      0.017216,
      NULL,
      NULL,
      0.169270,
      0,
      NULL,
      NULL,
      0,
      1.620471,
      1.812599,
      NULL,
      1,
      1.807623,
      NULL,
      NULL,
      3.218908,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.999835,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.084557,
      NULL,
      NULL,
      0,
      3.102842,
      1,
      NULL,
      1.465409,
      1,
      NULL,
      0.025204,
      2.466278,
      2.735939,
      1,
      0.764376,
      1.224042,
      1.006839,
      NULL,
      2,
      0.851251,
      NULL,
      NULL,
      0.323806,
      NULL,
      NULL,
      1,
      NULL,
      1,
      6.196578,
      NULL,
      0.910815,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.224068,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.500056,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.211771,
      0,
      0.109950,
      5.565779,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.018562,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.549070,
      0.273598,
      NULL,
      0,
      NULL,
      3.736490,
      0.840442,
      0.557546,
      2.256228,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.006154,
      3.162516,
      0,
      1,
      0,
      NULL,
      5.916871,
      4.399780,
      4,
      1.486112,
      2.167224,
      2.509957,
      2,
      0,
      0,
      3.093897,
      2,
      1.648586,
      NULL,
      1.157018,
      2,
      3,
      4,
      4,
      6.363839,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.747071,
      2,
      1.836388,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038627,
      NULL,
      NULL,
      1.996928,
      NULL,
      NULL,
      0.668737,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.763980,
      2.826351,
      2.384046,
      0.527152,
      1.469375,
      NULL,
      1,
      NULL,
      NULL,
      0.203021,
      2,
      NULL,
      NULL,
      NULL,
      4.009093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446860,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766446,
      1.799041,
      NULL,
      NULL,
      1.431707,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.700552,
      0.265986,
      NULL,
      NULL,
      1,
      0.887703,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.795381,
      NULL,
      NULL,
      2,
      3.751509,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.337858,
      2,
      NULL,
      NULL,
      12,
      2,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      1.742456,
      45.094693,
      5,
      2.277310,
      60,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679769,
      34,
      6.872436,
      0,
      NULL,
      NULL,
      0,
      11,
      3.597070,
      1.061376,
      NULL,
      0,
      0,
      NULL,
      0.987015,
      3,
      1.040538,
      NULL,
      NULL,
      3.142905,
      0,
      3.669716,
      0,
      1.360140,
      1,
      1,
      NULL,
      1.780110,
      0,
      NULL,
      NULL,
      0.417401,
      NULL,
      0,
      NULL,
      2.768864,
      NULL,
      1,
      NULL,
      0.311270,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.232422,
      40,
      NULL,
      1,
      2,
      0.994150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.609045,
      NULL,
      NULL,
      NULL,
      1.507004,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.038192,
      1.634398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531929,
      0.178286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3.380163,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.196683,
      NULL,
      0.445696,
      NULL,
      0.485395,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.696676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442800,
      1.592153,
      NULL,
      0,
      NULL,
      1.432123,
      NULL,
      NULL,
      NULL,
      0.602896,
      NULL,
      1.992281,
      NULL,
      0.303412,
      0.361104,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      4.814096,
      4.746696,
      0.684528,
      2,
      17,
      3,
      1,
      0,
      1,
      1.188875,
      0.639514,
      0.988575,
      0,
      1,
      0,
      NULL,
      2.969666,
      0.398965,
      NULL,
      1.130557,
      1.031953,
      NULL,
      2,
      1,
      NULL,
      1.120970,
      2.805705,
      3.237848,
      2.011380,
      2.794701,
      0,
      1,
      1,
      1,
      0,
      2.577308,
      NULL,
      2,
      1,
      0.959102,
      1.061304,
      0.816176,
      1.455062,
      2.351096,
      1.680965,
      1,
      NULL,
      3,
      NULL,
      1.022890,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.447612,
      NULL,
      1.472004,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.348270,
      NULL,
      0,
      NULL,
      NULL,
      72,
      1,
      1,
      0.274970,
      0,
      0,
      NULL,
      1.773034,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      3.348706,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.140086,
      NULL,
      1,
      19,
      1,
      NULL,
      NULL,
      0,
      0.910207,
      1,
      0.786987,
      0,
      NULL,
      5,
      4,
      1,
      1.945530,
      NULL,
      46.260256,
      NULL,
      2,
      1,
      4,
      '34214',
      '01012',
      '',
      1.138137,
      '',
      '',
      '',
      1.055316,
      NULL,
      '',
      '');
commit;
end;
/


