set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      1.884562,
      0.599214,
      6,
      1,
      '4013',
      0.464704,
      NULL,
      NULL,
      NULL,
      '10-15-1996',
      40.747836,
      NULL,
      0,
      3.010890,
      1.442865,
      '10- 6-1978',
      18.931507,
      1,
      NULL,
      NULL,
      0,
      ' 3-29-1975',
      NULL,
      ' 8- 5-2000',
      3.209750,
      0,
      NULL,
      0,
      0,
      0.884177,
      3,
      1.987896,
      1,
      0,
      7,
      12.427419,
      11.500790,
      17.007390,
      6,
      4,
      25,
      1,
      0,
      9,
      3.312694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      3,
      4,
      0,
      1,
      0,
      3,
      3,
      5,
      NULL,
      4,
      1,
      4,
      3,
      7.092820,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.784061,
      NULL,
      NULL,
      2,
      3,
      11.434025,
      NULL,
      0.782349,
      3,
      3.898399,
      3.241123,
      1.334986,
      0.954258,
      NULL,
      0,
      0,
      2,
      0,
      1,
      1.173319,
      3.937278,
      0.636879,
      3,
      0,
      0,
      2.941909,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      0.955564,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1.675579,
      NULL,
      0,
      0,
      NULL,
      1.607081,
      NULL,
      1.805189,
      NULL,
      2,
      3,
      1,
      0,
      2,
      3,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      4,
      1,
      5,
      NULL,
      3.800724,
      3,
      ' 5- 0-1990',
      NULL,
      ' 1- 1-1977',
      68,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.665457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.253108,
      NULL,
      NULL,
      5,
      0,
      0.486905,
      NULL,
      3.113727,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.932127,
      1.742876,
      0,
      NULL,
      NULL,
      2.082124,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.288837,
      1.071706,
      0.561428,
      1.533485,
      1.908469,
      1,
      2,
      122,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      3,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.555917,
      NULL,
      0,
      0,
      1.212782,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      2.522211,
      6.669528,
      NULL,
      9,
      NULL,
      NULL,
      0,
      2,
      0.709838,
      NULL,
      3.237368,
      2.783457,
      38,
      3,
      1.631480,
      NULL,
      37,
      9,
      NULL,
      5,
      1.833128,
      5,
      '40032',
      '44043',
      '',
      1.382061,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      3,
      0.228351,
      72.348730,
      33,
      NULL,
      NULL,
      3.021186,
      NULL,
      1,
      2.178448,
      NULL,
      3,
      1.759412,
      NULL,
      NULL,
      0.077148,
      NULL,
      NULL,
      2.602428,
      0,
      1,
      0,
      0,
      1.198887,
      3,
      0,
      3.705833,
      0,
      1.656283,
      0,
      8,
      NULL,
      NULL,
      0,
      0.095857,
      0.052348,
      1.944969,
      0.798177,
      1,
      2,
      0.704544,
      1,
      NULL,
      0.274825,
      1,
      5,
      6,
      1,
      0,
      1.235637,
      NULL,
      NULL,
      NULL,
      0.121525,
      NULL,
      NULL,
      NULL,
      2.668316,
      2,
      1.333632,
      NULL,
      1,
      NULL,
      3.312913,
      2,
      2.930684,
      2.069652,
      NULL,
      NULL,
      1,
      1,
      2.443526,
      NULL,
      3,
      NULL,
      3.386880,
      0,
      0,
      1,
      0.070543,
      0,
      0,
      NULL,
      2,
      3.340299,
      0,
      NULL,
      NULL,
      1,
      1.999487,
      0.416994,
      0.268824,
      NULL,
      NULL,
      1,
      1.634400,
      NULL,
      NULL,
      NULL,
      0.698514,
      NULL,
      NULL,
      NULL,
      0.433221,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      3,
      1.888461,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.932589,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.039322,
      NULL,
      NULL,
      1.542646,
      NULL,
      NULL,
      0.425262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      1.403780,
      NULL,
      NULL,
      1,
      NULL,
      7,
      0.923314,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2.482985,
      0.928975,
      NULL,
      2.043492,
      1,
      1,
      NULL,
      3.497210,
      1,
      NULL,
      4.790756,
      7.365594,
      0,
      0.294377,
      NULL,
      3.112866,
      1,
      NULL,
      2,
      3.850660,
      2.254534,
      2.512449,
      1,
      3,
      6,
      6.927850,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.138790,
      NULL,
      0,
      0.743790,
      1,
      1.832849,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678305,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.499889,
      NULL,
      NULL,
      1.744887,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.901532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.148479,
      NULL,
      NULL,
      1,
      NULL,
      0.331179,
      1.220287,
      1.416214,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.404725,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.172591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.741618,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.934269,
      NULL,
      NULL,
      NULL,
      0.925328,
      NULL,
      NULL,
      NULL,
      2.992883,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.106422,
      NULL,
      NULL,
      NULL,
      2.915405,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078162,
      3,
      5,
      0.808977,
      39,
      0,
      2.054047,
      0,
      0.369275,
      1.711467,
      NULL,
      NULL,
      1.818550,
      NULL,
      NULL,
      0.236736,
      NULL,
      NULL,
      0.237770,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981632,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      1.141081,
      0.253017,
      NULL,
      1.573591,
      1.000060,
      1.622549,
      0,
      1,
      0.314110,
      1.781359,
      0.790774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.041354,
      3.954197,
      7,
      0,
      0,
      7.958356,
      3.282176,
      3.062830,
      0,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0.067344,
      2.508752,
      NULL,
      1.037643,
      0,
      NULL,
      2,
      2.635427,
      NULL,
      0,
      0,
      NULL,
      0.498670,
      3,
      NULL,
      1.293470,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      3.991647,
      NULL,
      3,
      0.736917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405146,
      NULL,
      NULL,
      NULL,
      0.752680,
      NULL,
      0,
      4,
      4,
      2,
      0,
      1.867193,
      33.791270,
      41.264291,
      1,
      0,
      0,
      NULL,
      NULL,
      '',
      0.010320,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL);
commit;
end;
/


