set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9855678';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      2.491208,
      0.470087,
      1,
      2.657663,
      1.864337,
      3,
      1,
      '401',
      NULL,
      76,
      22,
      '3330121',
      2.308760,
      0,
      0,
      2,
      '4320',
      2,
      0.743816,
      NULL,
      NULL,
      ' 3- 7-2000',
      NULL,
      118,
      NULL,
      NULL,
      NULL,
      ' 2- 7-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 3-26-1997',
      3,
      3.325339,
      2,
      3.110733,
      0.003704,
      NULL,
      NULL,
      NULL,
      1,
      241.630435,
      7,
      12.753445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1.891991,
      NULL,
      1.062286,
      1.596565,
      1.145519,
      1.664087,
      1,
      2,
      4,
      3,
      3.050031,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      3,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0.047851,
      NULL,
      NULL,
      1,
      4,
      0.769362,
      1.715564,
      1.395521,
      0,
      2,
      2.055484,
      1.902791,
      0.021892,
      NULL,
      NULL,
      0,
      3,
      0.823938,
      1,
      3,
      0.794444,
      0.746571,
      0,
      0,
      0,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      4,
      3,
      NULL,
      3,
      1,
      1,
      3,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      4,
      0,
      NULL,
      NULL,
      4,
      2,
      0,
      1,
      1,
      0,
      3,
      NULL,
      0,
      1,
      5,
      5,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      5,
      2.980462,
      NULL,
      815,
      ' 3-23-1988',
      NULL,
      0.485617,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      7,
      7.605196,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403128,
      2,
      0,
      0.357564,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.942844,
      2,
      3,
      NULL,
      2,
      2,
      1,
      2,
      3,
      NULL,
      1,
      2,
      5,
      3,
      2.954356,
      NULL,
      1.894087,
      1.624462,
      0.548427,
      0.007235,
      1,
      0,
      1.402735,
      NULL,
      1,
      1.347923,
      0,
      3.446337,
      1,
      0,
      2,
      6.693110,
      NULL,
      4,
      8.016690,
      4,
      5.431679,
      3,
      NULL,
      3,
      0.161360,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      66,
      NULL,
      0,
      3,
      3.118451,
      '00343',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      3.750454,
      23.391026,
      369,
      NULL,
      3.965837,
      25,
      NULL,
      7,
      1,
      NULL,
      3.918999,
      3,
      1.557298,
      NULL,
      NULL,
      0.053195,
      NULL,
      NULL,
      0.532961,
      0.419358,
      NULL,
      NULL,
      NULL,
      NULL,
      2.885730,
      1,
      1,
      0,
      0.049601,
      0,
      0,
      NULL,
      1.228212,
      1.161504,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.943939,
      5.720199,
      9,
      0,
      0.607732,
      NULL,
      NULL,
      NULL,
      1.416783,
      NULL,
      NULL,
      NULL,
      1,
      0.419131,
      NULL,
      1,
      0.567403,
      0.895847,
      3,
      1,
      1.260377,
      3.831867,
      NULL,
      1,
      2,
      0.884448,
      1,
      0,
      0,
      0,
      0.459227,
      1,
      NULL,
      0.994225,
      1,
      1,
      1,
      3.585907,
      1.325766,
      0,
      NULL,
      NULL,
      NULL,
      3.527692,
      1,
      0,
      0.801473,
      1.878992,
      4.047277,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638488,
      NULL,
      NULL,
      0.292648,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.007464,
      0.379305,
      0.912743,
      0.008364,
      0,
      0,
      1,
      0.402191,
      0.290179,
      NULL,
      NULL,
      2,
      0.722338,
      5.039656,
      0.027154,
      NULL,
      NULL,
      0.737107,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698424,
      1.887029,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.883452,
      0,
      1.684162,
      NULL,
      NULL,
      2,
      NULL,
      2,
      2,
      7,
      2.147838,
      NULL,
      2.293485,
      0.330282,
      NULL,
      3.991942,
      2,
      0.092485,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      3,
      2.402662,
      NULL,
      5.346143,
      3,
      4.182877,
      2,
      0,
      0,
      1.332300,
      1.588566,
      0.291282,
      1,
      1.423963,
      3.208141,
      NULL,
      NULL,
      1.482767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850762,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.649715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.933098,
      NULL,
      NULL,
      0.011699,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.492659,
      2.047605,
      0.166006,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.429904,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.898851,
      NULL,
      NULL,
      NULL,
      6.401482,
      NULL,
      NULL,
      NULL,
      1.913350,
      NULL,
      NULL,
      NULL,
      NULL,
      161.898599,
      NULL,
      3.093191,
      NULL,
      0.390815,
      NULL,
      NULL,
      NULL,
      3.510635,
      NULL,
      21,
      0,
      NULL,
      NULL,
      0.491054,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279468,
      NULL,
      0.045783,
      0,
      NULL,
      1.122191,
      NULL,
      1.548477,
      0,
      1.610600,
      1.982145,
      0.894677,
      1.193190,
      NULL,
      1,
      1,
      1,
      0,
      1.277954,
      0.790271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.946809,
      0.940184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176800,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.557750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.484494,
      NULL,
      1.976492,
      NULL,
      0.355470,
      NULL,
      NULL,
      NULL,
      0.701878,
      NULL,
      0.749366,
      NULL,
      1.632665,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      NULL,
      4.068017,
      NULL,
      0.837027,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.821542,
      0,
      NULL,
      3,
      1.981503,
      NULL,
      NULL,
      3,
      NULL,
      0.791504,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      2.106987,
      NULL,
      3.200987,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.178279,
      0.716158,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.591492,
      NULL,
      2,
      1,
      0.734864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.694760,
      NULL,
      2,
      2,
      4,
      0.619463,
      NULL,
      NULL,
      55.528211,
      32,
      1,
      1.049010,
      2,
      '00210',
      '',
      '',
      0.051551,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


