set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7925101';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00',
      '22',
      10.470163,
      36,
      NULL,
      2.605263,
      0,
      2,
      3,
      '1140',
      2,
      1,
      NULL,
      NULL,
      ' 0- 5-1996',
      0,
      29,
      NULL,
      0,
      1.277665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 3- 8-1982',
      '11-22-1990',
      NULL,
      2.730243,
      2.352868,
      0,
      NULL,
      3,
      3.163287,
      2,
      2,
      NULL,
      NULL,
      NULL,
      13.626971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      0,
      1,
      1.515305,
      1,
      1,
      1.227232,
      1.016580,
      1.412530,
      4,
      0.722389,
      4,
      4,
      2,
      0.252524,
      2,
      NULL,
      2,
      1,
      1,
      NULL,
      1,
      0,
      5,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0.443543,
      NULL,
      NULL,
      5,
      5,
      0,
      1,
      0.226646,
      0.607823,
      1,
      2,
      1.454011,
      NULL,
      1,
      2,
      2.396416,
      3,
      0.395960,
      0.256165,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      8.336944,
      1,
      0,
      0.286121,
      0.219365,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      2,
      4,
      NULL,
      3,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      4,
      0,
      2,
      0,
      2,
      5,
      2,
      3,
      0,
      5,
      3,
      3,
      1,
      0,
      0,
      3,
      NULL,
      3,
      2,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.641338,
      2,
      ' 0-14-1995',
      142,
      ' 5-26-1977',
      34.342750,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      0.943483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.753095,
      0,
      4.577890,
      0.103256,
      NULL,
      1.816469,
      3.814984,
      NULL,
      NULL,
      NULL,
      0.468119,
      0.228502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323054,
      3.025075,
      0.266709,
      0.181262,
      NULL,
      1,
      1,
      2.528178,
      140,
      3.348909,
      1.577744,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      2,
      NULL,
      2,
      3,
      1,
      3,
      0,
      2,
      2,
      1.605829,
      0,
      0.495667,
      0,
      0,
      0,
      0,
      0.829955,
      0,
      1.287462,
      1.626648,
      1,
      1,
      1,
      1,
      1,
      1.016163,
      0,
      NULL,
      NULL,
      0,
      3.139677,
      2.814439,
      NULL,
      2,
      2.230147,
      3.658052,
      5,
      2,
      1.909668,
      1,
      43.855782,
      2,
      2,
      44,
      NULL,
      NULL,
      NULL,
      0,
      4.546787,
      1,
      '22300',
      '',
      '',
      0.235135,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      28.544558,
      23,
      27,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.880085,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.045963,
      1.005853,
      1,
      0.178476,
      NULL,
      NULL,
      0.983191,
      2.650130,
      3,
      NULL,
      1,
      2.338718,
      0.653811,
      NULL,
      NULL,
      0,
      3.127388,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.134069,
      NULL,
      NULL,
      7,
      7.146597,
      4,
      0,
      1.315726,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026646,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      1,
      3.039038,
      3.834136,
      0.682960,
      NULL,
      1.885585,
      2,
      0.633041,
      2.430234,
      NULL,
      2.683679,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.503644,
      NULL,
      NULL,
      6.495182,
      7,
      1.878879,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.646652,
      NULL,
      NULL,
      0.435033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389968,
      NULL,
      NULL,
      3,
      3.622362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.677710,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.346099,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      0.440562,
      0,
      4,
      5,
      NULL,
      0.624585,
      2.333006,
      5.116138,
      5.478682,
      2,
      0,
      1.967345,
      1.737940,
      NULL,
      3.350983,
      1.949181,
      0.961164,
      0,
      0.870390,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      1,
      0,
      3,
      2.785085,
      NULL,
      1.260004,
      3.228570,
      2,
      1,
      2,
      5,
      3,
      7.204585,
      NULL,
      0.668955,
      NULL,
      2,
      3,
      1.824044,
      1.335938,
      1.608664,
      1.169970,
      0,
      3,
      NULL,
      NULL,
      0.303958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909949,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.071710,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.470971,
      NULL,
      1.566598,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.044977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993797,
      NULL,
      NULL,
      NULL,
      2.573266,
      NULL,
      NULL,
      NULL,
      0.521454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.642312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.659967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.395041,
      0,
      3.141665,
      1.032733,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.210206,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.299391,
      NULL,
      0.314942,
      NULL,
      0,
      1,
      0.912648,
      0,
      NULL,
      1.729335,
      0.523283,
      0.364247,
      1.838437,
      1,
      0.686214,
      0.758244,
      0,
      1,
      0,
      1.128424,
      NULL,
      1.719118,
      0.671574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      4,
      3,
      2,
      2,
      NULL,
      NULL,
      1.167677,
      NULL,
      0.608526,
      0,
      NULL,
      0.293715,
      0,
      NULL,
      1.690831,
      0.412628,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795953,
      NULL,
      NULL,
      1.371291,
      NULL,
      NULL,
      0,
      1.686482,
      NULL,
      1,
      0,
      NULL,
      1.292933,
      0,
      NULL,
      0.567348,
      3,
      NULL,
      0,
      NULL,
      NULL,
      2.697348,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.017154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158708,
      NULL,
      0.522330,
      NULL,
      0,
      NULL,
      4,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      47,
      107,
      3,
      1,
      1,
      '12142',
      '',
      '',
      0.606155,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


