set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      3,
      0.142728,
      1,
      3,
      '0202',
      1.910546,
      NULL,
      3.358968,
      38,
      ' 2-14-2001',
      56.347764,
      NULL,
      1,
      2,
      NULL,
      ' 8-24-1993',
      36.003590,
      3.757916,
      76.878173,
      2.322528,
      2,
      '10- 1-1993',
      '10- 7-1994',
      ' 3- 5-2001',
      3.345389,
      1.306079,
      NULL,
      0.177957,
      0,
      0.181367,
      5,
      1,
      1.396011,
      5,
      5,
      NULL,
      4.070853,
      11,
      11.862905,
      NULL,
      18.989309,
      1,
      0,
      2.286615,
      0.163397,
      NULL,
      0,
      1,
      3,
      1.360425,
      NULL,
      NULL,
      1,
      0.936456,
      0.630971,
      1,
      2,
      1,
      0.909281,
      NULL,
      3,
      1,
      NULL,
      2,
      4,
      4,
      NULL,
      5,
      4,
      1,
      2,
      NULL,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.073985,
      2,
      NULL,
      0,
      0,
      NULL,
      1.214491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      0,
      0,
      0.504419,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      0,
      0,
      0,
      4.877687,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      5,
      4,
      4,
      5,
      5,
      1,
      1,
      3,
      3,
      3,
      3,
      1,
      1,
      3,
      0,
      3,
      4,
      2,
      5,
      3,
      5,
      0.226874,
      NULL,
      NULL,
      NULL,
      '10- 7-1990',
      38.945745,
      1,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98.450762,
      3.531870,
      NULL,
      3,
      1,
      1,
      1.001337,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.792720,
      8.716599,
      NULL,
      3.897317,
      1,
      NULL,
      NULL,
      NULL,
      2,
      6,
      2,
      2,
      5,
      0,
      0,
      ' 0- 0-1983',
      70,
      ' 3- 7-1985',
      49,
      0.992451,
      0,
      1.110536,
      0,
      1,
      0,
      1.541942,
      0.072031,
      1.891788,
      0.650012,
      3,
      21,
      0.336041,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.513324,
      NULL,
      NULL,
      2,
      3,
      3,
      0,
      1,
      0,
      1,
      2,
      2,
      0.965866,
      3.086315,
      NULL,
      0,
      NULL,
      0,
      2,
      1.887368,
      0.238982,
      0,
      1,
      0.704129,
      4.407012,
      1,
      1.664292,
      3,
      2.964281,
      3.956157,
      1.099209,
      NULL,
      3,
      NULL,
      NULL,
      7.349324,
      2,
      0.803214,
      2,
      7,
      0.903223,
      NULL,
      0.370674,
      14.685198,
      1,
      0,
      NULL,
      21,
      34,
      56.545813,
      0,
      1.039114,
      NULL,
      '20443',
      '',
      '',
      0.806466,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      147.701447,
      1,
      0,
      NULL,
      4,
      3,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962527,
      NULL,
      NULL,
      3.432493,
      NULL,
      1.188629,
      1.080234,
      0.143286,
      1.352176,
      1,
      NULL,
      NULL,
      3,
      1.961663,
      NULL,
      0.964267,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      2.258663,
      4,
      1,
      1,
      1.291992,
      NULL,
      NULL,
      NULL,
      0.440605,
      1,
      3,
      0,
      0,
      NULL,
      NULL,
      0.592193,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.428232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.731541,
      NULL,
      NULL,
      0.721390,
      NULL,
      NULL,
      0.442886,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.815756,
      NULL,
      NULL,
      1.590751,
      NULL,
      NULL,
      0.901700,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.495301,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.023594,
      NULL,
      NULL,
      2,
      0.340928,
      1.948290,
      NULL,
      1.254876,
      0.194668,
      NULL,
      NULL,
      0,
      7,
      1.978736,
      1.389596,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.400373,
      NULL,
      0,
      3,
      1.441058,
      1.194091,
      6,
      1.251921,
      1,
      1,
      NULL,
      NULL,
      0.918988,
      1,
      0,
      1,
      NULL,
      NULL,
      3.039043,
      NULL,
      1,
      8,
      3.506077,
      7.091529,
      NULL,
      NULL,
      0.899189,
      2,
      1,
      0,
      1,
      1,
      1.498789,
      NULL,
      NULL,
      3.145589,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264232,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.119888,
      NULL,
      NULL,
      1.335535,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3.535511,
      NULL,
      2,
      NULL,
      1.988059,
      NULL,
      5.346057,
      NULL,
      0.839534,
      NULL,
      4.884624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115153,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.786270,
      NULL,
      1.664280,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.064547,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.107389,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.306912,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.411775,
      NULL,
      3.648935,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.266324,
      NULL,
      2,
      NULL,
      0.627891,
      NULL,
      1,
      NULL,
      1,
      NULL,
      5,
      NULL,
      3,
      NULL,
      1,
      0.626689,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826214,
      0,
      0,
      NULL,
      NULL,
      1.591934,
      NULL,
      NULL,
      1,
      0,
      1.933721,
      1.015680,
      NULL,
      NULL,
      0.732950,
      NULL,
      NULL,
      0,
      NULL,
      0.084585,
      4,
      9.118018,
      NULL,
      1.576911,
      1,
      0.147985,
      NULL,
      NULL,
      1.110673,
      1,
      0.039391,
      NULL,
      1.632263,
      NULL,
      1.356142,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      5,
      NULL,
      5.127334,
      NULL,
      3,
      6.281357,
      3,
      0,
      0,
      NULL,
      0,
      1.734071,
      1.060663,
      3,
      1.668064,
      NULL,
      2.896052,
      NULL,
      NULL,
      0,
      1,
      1.743552,
      0,
      1,
      0,
      NULL,
      1,
      1,
      3,
      0.002782,
      0.664890,
      1,
      3.861949,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.912490,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.713605,
      3,
      9,
      0.545101,
      1,
      3.457489,
      1.015042,
      1.034683,
      0.455410,
      1,
      NULL,
      0.508043,
      1.658597,
      2.537021,
      0,
      1.451650,
      1.880243,
      1.744646,
      NULL,
      1.831885,
      0.310778,
      0.120116,
      3,
      NULL,
      0.192608,
      1,
      5.230700,
      2.071459,
      NULL,
      0,
      0.118503,
      0,
      0,
      0.418184,
      1.924757,
      0,
      2,
      6,
      3,
      0,
      0,
      1.350695,
      72,
      5,
      1.754763,
      3,
      '44010',
      '',
      '',
      1.375207,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


