set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '4212301',
      NULL,
      1.858808,
      NULL,
      3,
      '0330',
      0,
      NULL,
      2.186968,
      42,
      ' 0- 4-1984',
      3.964748,
      NULL,
      3,
      NULL,
      1.133769,
      ' 8-17-2002',
      48.226392,
      1,
      117,
      16,
      2,
      NULL,
      ' 6- 9-1985',
      ' 6-13-1996',
      3,
      0.980052,
      2.061332,
      2.325070,
      0,
      3,
      NULL,
      0.733204,
      1.053214,
      2,
      6,
      11,
      9,
      NULL,
      14.281323,
      1,
      4.113819,
      3,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.922624,
      0.368906,
      0.958238,
      1.810635,
      NULL,
      4,
      3,
      1,
      0,
      4,
      NULL,
      1,
      NULL,
      0,
      5,
      4,
      NULL,
      5,
      2,
      NULL,
      1,
      11,
      1,
      NULL,
      2,
      1,
      1.770798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.539222,
      0.454890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.105413,
      NULL,
      2,
      0.315597,
      0,
      NULL,
      NULL,
      1.794145,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      4,
      2,
      2,
      1,
      NULL,
      4,
      1.850428,
      6,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      5,
      0,
      3,
      NULL,
      0,
      1,
      2,
      1,
      4,
      2,
      2,
      NULL,
      NULL,
      4,
      NULL,
      0,
      5,
      NULL,
      0,
      2.553227,
      1.437052,
      ' 7-28-1994',
      193,
      NULL,
      52.173533,
      0.473587,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      44,
      NULL,
      NULL,
      1,
      NULL,
      1.247037,
      1.516843,
      3,
      4,
      2,
      0.000037,
      1.771830,
      0.400855,
      3,
      0.793820,
      NULL,
      NULL,
      6.038980,
      7,
      3.351066,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      10.409327,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.216161,
      1,
      0,
      1,
      1,
      NULL,
      0,
      2.852078,
      30.153089,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      0,
      2,
      2,
      0,
      1,
      1,
      3,
      1,
      0,
      0,
      0.036263,
      NULL,
      0.918340,
      0,
      NULL,
      0.676728,
      0.935123,
      2,
      0,
      0.400185,
      1,
      1.371824,
      3.857493,
      0.897630,
      NULL,
      NULL,
      3,
      3.049511,
      0,
      7,
      5.346046,
      2,
      6,
      0.538161,
      1,
      NULL,
      52,
      1,
      0,
      NULL,
      8,
      41,
      5.231482,
      4,
      0.974970,
      3,
      '14240',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1.080489,
      0.757701,
      32,
      NULL,
      1,
      3.751178,
      4.820726,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208556,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.563252,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.812157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.812625,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.729860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.320216,
      3.293320,
      0.282622,
      1.242883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620373,
      NULL,
      NULL,
      0.088502,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      2.262534,
      0.293550,
      1,
      2.289887,
      1.831464,
      0.922784,
      6,
      1.654296,
      0.844022,
      NULL,
      NULL,
      NULL,
      0.139987,
      NULL,
      NULL,
      0,
      0,
      3.176549,
      2.528040,
      1,
      0,
      NULL,
      0,
      4.008254,
      2,
      NULL,
      NULL,
      0,
      0,
      0.569225,
      0,
      NULL,
      NULL,
      1,
      3.274269,
      NULL,
      2,
      NULL,
      8,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.904034,
      0,
      0.835588,
      NULL,
      1,
      1.704290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.123506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274987,
      1,
      3.163773,
      1,
      NULL,
      NULL,
      0.843311,
      NULL,
      NULL,
      0.835049,
      3,
      2,
      0.410972,
      NULL,
      NULL,
      1.986747,
      NULL,
      NULL,
      1.134855,
      NULL,
      1.743427,
      13,
      7,
      NULL,
      0,
      1,
      1.925228,
      NULL,
      0.570111,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0.855114,
      NULL,
      1.794547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0.108180,
      0,
      3,
      4,
      1,
      12,
      3.198492,
      3,
      0.957935,
      1,
      1.287785,
      NULL,
      0.676606,
      2.226132,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.411402,
      0.339042,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.966905,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.281752,
      NULL,
      0.206442,
      0.656682,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154943,
      NULL,
      0.222931,
      NULL,
      0,
      NULL,
      2,
      2,
      0,
      NULL,
      1,
      0.938996,
      45.882947,
      81,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      '40414',
      '',
      NULL,
      0.527107,
      '',
      '',
      NULL);
commit;
end;
/


