set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '4212214',
      1,
      1,
      NULL,
      0,
      '3021',
      1,
      NULL,
      NULL,
      NULL,
      ' 3-20-1995',
      53,
      NULL,
      NULL,
      0,
      0,
      '10-28-1982',
      16,
      0.289106,
      35.431678,
      61,
      1,
      '10-19-1986',
      ' 7-13-1978',
      ' 4-17-1988',
      NULL,
      NULL,
      1.578999,
      1.416622,
      1.691999,
      3,
      5,
      0,
      0,
      39.407881,
      4,
      16,
      6.803427,
      1.353914,
      NULL,
      1,
      7.939070,
      5,
      3,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      7,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      2,
      5,
      1,
      0,
      5,
      1,
      8,
      0,
      1,
      1,
      NULL,
      1.229293,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0.770144,
      NULL,
      2,
      0.196779,
      NULL,
      NULL,
      NULL,
      3.323605,
      0,
      1,
      NULL,
      5,
      0,
      NULL,
      3,
      1,
      3,
      1,
      2,
      2,
      0,
      NULL,
      1,
      3.192883,
      0,
      NULL,
      1,
      0,
      2.406225,
      NULL,
      1,
      0,
      1,
      NULL,
      2,
      NULL,
      5,
      0,
      1,
      NULL,
      5,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      4,
      2,
      0,
      4,
      NULL,
      3,
      1,
      4,
      4,
      3.540060,
      1.170124,
      ' 0-26-1991',
      224.962731,
      ' 0- 8-1996',
      10,
      1.349125,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1.006802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      14.480246,
      0,
      3.167759,
      3,
      0,
      1.612248,
      0.981357,
      1,
      2,
      3,
      1.786188,
      0,
      3.221886,
      2.356961,
      NULL,
      0.251732,
      9.978589,
      NULL,
      1.216528,
      7.083299,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      '10- 0-2003',
      210,
      NULL,
      6,
      0.100807,
      NULL,
      1,
      1.959539,
      1,
      0,
      1.763974,
      NULL,
      0.299213,
      0,
      1.404395,
      52.387993,
      1,
      1.762624,
      NULL,
      NULL,
      NULL,
      0,
      1.676143,
      3.710670,
      0,
      0,
      0,
      3,
      NULL,
      3,
      2,
      3,
      3,
      2,
      2.616818,
      2,
      0.124887,
      1.494286,
      0,
      NULL,
      4.363921,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0.797901,
      1,
      3,
      2.749669,
      2,
      1.583501,
      NULL,
      9.735099,
      0.116452,
      6.495875,
      3,
      1.961581,
      4,
      3.680376,
      1,
      2,
      2.535762,
      3.333622,
      39,
      0,
      NULL,
      NULL,
      NULL,
      40,
      28.239691,
      1,
      0.094885,
      3.184187,
      '21422',
      '',
      '',
      0,
      '',
      '',
      '',
      1.199022,
      '',
      '',
      '',
      0.817815,
      11.699158,
      207.109319,
      24.189824,
      NULL,
      33.362871,
      0,
      NULL,
      4,
      3.596596,
      1,
      0,
      1.280284,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.843644,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.800451,
      0.758060,
      0.450018,
      NULL,
      NULL,
      0,
      1,
      0.264479,
      1.894644,
      0.565473,
      NULL,
      NULL,
      NULL,
      1.550516,
      3,
      0.379248,
      1,
      1.149404,
      1.524358,
      0.236425,
      3.774147,
      0,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.840670,
      NULL,
      NULL,
      1.382526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.990166,
      1.026616,
      0.644915,
      1.386246,
      NULL,
      NULL,
      1.117311,
      NULL,
      NULL,
      5,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      0.666360,
      1,
      NULL,
      NULL,
      1.644012,
      NULL,
      NULL,
      3.032236,
      NULL,
      NULL,
      1,
      3,
      1.554275,
      0.852222,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.500961,
      1.734296,
      2,
      1.151897,
      1,
      0,
      3.925717,
      0.259204,
      NULL,
      5,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.349625,
      NULL,
      1,
      3,
      8,
      3,
      1,
      3.143010,
      1,
      0.856544,
      0,
      3.026805,
      1.010848,
      NULL,
      1.897187,
      0.336555,
      NULL,
      0,
      0.791586,
      7.075508,
      5.581749,
      NULL,
      NULL,
      0,
      3.045767,
      0.526875,
      1,
      0,
      NULL,
      0.688546,
      1,
      NULL,
      0,
      2.506633,
      NULL,
      NULL,
      0.978552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.079391,
      0.651317,
      0,
      NULL,
      1.958701,
      0,
      NULL,
      NULL,
      3.190251,
      2,
      NULL,
      NULL,
      152,
      0.809671,
      NULL,
      NULL,
      3.033492,
      3.392542,
      NULL,
      NULL,
      2,
      1.638642,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      3.421380,
      NULL,
      NULL,
      0.998187,
      1,
      NULL,
      NULL,
      2.994100,
      NULL,
      NULL,
      NULL,
      0.633039,
      0,
      NULL,
      NULL,
      1,
      2.442521,
      NULL,
      NULL,
      0.332783,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      2.118288,
      NULL,
      NULL,
      NULL,
      2.026451,
      NULL,
      NULL,
      1.401953,
      1,
      NULL,
      NULL,
      1,
      0.664715,
      NULL,
      NULL,
      9.127553,
      NULL,
      NULL,
      NULL,
      1.257387,
      NULL,
      NULL,
      NULL,
      NULL,
      7.283083,
      17.070763,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.431495,
      3,
      2.306763,
      0,
      NULL,
      NULL,
      0.885589,
      NULL,
      NULL,
      0,
      NULL,
      0.059685,
      3,
      NULL,
      NULL,
      0.662732,
      0,
      1.748595,
      1.550715,
      0.931069,
      0.261089,
      0,
      0,
      0.671240,
      1.876729,
      NULL,
      0,
      0.724027,
      1,
      0,
      NULL,
      1.739818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      4.287472,
      5.762918,
      3,
      5,
      NULL,
      1,
      NULL,
      1.887716,
      NULL,
      1.826984,
      1.444185,
      NULL,
      NULL,
      3.248054,
      1.885055,
      NULL,
      1,
      1,
      0,
      NULL,
      1.551337,
      1,
      1,
      1.597192,
      1.525073,
      NULL,
      1,
      0.880257,
      2,
      2.975098,
      0.340033,
      NULL,
      1.529228,
      1,
      1,
      0.680778,
      0.825976,
      NULL,
      1.953279,
      0.726692,
      3,
      3.380483,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668925,
      1.011114,
      0,
      NULL,
      3.039041,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.904955,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.888362,
      NULL,
      0.416512,
      NULL,
      1,
      NULL,
      0,
      17.229436,
      2.588807,
      NULL,
      1,
      NULL,
      0,
      2,
      0.702067,
      0,
      0,
      NULL,
      5,
      1.824223,
      0.849078,
      3.304605,
      65.392833,
      23,
      NULL,
      1,
      NULL,
      '14310',
      '02434',
      '',
      NULL,
      '00214',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


