set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7616534';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      '4240',
      1.450931,
      NULL,
      NULL,
      NULL,
      '10-22-1988',
      NULL,
      NULL,
      3,
      1.628372,
      1.126370,
      NULL,
      36,
      2,
      NULL,
      74,
      2,
      NULL,
      NULL,
      ' 9- 3-2000',
      0,
      2.391315,
      1,
      NULL,
      1,
      0.356658,
      0,
      2,
      NULL,
      NULL,
      NULL,
      5,
      3,
      5,
      17.747256,
      NULL,
      8.262572,
      0,
      NULL,
      NULL,
      1.722788,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1.331083,
      1.811138,
      5,
      1.960256,
      2,
      NULL,
      5,
      0.045748,
      5,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.042317,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      0.212116,
      0.928842,
      NULL,
      NULL,
      1.306073,
      2.395494,
      0,
      NULL,
      NULL,
      0.190078,
      1,
      1.956222,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.453012,
      0,
      1,
      1,
      0.304953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      4,
      0,
      1,
      1,
      3,
      0,
      NULL,
      1,
      4,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      4,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      ' 9-25-1993',
      10,
      ' 4- 2-1980',
      NULL,
      0.659956,
      NULL,
      2,
      1,
      4,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      0,
      0,
      1,
      1,
      4,
      4,
      NULL,
      2.569072,
      NULL,
      1.897987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.630528,
      0.269898,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421547,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.266908,
      NULL,
      1,
      NULL,
      0.047862,
      1.947415,
      1.443760,
      1,
      NULL,
      3.863857,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      1,
      3,
      NULL,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.984663,
      NULL,
      0.505915,
      1,
      1,
      NULL,
      0,
      1.950525,
      0,
      NULL,
      0.677927,
      0,
      0.988417,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2.899388,
      0.662054,
      3,
      2.234130,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      56,
      NULL,
      NULL,
      NULL,
      0,
      4,
      5,
      '03414',
      '04214',
      '',
      0,
      '1243',
      NULL,
      NULL,
      1.952254,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.704182,
      NULL,
      1.841167,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      135.401939,
      6.708260,
      1,
      0.136311,
      NULL,
      NULL,
      0.487108,
      0,
      1.840289,
      1,
      1.642726,
      1.718645,
      1.094803,
      0.292807,
      1.925206,
      0.761145,
      0,
      1.267891,
      3.472296,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.712675,
      NULL,
      35.274400,
      NULL,
      2.450945,
      NULL,
      20,
      NULL,
      1.559428,
      0,
      1.718609,
      1.710658,
      NULL,
      NULL,
      NULL,
      1.007841,
      NULL,
      1.312301,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.300212,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.810716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.196737,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.818925,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519738,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.842628,
      NULL,
      NULL,
      NULL,
      1.974952,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.983126,
      NULL,
      1,
      NULL,
      0.607163,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.947673,
      1,
      3,
      NULL,
      1.708664,
      NULL,
      NULL,
      NULL,
      0.995670,
      NULL,
      0.930520,
      NULL,
      1,
      NULL,
      2.395135,
      NULL,
      578,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      17.296009,
      NULL,
      NULL,
      0,
      NULL,
      3.346738,
      0,
      NULL,
      0,
      0,
      0.897927,
      1.957539,
      NULL,
      0,
      6.080795,
      2.242574,
      NULL,
      2,
      NULL,
      1,
      1,
      1.505256,
      1.309552,
      0,
      NULL,
      3,
      1,
      0,
      NULL,
      1.322712,
      1,
      1.719321,
      1.743127,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.000313,
      0.407844,
      0.131192,
      0.141010,
      1.207508,
      NULL,
      NULL,
      1,
      0.707569,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.910090,
      1,
      0.640456,
      NULL,
      NULL,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      76.342678,
      3,
      5.944216,
      5,
      '30244',
      '44031',
      '',
      NULL,
      '3344',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '');
commit;
end;
/


