set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6228275';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      '12',
      19.066165,
      26.306419,
      '1002321',
      3.974580,
      1,
      1,
      NULL,
      '1443',
      3,
      0,
      NULL,
      NULL,
      ' 8- 5-1977',
      27,
      31,
      NULL,
      1,
      0.370046,
      ' 4-25-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '10-16-1975',
      3,
      0,
      0.568815,
      3,
      3,
      3.302282,
      4,
      NULL,
      NULL,
      NULL,
      2,
      15.935545,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      1,
      0,
      0.104350,
      0,
      0,
      1.883118,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      3,
      1,
      0,
      2,
      NULL,
      4,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0.521679,
      1.670280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.187834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      2,
      2,
      5,
      0,
      NULL,
      1,
      1,
      0,
      1,
      2.531827,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      5,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      2,
      NULL,
      0,
      1.770282,
      3,
      '10-19-2000',
      1579.029083,
      ' 1-21-1987',
      2073.635551,
      0.478431,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      5,
      NULL,
      1,
      0,
      0.089322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.169208,
      NULL,
      1.442164,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.433844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.675496,
      NULL,
      1.127101,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.247835,
      2,
      2,
      2,
      3,
      1,
      2,
      2,
      NULL,
      1,
      NULL,
      2,
      0.991222,
      1,
      5.658612,
      1.103412,
      0.972569,
      2.977810,
      1,
      1,
      1,
      3,
      1,
      0,
      NULL,
      1.026987,
      1,
      0.265776,
      1.734074,
      1.996842,
      8,
      6.075790,
      NULL,
      5.014336,
      5,
      5.457719,
      NULL,
      NULL,
      3.104886,
      3.969897,
      NULL,
      1,
      43,
      3,
      0,
      86,
      NULL,
      NULL,
      NULL,
      3,
      2.825266,
      3.071017,
      '44211',
      NULL,
      '',
      1.306887,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      NULL,
      33,
      402,
      65,
      1.843311,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464288,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.988905,
      0.516812,
      NULL,
      NULL,
      0.248087,
      0,
      2,
      0.190601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.620171,
      NULL,
      NULL,
      0.800180,
      NULL,
      NULL,
      7,
      NULL,
      5.051935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.570167,
      NULL,
      NULL,
      1.563960,
      NULL,
      NULL,
      1.519865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267128,
      NULL,
      NULL,
      0.400677,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.905219,
      0,
      1.913929,
      NULL,
      0.694102,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.939158,
      NULL,
      NULL,
      0,
      2.827470,
      1.830198,
      0.018923,
      0,
      NULL,
      1.681869,
      NULL,
      NULL,
      5.970505,
      NULL,
      5.915135,
      NULL,
      3,
      1.114168,
      1,
      3.617129,
      1.427701,
      NULL,
      0,
      7.904361,
      1.965715,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.906522,
      NULL,
      NULL,
      1.759567,
      NULL,
      NULL,
      0.386377,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.998645,
      0,
      1.012819,
      1.849261,
      1.116707,
      1.073523,
      2,
      1,
      1,
      1.323392,
      NULL,
      NULL,
      0.624770,
      7,
      3,
      3.776691,
      3.211054,
      1.841021,
      0,
      NULL,
      NULL,
      NULL,
      3.712040,
      1,
      0,
      2.400614,
      NULL,
      NULL,
      NULL,
      NULL,
      0.729138,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      1,
      1.882539,
      0,
      0,
      1,
      NULL,
      NULL,
      0.752090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536596,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.048242,
      NULL,
      NULL,
      1.973114,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.267862,
      NULL,
      NULL,
      1.519042,
      NULL,
      NULL,
      1,
      0,
      1,
      1.558392,
      1,
      0.920078,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.163746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.213535,
      NULL,
      NULL,
      NULL,
      3.461913,
      NULL,
      NULL,
      NULL,
      0.622122,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.049434,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      146,
      34637.758735,
      1.079504,
      NULL,
      NULL,
      0.859533,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.780166,
      NULL,
      NULL,
      1.904325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098716,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0.867512,
      0,
      0,
      0.622324,
      1.231650,
      0.821358,
      1.032233,
      NULL,
      NULL,
      0.105975,
      1.053626,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.809479,
      1,
      1,
      0.011929,
      NULL,
      2,
      3,
      1.925777,
      NULL,
      NULL,
      1,
      NULL,
      0.428071,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1.737706,
      NULL,
      1,
      0,
      NULL,
      0.383987,
      0.689286,
      NULL,
      1.819011,
      0.369559,
      NULL,
      1.133788,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.528397,
      0.458504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.231567,
      NULL,
      0.971922,
      NULL,
      NULL,
      2,
      3,
      3.946481,
      NULL,
      2,
      83,
      33.171360,
      NULL,
      0.985469,
      2,
      '40000',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


