set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9875215';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2,
      0,
      11.395820,
      NULL,
      3,
      5.728329,
      NULL,
      NULL,
      '22141100',
      NULL,
      21,
      '1332241',
      2.259621,
      0.955702,
      0,
      0,
      '2010',
      2,
      1.888060,
      NULL,
      NULL,
      ' 9-28-2001',
      54,
      60,
      NULL,
      NULL,
      3,
      ' 6-29-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 8- 8-1982',
      ' 5-25-1985',
      '11- 4-1974',
      3,
      NULL,
      NULL,
      2.227667,
      NULL,
      NULL,
      7,
      0.429621,
      0.662332,
      8,
      NULL,
      2.450985,
      11.462512,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.983255,
      0,
      0.190229,
      NULL,
      0,
      1.513758,
      1.613449,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      5,
      3,
      3,
      0,
      1,
      2,
      1,
      NULL,
      2,
      5,
      0,
      2,
      2,
      1,
      1.909252,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.848698,
      NULL,
      2,
      1,
      2.655223,
      1,
      2,
      1.827324,
      NULL,
      0.050440,
      3.934957,
      0.222779,
      1.372384,
      3.225139,
      NULL,
      3,
      NULL,
      0,
      0,
      6,
      1,
      2,
      NULL,
      0.149865,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      3,
      5,
      5,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      2,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      0,
      1,
      5,
      1,
      0,
      2,
      NULL,
      1,
      5,
      1,
      0,
      3,
      ' 1-15-1991',
      192.026944,
      '11-23-1988',
      77,
      2.255645,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.927588,
      7.564987,
      NULL,
      1.865364,
      7.013773,
      0.025703,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.737892,
      3.143793,
      1,
      NULL,
      1,
      0.049507,
      23.030986,
      3,
      0.443730,
      NULL,
      NULL,
      NULL,
      3,
      0.902629,
      2.850973,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      1,
      3,
      1,
      NULL,
      2,
      1.224564,
      0.400370,
      1.201071,
      1.428668,
      3.767004,
      NULL,
      NULL,
      0.239970,
      0.064539,
      1.840377,
      NULL,
      1,
      1,
      3,
      0.329003,
      0.378243,
      0.725007,
      10,
      5.187225,
      1,
      11,
      11.246548,
      5,
      NULL,
      1,
      4.762334,
      0.399376,
      NULL,
      2.325075,
      51.462302,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      56,
      0,
      NULL,
      3,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      38.701222,
      21,
      6,
      1,
      NULL,
      NULL,
      3.177574,
      NULL,
      1.439410,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.047054,
      3.656106,
      1,
      1,
      0.084646,
      3.178370,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.332364,
      NULL,
      NULL,
      0.558241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.877038,
      0.326577,
      0.677062,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.599729,
      0,
      NULL,
      1.100089,
      NULL,
      NULL,
      1,
      2.389460,
      3.089475,
      1.986747,
      0.189137,
      0,
      1,
      0,
      2,
      2,
      NULL,
      1,
      1.218794,
      3,
      3.499740,
      1,
      3.209147,
      2.138329,
      2,
      1.221407,
      3.858845,
      NULL,
      1,
      NULL,
      NULL,
      3.979433,
      NULL,
      0.179648,
      7.571587,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.461499,
      NULL,
      NULL,
      NULL,
      0.272789,
      NULL,
      NULL,
      3.318868,
      3,
      NULL,
      0.688229,
      2.169017,
      3.084841,
      0.197310,
      NULL,
      NULL,
      2.750732,
      NULL,
      4.640661,
      1.305834,
      1,
      NULL,
      0.172931,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.931083,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.793462,
      2,
      0,
      1.160563,
      NULL,
      NULL,
      3.352925,
      5.950722,
      7.049367,
      4.480912,
      1.154902,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.008515,
      NULL,
      NULL,
      1.367834,
      4,
      1,
      3,
      0.724716,
      0.896763,
      1,
      NULL,
      1,
      1.830246,
      3.445963,
      2,
      1,
      2.563663,
      NULL,
      1.092488,
      2.841880,
      0,
      3.356459,
      3.693262,
      NULL,
      0,
      0,
      3,
      0.250970,
      0,
      0.267016,
      0,
      1,
      0.718652,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.617789,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.023784,
      NULL,
      NULL,
      0.287384,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      3.769094,
      1,
      NULL,
      NULL,
      0.564412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262841,
      NULL,
      NULL,
      NULL,
      1.718698,
      NULL,
      NULL,
      NULL,
      1.746844,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.135100,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.484294,
      0.037593,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.487686,
      NULL,
      NULL,
      0.226898,
      NULL,
      NULL,
      1.678459,
      NULL,
      NULL,
      1.631388,
      NULL,
      NULL,
      1.350063,
      0,
      0,
      1.569656,
      0,
      1.908715,
      0.297805,
      0,
      0,
      0,
      1,
      0.154666,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1.365455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.722120,
      1.757289,
      1.686481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.598588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.825786,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.042965,
      NULL,
      NULL,
      NULL,
      0.490054,
      1.305518,
      1,
      NULL,
      0.815799,
      NULL,
      0.366536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.069973,
      NULL,
      0,
      NULL,
      0,
      1.507342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649279,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.191119,
      1,
      1.729389,
      1.129617,
      NULL,
      NULL,
      0.390078,
      NULL,
      1,
      1.883652,
      1,
      0.463896,
      0.384851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7.052879,
      2.675316,
      NULL,
      NULL,
      3,
      3.543504,
      1.656851,
      1.182673,
      0.347902,
      1.168227,
      0,
      NULL,
      1.248196,
      0.673845,
      NULL,
      0,
      NULL,
      NULL,
      1.129561,
      NULL,
      NULL,
      1.289677,
      1,
      NULL,
      NULL,
      1.704343,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540155,
      1,
      NULL,
      1.102834,
      1.008397,
      NULL,
      1,
      2,
      NULL,
      1,
      0.384888,
      NULL,
      NULL,
      0.153390,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383930,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      1.408337,
      0.529003,
      1,
      42,
      52.850532,
      5,
      4.992800,
      2.806813,
      '43410',
      '',
      NULL,
      0.035246,
      '',
      '',
      NULL,
      NULL,
      '32003',
      '',
      '');
commit;
end;
/


