set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9505926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      2,
      0.109588,
      2,
      2,
      '2020',
      1.719823,
      1.991440,
      NULL,
      NULL,
      ' 9- 8-1997',
      129.573024,
      NULL,
      NULL,
      2.793587,
      NULL,
      ' 7-14-1990',
      44.140277,
      3,
      172.925544,
      70,
      3,
      ' 1- 4-1984',
      ' 4-25-1993',
      NULL,
      2,
      0,
      1.564840,
      0.199735,
      1.080370,
      1.746354,
      NULL,
      NULL,
      1.346381,
      34,
      8,
      14.133578,
      10,
      NULL,
      NULL,
      2,
      16,
      2,
      3,
      8.846661,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.922945,
      3,
      0,
      1,
      3,
      1,
      2,
      3,
      0,
      4,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      2,
      2,
      1.852466,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      5,
      0.118309,
      3,
      0,
      1.091360,
      1.933466,
      2,
      3.752465,
      1,
      NULL,
      1,
      1.631577,
      1,
      2,
      1,
      0.544973,
      1,
      0,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0.595116,
      1,
      0,
      1,
      1,
      1.678251,
      NULL,
      1.949772,
      2,
      0,
      NULL,
      NULL,
      0,
      5,
      5,
      3,
      0,
      2,
      5,
      0,
      2,
      NULL,
      NULL,
      1,
      5,
      2,
      NULL,
      3,
      4,
      5,
      NULL,
      1,
      0,
      NULL,
      3.104418,
      ' 4-23-1986',
      NULL,
      ' 2-25-1985',
      8.231896,
      3.848426,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.899407,
      1.366434,
      1,
      2,
      NULL,
      1,
      NULL,
      2,
      1.580159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161493,
      2.460004,
      1.437162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.953250,
      0.836332,
      0.848532,
      NULL,
      1.068882,
      0.603245,
      1.768976,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.654206,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      1.898735,
      3,
      3.965969,
      0.132765,
      0,
      NULL,
      NULL,
      1.481879,
      1,
      1,
      1.183260,
      0.150823,
      2,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      10.020518,
      7.290201,
      6,
      10.760889,
      0,
      4.161584,
      3,
      2.341943,
      2.349745,
      2,
      2,
      42.092741,
      2,
      3.345456,
      NULL,
      18,
      49,
      48.472557,
      4,
      NULL,
      3.071948,
      '22130',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      0,
      37.242375,
      NULL,
      45,
      3,
      NULL,
      1,
      4.939675,
      1,
      3.449698,
      2,
      0.142597,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.375486,
      NULL,
      NULL,
      1.494932,
      NULL,
      NULL,
      0.909346,
      NULL,
      NULL,
      0.127966,
      NULL,
      NULL,
      1.731957,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.329716,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.503900,
      0,
      0,
      1.434778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.753128,
      0,
      1.954771,
      2.815994,
      1,
      0,
      3,
      2,
      NULL,
      1,
      0,
      2.080897,
      NULL,
      1.589603,
      NULL,
      3,
      1.108215,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.603298,
      7.702715,
      1.389745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.281019,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.029772,
      NULL,
      NULL,
      10,
      0,
      1.289042,
      NULL,
      2.106201,
      NULL,
      0.616766,
      NULL,
      NULL,
      NULL,
      7,
      0.635983,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.968897,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.090715,
      NULL,
      0.160783,
      1,
      5,
      NULL,
      1,
      NULL,
      NULL,
      1.500319,
      NULL,
      NULL,
      1,
      1.383747,
      0.340109,
      NULL,
      NULL,
      NULL,
      4,
      1.895176,
      NULL,
      0.620228,
      1.129044,
      1.399047,
      0.531826,
      1.790157,
      0,
      0,
      1.402909,
      1,
      0,
      0.533683,
      0,
      4.300362,
      1.188018,
      NULL,
      NULL,
      4,
      0.007049,
      0,
      1,
      2,
      1,
      0.539395,
      1,
      0.036247,
      1,
      1.049076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.854763,
      1,
      0.092396,
      0.642754,
      NULL,
      NULL,
      0.573160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.247535,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.678451,
      NULL,
      NULL,
      NULL,
      2.392390,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465574,
      NULL,
      NULL,
      NULL,
      0,
      10.496564,
      21,
      1.331770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.240861,
      2.142179,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.229706,
      NULL,
      0.252990,
      NULL,
      41.582122,
      1,
      1,
      1.138714,
      1.991474,
      0.435423,
      1,
      NULL,
      0.996005,
      1,
      0,
      0,
      0.210256,
      NULL,
      1,
      1,
      NULL,
      1.645558,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.163672,
      0.486479,
      0,
      5.779313,
      2,
      NULL,
      1.483602,
      0.946198,
      NULL,
      0,
      NULL,
      0.403903,
      1.215000,
      1,
      NULL,
      1,
      0.419681,
      1.350045,
      2.148710,
      0,
      0.566156,
      0.085683,
      1,
      NULL,
      0.284711,
      0,
      0,
      1.857693,
      1.597302,
      0.604841,
      1,
      1,
      1,
      3,
      0.542764,
      0,
      0,
      0,
      1.309642,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.459190,
      1.026081,
      4,
      NULL,
      5,
      0.409941,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      3,
      2.986330,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.663845,
      '',
      '',
      NULL);
commit;
end;
/


