set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7420666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '4434343',
      0.778271,
      1,
      NULL,
      1,
      '4001',
      1.897883,
      0.402032,
      NULL,
      NULL,
      ' 3-11-1999',
      69,
      NULL,
      2,
      2,
      0,
      ' 4-26-1982',
      87.511075,
      3.109661,
      300,
      60,
      NULL,
      NULL,
      ' 7-26-1982',
      ' 9- 8-1996',
      0.380426,
      0.627153,
      0,
      NULL,
      1,
      3.303221,
      4,
      NULL,
      1,
      269.540658,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0.153340,
      0,
      0,
      NULL,
      0.713345,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      71,
      4,
      2,
      0,
      1.525481,
      NULL,
      NULL,
      4,
      0,
      0,
      1,
      0,
      1,
      2,
      3,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.609527,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.899313,
      2.423093,
      0,
      2.443256,
      0,
      NULL,
      1.517522,
      2.437507,
      0,
      1.724532,
      1,
      1.551787,
      1,
      NULL,
      0.342403,
      3.290805,
      0,
      3,
      3,
      1.023685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      0,
      0,
      3,
      2,
      0,
      3,
      2,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0.530930,
      NULL,
      0.519601,
      1,
      3,
      0,
      1,
      0,
      5,
      3,
      NULL,
      0,
      4,
      0,
      1,
      1,
      3,
      1,
      NULL,
      0,
      2,
      0,
      1,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      ' 4-13-1974',
      1556,
      ' 6- 1-1989',
      1677,
      1.383318,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      5,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860909,
      NULL,
      2,
      1.228928,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.694788,
      0.334016,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.761542,
      NULL,
      1,
      NULL,
      NULL,
      2643,
      NULL,
      1.703378,
      NULL,
      386.315657,
      1590.603557,
      NULL,
      0.934397,
      1.573945,
      1,
      1,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      2.180348,
      2,
      3.688643,
      2,
      1.919584,
      0.090508,
      NULL,
      NULL,
      1,
      NULL,
      1.019250,
      NULL,
      1,
      1.289435,
      0,
      0,
      NULL,
      NULL,
      1,
      7.923342,
      1,
      4.238212,
      1,
      1,
      6.193120,
      3,
      2,
      1.319673,
      1,
      0.389563,
      0,
      NULL,
      0,
      2,
      NULL,
      13,
      0,
      29,
      NULL,
      NULL,
      0,
      '44323',
      NULL,
      '',
      1.470169,
      '',
      '',
      '',
      NULL,
      '00014',
      '41240',
      '',
      2.021908,
      10,
      464,
      20.343399,
      1.941922,
      NULL,
      NULL,
      NULL,
      NULL,
      1.324288,
      1,
      1.022747,
      0,
      1,
      0,
      1.479771,
      1.107386,
      NULL,
      0,
      1.219616,
      0.251272,
      1.580985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.744463,
      0.222742,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      2.214366,
      0,
      NULL,
      3,
      0.316079,
      0,
      NULL,
      NULL,
      NULL,
      1.761439,
      6,
      0.337963,
      0,
      0.110000,
      NULL,
      NULL,
      NULL,
      0.594844,
      NULL,
      NULL,
      NULL,
      1.592264,
      3.188141,
      0,
      1.456673,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.742645,
      0.190148,
      NULL,
      NULL,
      3,
      1,
      1,
      0.285800,
      1.023164,
      2,
      0,
      0.106534,
      1.687502,
      0.182553,
      0,
      NULL,
      NULL,
      NULL,
      2.353588,
      0.392082,
      1.223306,
      0.668204,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.355621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.727053,
      NULL,
      NULL,
      3.610458,
      1.449930,
      NULL,
      NULL,
      9,
      0.521478,
      0.104626,
      2.321041,
      2.253133,
      2,
      3.956160,
      NULL,
      0.129761,
      NULL,
      1.725934,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.298467,
      NULL,
      NULL,
      1.383769,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      7.352425,
      5,
      NULL,
      0.901130,
      0,
      5.394903,
      2.791906,
      7,
      2.503797,
      1,
      NULL,
      1.576798,
      NULL,
      3.007712,
      1,
      NULL,
      NULL,
      11.991590,
      NULL,
      4.175160,
      0.627529,
      1.222463,
      1.427500,
      1,
      NULL,
      1,
      3.664404,
      NULL,
      1,
      0.341222,
      NULL,
      3,
      8,
      1,
      7,
      NULL,
      8.748263,
      9.673847,
      NULL,
      2,
      NULL,
      1,
      0.695654,
      NULL,
      1,
      0.280763,
      NULL,
      NULL,
      NULL,
      0.559265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.477415,
      NULL,
      NULL,
      1.634970,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.118085,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.892434,
      1,
      0.868540,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.640318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.295894,
      NULL,
      NULL,
      NULL,
      2.869138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.125880,
      NULL,
      NULL,
      NULL,
      3,
      3,
      8,
      2,
      2.912809,
      486.094487,
      143.880382,
      NULL,
      NULL,
      NULL,
      0.568183,
      NULL,
      NULL,
      1.045226,
      NULL,
      NULL,
      3.344079,
      21.255456,
      15,
      1,
      86.512215,
      17,
      3.109977,
      64,
      2,
      383.987290,
      NULL,
      1.503571,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      0.536671,
      0,
      1,
      1.439308,
      1.204319,
      NULL,
      1.494254,
      0.998261,
      0.961588,
      1.654766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.648854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      2.257001,
      NULL,
      1.182134,
      NULL,
      3,
      2.721783,
      3,
      NULL,
      0,
      1.330078,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.842917,
      NULL,
      1.977675,
      0.609764,
      NULL,
      1,
      0.325494,
      NULL,
      0.182775,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0.934123,
      0.218095,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      4,
      2,
      1.395923,
      2.092900,
      3.250875,
      21.460226,
      7.086463,
      0,
      0,
      3.433473,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      5,
      '41214',
      NULL,
      '');
commit;
end;
/


