set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9532151';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '1320001',
      3.988717,
      0,
      NULL,
      1,
      '4113',
      0.942600,
      1.212184,
      NULL,
      NULL,
      ' 8-12-1978',
      47.683546,
      NULL,
      1,
      1,
      2.358458,
      ' 6- 0-1996',
      21.969520,
      NULL,
      8,
      141,
      3,
      ' 0-12-1987',
      ' 9- 1-1976',
      '11-23-1980',
      NULL,
      NULL,
      2.035162,
      0.812161,
      1,
      0.243982,
      NULL,
      0,
      1.265723,
      34,
      5,
      10,
      2,
      26,
      8,
      NULL,
      20.569717,
      5,
      0,
      NULL,
      0.269100,
      0,
      NULL,
      0.957782,
      0,
      0.722880,
      0.530534,
      0.703157,
      NULL,
      1.266257,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      2,
      1,
      0.005371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.552510,
      1.288580,
      1.578955,
      1,
      2,
      0.435424,
      1,
      1,
      1.283388,
      1,
      1,
      0,
      0.528306,
      3.912345,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2,
      2.450586,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810561,
      NULL,
      NULL,
      0,
      5,
      1,
      1,
      2,
      2,
      2,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      4,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0.806053,
      0,
      1,
      0,
      1,
      NULL,
      2,
      5,
      1,
      0,
      0,
      3,
      1,
      4,
      NULL,
      NULL,
      1,
      4,
      4,
      0,
      4,
      3,
      NULL,
      3,
      3,
      1,
      4.693036,
      0.962089,
      '11-27-2000',
      114.873489,
      ' 5-21-1974',
      NULL,
      0.307252,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.707868,
      NULL,
      NULL,
      0.387734,
      NULL,
      NULL,
      NULL,
      NULL,
      1.171792,
      1.486770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.281716,
      0.038954,
      0.575932,
      1,
      1.990185,
      0.654516,
      1,
      2,
      20.099809,
      1.407440,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      1,
      2,
      0,
      3,
      3,
      NULL,
      13.643238,
      19.416405,
      NULL,
      NULL,
      0,
      3.651060,
      1,
      NULL,
      1,
      0.629971,
      1.345745,
      0,
      0.146768,
      1.223179,
      0,
      NULL,
      7,
      1,
      9,
      NULL,
      6,
      1.811289,
      NULL,
      5,
      5,
      2.067319,
      NULL,
      0.005015,
      0,
      3,
      36,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      3,
      0.043146,
      1.954868,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.568586,
      '',
      '',
      '',
      1,
      40,
      23,
      34,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.372350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1.947544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      2,
      1,
      0.503370,
      1,
      0.540588,
      1.064512,
      1.775010,
      3.396544,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.799700,
      4.596858,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.292963,
      2,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.742214,
      4.391682,
      0.262212,
      2.072341,
      2,
      2.279322,
      0.586748,
      NULL,
      NULL,
      2.113814,
      4,
      0.210470,
      NULL,
      NULL,
      NULL,
      1.384156,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150549,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.282053,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.838991,
      2,
      2,
      0.129150,
      1.415760,
      3.052929,
      3.403940,
      2.370757,
      3.438645,
      5.173582,
      0,
      2.380985,
      NULL,
      1.919195,
      3,
      2.557455,
      3.466014,
      NULL,
      NULL,
      3.213000,
      0,
      0.209875,
      3,
      3.946886,
      7.308682,
      6.026966,
      NULL,
      4,
      NULL,
      1.376045,
      1,
      4,
      0,
      0.489899,
      0.307503,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1.033375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249148,
      NULL,
      NULL,
      1.197546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.317614,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.335276,
      3,
      NULL,
      NULL,
      1.730432,
      1.484697,
      0.164585,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.602361,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.887198,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.524880,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.768534,
      1.332670,
      NULL,
      0,
      8,
      0.379879,
      0,
      NULL,
      NULL,
      1,
      1.801977,
      0.969759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0.969923,
      1,
      0.433556,
      0.243794,
      NULL,
      1,
      NULL,
      1.157895,
      NULL,
      NULL,
      0,
      0.979291,
      0,
      1,
      0.435778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233355,
      1.974180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.307117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.564423,
      NULL,
      0.468432,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.380443,
      NULL,
      1,
      NULL,
      0.958030,
      1.962147,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1.943473,
      1,
      NULL,
      2,
      1.716643,
      2,
      NULL,
      1.956858,
      0.688314,
      NULL,
      1.386089,
      0.440611,
      NULL,
      1,
      0.729939,
      NULL,
      1.846113,
      0.703003,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0.678661,
      NULL,
      NULL,
      1,
      0.040957,
      NULL,
      1,
      0,
      NULL,
      1.737631,
      0,
      NULL,
      NULL,
      1.222674,
      NULL,
      2,
      1.393114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.229665,
      NULL,
      0.993740,
      NULL,
      0,
      NULL,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      22.693702,
      122.437247,
      2,
      4,
      NULL,
      '02423',
      '',
      NULL,
      0.321418,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


