set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9705629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '42',
      NULL,
      44,
      NULL,
      3.491383,
      NULL,
      3,
      1,
      '3100',
      5.403210,
      NULL,
      NULL,
      NULL,
      ' 8- 0-1988',
      20,
      64,
      NULL,
      NULL,
      NULL,
      ' 4-15-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 8-28-1996',
      NULL,
      1,
      1.484685,
      1.573450,
      1,
      1,
      1.865664,
      0,
      1,
      1,
      3,
      6,
      3.342226,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.884397,
      NULL,
      1.398807,
      NULL,
      0.483975,
      NULL,
      1.312584,
      1.202151,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      0,
      0,
      3,
      1,
      0,
      2,
      NULL,
      NULL,
      9.697205,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      0,
      2.934070,
      1.620439,
      1,
      2,
      1.153529,
      1,
      2,
      1.641743,
      0,
      1.870908,
      1,
      1,
      NULL,
      1.264530,
      3.180179,
      NULL,
      0,
      NULL,
      4,
      5,
      0,
      0,
      1.578917,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      3,
      NULL,
      1,
      3,
      4,
      1,
      1,
      2,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      2,
      4,
      1,
      3,
      1,
      3,
      3,
      0,
      1,
      0,
      0.969527,
      0.317434,
      NULL,
      288,
      ' 2-21-1978',
      103,
      0.845875,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      2,
      0,
      0.601364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.553442,
      1.878377,
      NULL,
      1.143759,
      NULL,
      1.966564,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.631651,
      NULL,
      1,
      0.349925,
      0.112189,
      27,
      0.269063,
      1.276450,
      NULL,
      NULL,
      NULL,
      1,
      0.185809,
      1,
      0,
      2,
      1,
      3,
      3,
      0,
      NULL,
      3,
      NULL,
      1,
      4,
      1.638225,
      0,
      0,
      1,
      1.667258,
      1.601351,
      NULL,
      0,
      0.653714,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      7.074735,
      10.559313,
      NULL,
      3,
      0.327736,
      1,
      1.597540,
      NULL,
      5,
      2,
      2.547868,
      3,
      34.490775,
      3,
      2.002824,
      NULL,
      NULL,
      7,
      8.672664,
      4,
      NULL,
      2,
      '33424',
      '03301',
      NULL,
      0,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      4,
      10.692901,
      1.307512,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.395407,
      2.557752,
      0,
      NULL,
      NULL,
      0.039316,
      NULL,
      NULL,
      1.140787,
      NULL,
      NULL,
      1.696974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.279481,
      3,
      3,
      1,
      NULL,
      NULL,
      3.542612,
      2.631488,
      3,
      2,
      1.463888,
      2,
      NULL,
      NULL,
      NULL,
      0.450992,
      NULL,
      NULL,
      4.402359,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.468595,
      1,
      NULL,
      2.490697,
      3,
      2.377294,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.532206,
      NULL,
      NULL,
      1.849192,
      1.404992,
      NULL,
      NULL,
      2.043721,
      NULL,
      0,
      1.612531,
      1.111724,
      0,
      0.320017,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.718966,
      1.301320,
      8.847340,
      7.134679,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.049379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083841,
      0,
      NULL,
      NULL,
      2.067563,
      0.894890,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0.590058,
      3.532797,
      1.321928,
      0.267852,
      3.505812,
      NULL,
      3,
      NULL,
      1.642330,
      NULL,
      NULL,
      0.434414,
      NULL,
      NULL,
      1.207365,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.857377,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.219143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401302,
      NULL,
      NULL,
      0.349646,
      NULL,
      NULL,
      1.213158,
      NULL,
      NULL,
      0,
      1,
      3.874434,
      0,
      NULL,
      NULL,
      3.111725,
      0.041452,
      4.225526,
      0.790755,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.137434,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.169187,
      NULL,
      0,
      1.772449,
      NULL,
      1.274112,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.905630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333004,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.755204,
      0,
      0,
      0.483392,
      1,
      0.993729,
      NULL,
      NULL,
      1.124587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.310795,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.706004,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.514484,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.919500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.751940,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      3,
      1,
      0,
      0.505075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      70.003664,
      5.232500,
      1,
      0.954089,
      1,
      1.048335,
      1.051804,
      1.655832,
      1,
      0.470011,
      NULL,
      NULL,
      0.057670,
      1.793862,
      1.448882,
      1.431629,
      1,
      1.863293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460239,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.046874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813432,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.790837,
      NULL,
      0.444947,
      1,
      0.899327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.058514,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.374903,
      3,
      0,
      NULL,
      NULL,
      3,
      NULL,
      359.936184,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.396305,
      NULL,
      1,
      NULL,
      18,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.175684,
      0.668151,
      1.199377,
      1.275683,
      1,
      NULL,
      NULL,
      0.482897,
      1,
      0.455232,
      NULL,
      NULL,
      NULL,
      1.494628,
      NULL,
      NULL,
      2.393702,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895187,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.292717,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.382119,
      1.606966,
      1.111131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980313,
      NULL,
      1.097598,
      NULL,
      0.364268,
      NULL,
      4,
      0,
      NULL,
      1.371552,
      NULL,
      NULL,
      18.958616,
      10,
      NULL,
      1.507204,
      0.936924,
      NULL,
      '01132',
      '',
      0.246895,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


