set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9705629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.175607,
      0,
      1.085159,
      5,
      NULL,
      0.429776,
      NULL,
      1,
      '033',
      '22423203',
      31,
      NULL,
      '3414144',
      4,
      0,
      1,
      0,
      '4413',
      3.876673,
      0,
      NULL,
      NULL,
      ' 2- 1-1977',
      134.924641,
      NULL,
      NULL,
      1.711858,
      NULL,
      ' 3- 2-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-25-1977',
      2.309854,
      NULL,
      1,
      NULL,
      1.007857,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      1,
      0.890597,
      0,
      1,
      0,
      0,
      0,
      1.862933,
      0.239719,
      0,
      NULL,
      NULL,
      0.189682,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      0,
      0,
      NULL,
      0,
      1.810107,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.015661,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.795345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.771693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      3,
      3,
      NULL,
      0,
      1,
      0,
      3,
      NULL,
      1.485122,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      ' 2-19-1979',
      NULL,
      ' 4-27-1991',
      5,
      2.219614,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.298010,
      NULL,
      0,
      1.236565,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.913057,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.528492,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.309979,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      2.434688,
      1.050705,
      NULL,
      NULL,
      NULL,
      1,
      1.856030,
      0,
      0,
      3,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      3,
      0,
      0,
      2.989999,
      2,
      0.552968,
      1,
      1.498966,
      NULL,
      NULL,
      0,
      3.016489,
      1.405872,
      1.231844,
      1.080397,
      NULL,
      1,
      0,
      0.345572,
      3.851583,
      1.508439,
      7.482147,
      5.800402,
      0,
      2,
      NULL,
      5.834670,
      0.150305,
      3,
      5,
      NULL,
      0,
      3,
      NULL,
      0,
      1,
      42,
      NULL,
      NULL,
      NULL,
      4,
      3.088806,
      1,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.729474,
      '',
      '',
      '',
      1,
      17.023483,
      NULL,
      NULL,
      2,
      47,
      1.769358,
      1,
      1,
      NULL,
      1.185920,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.400805,
      1.005992,
      0.144616,
      NULL,
      NULL,
      1.253764,
      NULL,
      NULL,
      1,
      NULL,
      2.160673,
      0,
      2,
      1.467338,
      1.582361,
      NULL,
      1.319933,
      0,
      2,
      NULL,
      1,
      2.417185,
      NULL,
      3,
      1.254969,
      1,
      5.675796,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.073546,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544900,
      3,
      NULL,
      1,
      2,
      1.771557,
      NULL,
      NULL,
      0.754686,
      1.260308,
      0,
      1.171131,
      2,
      2.553357,
      1.207184,
      0.079477,
      0,
      1,
      1.291215,
      1.276171,
      3.903393,
      0.942953,
      NULL,
      1.498449,
      0.437112,
      NULL,
      NULL,
      1,
      0.082927,
      1,
      3.934225,
      0.363973,
      0.283474,
      NULL,
      6.575056,
      1.659702,
      NULL,
      1.441252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.778247,
      NULL,
      NULL,
      0.222373,
      NULL,
      NULL,
      0.641114,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0.604865,
      0,
      3.440124,
      0.789471,
      6.568263,
      4,
      5.669743,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466194,
      NULL,
      NULL,
      0.337706,
      NULL,
      NULL,
      0.220717,
      NULL,
      NULL,
      0.551850,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.445607,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.448978,
      NULL,
      NULL,
      0,
      3,
      3.131675,
      1,
      0.586761,
      3.160194,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0,
      1,
      1,
      1.020742,
      1.786004,
      3.007456,
      1,
      1.150088,
      0,
      1,
      5.718638,
      1.850844,
      NULL,
      NULL,
      3.863848,
      2,
      2,
      0.368334,
      0,
      1,
      NULL,
      1.676861,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.977677,
      NULL,
      NULL,
      1.602908,
      NULL,
      NULL,
      2.757437,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.210691,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.423113,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0.908450,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101776,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.441339,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.755711,
      1.737360,
      NULL,
      NULL,
      1.387175,
      1.402491,
      NULL,
      NULL,
      2.152951,
      2.176635,
      NULL,
      NULL,
      0.501759,
      NULL,
      NULL,
      NULL,
      0.851796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.430771,
      1.322190,
      NULL,
      NULL,
      0,
      0.784247,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.942997,
      NULL,
      NULL,
      NULL,
      1.878449,
      30.840427,
      69.667857,
      0,
      NULL,
      NULL,
      1.807580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232242,
      NULL,
      NULL,
      1.143802,
      NULL,
      NULL,
      0.843030,
      NULL,
      0,
      77.103939,
      10.980112,
      1,
      0.870084,
      0.424067,
      1.880277,
      0,
      0.857794,
      1,
      1,
      1.508565,
      1,
      1.306976,
      NULL,
      NULL,
      1.962950,
      0,
      0,
      0.161015,
      1.183199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174598,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.252668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213885,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.765097,
      NULL,
      1,
      1.598412,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.956210,
      NULL,
      NULL,
      1.317255,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242970,
      3,
      NULL,
      0.347938,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.572275,
      NULL,
      0.687569,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924947,
      NULL,
      NULL,
      NULL,
      1.889598,
      0.148796,
      1,
      28.103921,
      44,
      1.102275,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.291508,
      NULL,
      0.000268,
      1.788631,
      0,
      1.118990,
      NULL,
      1.326859,
      NULL,
      NULL,
      NULL,
      2.902708,
      1,
      NULL,
      3.887149,
      0,
      NULL,
      3,
      1,
      0.398193,
      0,
      1.087373,
      1,
      0,
      2.972799,
      0.990838,
      0,
      NULL,
      1,
      1,
      1.729108,
      NULL,
      1.912572,
      0.376969,
      0,
      1.436896,
      1,
      NULL,
      2.946340,
      NULL,
      0,
      0.873221,
      2.202678,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029594,
      1.683353,
      1.411762,
      0,
      1,
      2,
      0,
      NULL,
      1.547153,
      NULL,
      NULL,
      NULL,
      15,
      1,
      NULL,
      3.642577,
      '40233',
      '40222',
      '',
      1,
      '',
      '',
      '',
      1.986501,
      NULL,
      '',
      '');
commit;
end;
/


